/*
 * Decompiled with CFR 0.152.
 */
package ch.docbox.elexis;

import ch.docbox.cdach.DocboxCDA;
import ch.docbox.elexis.DocboxAction;
import ch.docbox.elexis.DocboxView;
import ch.docbox.elexis.Messages;
import ch.docbox.elexis.UserDocboxPreferences;
import ch.docbox.ws.cdachservices.CDACHServices;
import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.data.events.ElexisEventDispatcher;
import ch.elexis.core.model.FallConstants;
import ch.elexis.core.model.prescription.EntryType;
import ch.elexis.core.text.model.Samdas;
import ch.elexis.core.ui.UiDesk;
import ch.elexis.core.ui.util.Log;
import ch.elexis.data.Fall;
import ch.elexis.data.Konsultation;
import ch.elexis.data.Kontakt;
import ch.elexis.data.LabResult;
import ch.elexis.data.Patient;
import ch.elexis.data.Prescription;
import ch.elexis.data.Query;
import ch.rgw.tools.ExHandler;
import ch.rgw.tools.StringTool;
import ch.rgw.tools.TimeTool;
import ch.swissmedicalsuite.HCardBrowser;
import jakarta.xml.ws.Holder;
import java.util.Date;
import java.util.List;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.hl7.v3.ClinicalDocumentType;
import org.hl7.v3.POCDMT000040Author;
import org.hl7.v3.POCDMT000040Custodian;
import org.hl7.v3.POCDMT000040RecordTarget;

public class DocboxHospitalReferralAction
extends DocboxAction {
    private IWorkbenchWindow window;
    private Patient patient;
    private Fall fall;
    public boolean meinPatient = false;
    protected static Log log = Log.get((String)"DocboxHospitalReferralAction");

    private LabResult getLatestLabResult(String name, List<LabResult> list) {
        TimeTool ttLabResult = new TimeTool();
        LabResult labResult = null;
        if (list != null && name != null) {
            for (LabResult result : list) {
                String label = result.getItem().getName();
                if (!name.equals(label)) continue;
                if (labResult == null) {
                    labResult = result;
                    ttLabResult.setDate(labResult.getDate());
                    continue;
                }
                if (result.getDate() == null) continue;
                TimeTool ttResult = new TimeTool();
                ttResult.setDate(result.getDate());
                if (!ttResult.isAfter(ttLabResult)) continue;
                ttLabResult = ttResult;
                labResult = result;
            }
        }
        return labResult;
    }

    public void run(IAction action) {
        try {
            if (CoreHub.getLoggedInContact() != null) {
                this.patient = ElexisEventDispatcher.getSelectedPatient();
                if (this.patient == null) {
                    MessageBox box = new MessageBox(UiDesk.getDisplay().getActiveShell(), 1);
                    box.setText(Messages.DocboxHospitalReferralAction_NoPatientSelectedText);
                    box.setMessage(Messages.DocboxHospitalReferralAction_NoPatientSelectedMessage);
                    box.open();
                    return;
                }
                this.fall = (Fall)ElexisEventDispatcher.getSelected(Fall.class);
                Konsultation konsultation = (Konsultation)ElexisEventDispatcher.getSelected(Konsultation.class);
                if (this.fall == null) {
                    if (konsultation == null || konsultation.getFall() != this.fall) {
                        konsultation = this.patient.getLetzteKons(false);
                    }
                    if (konsultation != null) {
                        this.fall = konsultation.getFall();
                    }
                }
                if (konsultation == null && this.fall != null) {
                    konsultation = this.fall.getLetzteBehandlung();
                }
                final Konsultation kons = konsultation;
                if (!this.hasValidDocboxCredentials()) {
                    return;
                }
                Runnable longJob = new Runnable(){
                    boolean done = false;

                    @Override
                    public void run() {
                        Thread thread = new Thread(new Runnable(){

                            @Override
                            public void run() {
                                log.log("job started", 5);
                                try {
                                    DocboxHospitalReferralAction.this.makeReferral(kons);
                                }
                                catch (Exception e) {
                                    log.log("excetion in makereferral", 5);
                                    log.log(e.toString(), 5);
                                }
                                log.log("job done", 5);
                                done = true;
                                if (UiDesk.getDisplay().isDisposed()) {
                                    return;
                                }
                                UiDesk.getDisplay().wake();
                            }
                        });
                        log.log("thread starting", 5);
                        thread.start();
                        while (!this.done) {
                            if (UiDesk.getDisplay().readAndDispatch()) continue;
                            UiDesk.getDisplay().sleep();
                        }
                        log.log("thread ended", 5);
                    }
                };
                BusyIndicator.showWhile((Display)UiDesk.getDisplay(), (Runnable)longJob);
                if (UserDocboxPreferences.useHCard()) {
                    HCardBrowser hCardBrowser = new HCardBrowser(UserDocboxPreferences.getDocboxLoginID(false), UserDocboxPreferences.getDocboxBrowserUrl());
                    if (this.meinPatient) {
                        hCardBrowser.setMyPatient();
                    } else {
                        hCardBrowser.setHospitalReferral();
                    }
                } else {
                    DocboxView docboxView = (DocboxView)this.window.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("ch.docbox.elexis.DocboxView");
                    if (docboxView != null) {
                        if (this.meinPatient) {
                            docboxView.setMyPatient();
                        } else {
                            docboxView.setHospitalReferral();
                        }
                    }
                }
            }
        }
        catch (PartInitException e) {
            log.log((Throwable)e, "runaction", 5);
        }
    }

    private void makeReferral(Konsultation konsultation) {
        DocboxCDA docboxCDA = new DocboxCDA();
        log.log("invoking makeReferral", 5);
        try {
            log.log("addMedikamente", 5);
            this.addMedikamente(this.patient, docboxCDA);
            log.log("addAllergien", 5);
            this.addAllergien(this.patient, docboxCDA);
            log.log("addDiagnose", 5);
            this.addDiagnose(this.patient, docboxCDA);
            log.log("addAnamnese", 5);
            this.addAnamnese(konsultation, docboxCDA);
            log.log("addPersoenlicheAnamnese", 5);
            this.addPersoenlicheAnamnese(this.patient, docboxCDA);
            log.log("addEinweisungsgrund", 5);
            this.addEinweisungsgrund(this.fall, docboxCDA);
            log.log("addVersicherung", 5);
            this.addVersicherung(this.fall, docboxCDA);
            log.log("addLabordaten", 5);
            this.addLaborDaten(this.patient, docboxCDA);
            log.log("addBemerkungen", 5);
            this.addBemerkungen(this.patient, docboxCDA);
        }
        catch (Exception e) {
            log.log((Throwable)e, "makereferral", 5);
        }
        Date birthday = null;
        if (!"".equals(this.patient.getGeburtsdatum())) {
            TimeTool ttBirthday = new TimeTool(this.patient.getGeburtsdatum());
            birthday = ttBirthday.getTime();
        }
        String phone = this.patient.get("Telefon1");
        String phone2 = this.patient.get("Telefon2");
        POCDMT000040RecordTarget recordTarget = docboxCDA.getRecordTarget(this.patient.getPatCode(), null, this.patient.getAnschrift().getStrasse(), this.patient.getAnschrift().getPlz(), this.patient.getAnschrift().getOrt(), phone, phone2, this.patient.getNatel(), this.patient.getMailAddress(), this.patient.getVorname(), this.patient.getName(), "w".equals(this.patient.getGeschlecht()), "m".equals(this.patient.getGeschlecht()), false, birthday);
        POCDMT000040Author author = docboxCDA.getAuthor(CoreHub.actMandant.get("Titel"), CoreHub.actMandant.getVorname(), CoreHub.actMandant.getName(), CoreHub.actMandant.getNatel(), null, null, CoreHub.actMandant.getMailAddress(), null, null, null);
        POCDMT000040Custodian custodian = docboxCDA.getCustodian(null, null, null, null, null, null);
        log.log("Invoking addReferral for patient " + this.patient.getVorname() + " " + this.patient.getName(), 5);
        ClinicalDocumentType _addReferral_document = new ClinicalDocumentType();
        _addReferral_document.setClinicalDocument(docboxCDA.getClinicalDocument("", recordTarget, author, custodian, null, docboxCDA.getCodeReferral(), null, null));
        log.log(docboxCDA.marshallIntoString(_addReferral_document.getClinicalDocument()), 5);
        byte[] _addReferral_attachment = new byte[]{};
        Holder _addReferral_success = new Holder();
        Holder _addReferral_message = new Holder();
        Holder _addReferral_documentID = new Holder();
        CDACHServices port = UserDocboxPreferences.getPort();
        port.addReferral(_addReferral_document, _addReferral_attachment, (Holder<Boolean>)_addReferral_success, (Holder<String>)_addReferral_message, (Holder<String>)_addReferral_documentID);
        log.log("makeReferral ended...", 5);
        log.log("addReferral._addReferral_success=" + String.valueOf(_addReferral_success.value), 5);
        log.log("addReferral._addReferral_message=" + (String)_addReferral_message.value, 5);
        log.log("addReferral._addReferral_documentID=" + (String)_addReferral_documentID.value, 5);
    }

    private void addLaborDaten(Patient patient, DocboxCDA docboxCDA) {
        try {
            Query qbe = new Query(LabResult.class);
            qbe.add("PatientID", "=", patient.getId());
            List list = qbe.execute();
            LabResult result = this.getLatestLabResult("Thrombozyten", list);
            if (result != null) {
                docboxCDA.addThrombozyten(result.getResult());
            }
            if ((result = this.getLatestLabResult("Kreatinin", list)) != null) {
                docboxCDA.addKreatininwert(result.getResult());
            }
        }
        catch (Exception e) {
            log.log((Throwable)e, "addLaborDaten", 5);
            ExHandler.handle((Throwable)e);
        }
    }

    private void addVersicherung(Fall fall, DocboxCDA docboxCDA) {
        if (fall != null) {
            Kontakt costBearer = fall.getCostBearer();
            if ("UVG".equals(fall.getAbrechnungsSystem())) {
                try {
                    if (costBearer != null) {
                        docboxCDA.addUnfallversicherung(costBearer.getLabel());
                    }
                }
                catch (Exception e) {
                    log.log((Throwable)e, "addUnfallversicherung", 5);
                    ExHandler.handle((Throwable)e);
                }
                try {
                    docboxCDA.addUnfallversicherungPolicenummer(fall.getRequiredString("Unfallnummer"));
                }
                catch (Exception e) {
                    log.log((Throwable)e, "Unfallnummer", 5);
                    ExHandler.handle((Throwable)e);
                }
            }
            if ("KVG".equals(fall.getAbrechnungsSystem())) {
                try {
                    if (costBearer != null) {
                        docboxCDA.addKrankenkasse(costBearer.getLabel());
                    }
                }
                catch (Exception e) {
                    log.log((Throwable)e, "addKrankenkasse", 5);
                    ExHandler.handle((Throwable)e);
                }
                try {
                    docboxCDA.addKrankenkassePolicenummer(fall.getRequiredString("Versicherungsnummer"));
                }
                catch (Exception e) {
                    log.log((Throwable)e, "addKrankenkassePolicenummer", 5);
                    ExHandler.handle((Throwable)e);
                }
            }
        }
    }

    private void addEinweisungsgrund(Fall fall, DocboxCDA docboxCDA) {
        if (fall != null) {
            if (FallConstants.TYPE_DISEASE.equals(fall.getGrund())) {
                docboxCDA.addEinweisungsgrund("Krankheit");
            } else if (FallConstants.TYPE_ACCIDENT.equals(fall.getGrund())) {
                docboxCDA.addEinweisungsgrund("Unfall");
            } else if (FallConstants.TYPE_MATERNITY.equals(fall.getGrund())) {
                docboxCDA.addEinweisungsgrund("Mutterschaft");
            } else if (FallConstants.TYPE_OTHER.equals(fall.getGrund())) {
                docboxCDA.addEinweisungsgrund("Anderer");
            }
        }
    }

    private void addAnamnese(Konsultation konsultation, DocboxCDA docboxCDA) {
        if (konsultation != null && konsultation.getEintrag() != null) {
            String anamnese = konsultation.getEintrag().getHead();
            Samdas samdas = new Samdas(anamnese);
            if (!StringTool.isNothing((Object)(anamnese = samdas.getRecordText()))) {
                docboxCDA.addAnamnese(anamnese);
            }
        }
    }

    private void addPersoenlicheAnamnese(Patient patient, DocboxCDA docboxCDA) {
        String anamnese = patient.getPersAnamnese();
        if (!StringTool.isNothing((Object)anamnese)) {
            docboxCDA.addPerseoenlicheAnamnese(anamnese);
        }
    }

    private void addDiagnose(Patient patient, DocboxCDA docboxCDA) {
        String diagnose = patient.getDiagnosen();
        if (!StringTool.isNothing((Object)diagnose)) {
            docboxCDA.addDiagnose(diagnose);
        }
    }

    private void addBemerkungen(Patient patient, DocboxCDA docboxCDA) {
        String bemerkung = patient.getBemerkung();
        if (!StringTool.isNothing((Object)bemerkung)) {
            docboxCDA.addErgaenzungenLeistung(bemerkung);
        }
    }

    private void addAllergien(Patient patient, DocboxCDA docboxCDA) {
        String risks = patient.get("Allergien");
        if (!StringTool.isNothing((Object)risks)) {
            docboxCDA.addAllergien(true, risks);
        }
    }

    private void addMedikamente(Patient patient, DocboxCDA docboxCDA) {
        List prescriptions = patient.getMedication(new EntryType[]{EntryType.FIXED_MEDICATION});
        if (prescriptions != null && !prescriptions.isEmpty()) {
            String[] medikamente = new String[prescriptions.size()];
            int i = 0;
            while (i < prescriptions.size()) {
                medikamente[i] = ((Prescription)prescriptions.get(i)).getLabel();
                ++i;
            }
            docboxCDA.addMedikamente(medikamente);
        }
    }

    @Override
    public void selectionChanged(IAction action, ISelection selection) {
    }

    @Override
    public void dispose() {
    }

    @Override
    public void init(IWorkbenchWindow window) {
        this.window = window;
    }
}

