/*
 * Decompiled with CFR 0.152.
 */
package ch.docbox.model;

import ch.elexis.data.Kontakt;
import ch.elexis.data.Organisation;
import ch.elexis.data.PersistentObject;
import ch.elexis.data.Person;
import ch.elexis.data.Query;
import ch.rgw.tools.JdbcLink;
import ch.rgw.tools.VersionInfo;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;

public class DocboxContact
extends PersistentObject {
    public static final String TABLENAME = "CH_DOCBOX_ELEXIS_CONTACT_JOINT";
    public static final String FLD_DOCBOX_ID = "DocboxId";
    public static final String FLD_CONTACT_ID = "ContactId";
    public static final String VERSION = "1.0.0";
    static final String createDB = "CREATE TABLE CH_DOCBOX_ELEXIS_CONTACT_JOINT(ID VARCHAR(25) primary key,lastupdate BIGINT,deleted CHAR(1) default '0',DocboxId VARCHAR(255),ContactId VARCHAR(255));INSERT INTO CH_DOCBOX_ELEXIS_CONTACT_JOINT (ID,DocboxId) VALUES (" + JdbcLink.wrap((String)"VERSION") + "," + JdbcLink.wrap((String)"1.0.0") + ");";

    static {
        DocboxContact.addMapping((String)TABLENAME, (String[])new String[]{FLD_DOCBOX_ID, FLD_CONTACT_ID});
        DocboxContact version = DocboxContact.load("VERSION");
        if (!version.exists()) {
            DocboxContact.createOrModifyTable((String)createDB);
        } else {
            VersionInfo vi = new VersionInfo(version.get(FLD_DOCBOX_ID));
            vi.isOlder(VERSION);
        }
    }

    protected DocboxContact() {
    }

    protected DocboxContact(String id) {
        super(id);
    }

    public DocboxContact(String docboxId, Kontakt contact) {
        DocboxContact docboxContact = DocboxContact.loadByDocboxId(docboxId);
        if (docboxContact != null) {
            docboxContact.setContact(contact);
        } else {
            this.create(null);
            String[] fields = new String[]{FLD_DOCBOX_ID, FLD_CONTACT_ID};
            String[] values = new String[]{docboxId, contact.getId()};
            this.set(fields, values);
        }
    }

    public static DocboxContact load(String id) {
        return new DocboxContact(id);
    }

    public static DocboxContact loadByDocboxId(String docboxId) {
        Query qbe = new Query(DocboxContact.class);
        qbe.add(FLD_DOCBOX_ID, "=", docboxId);
        List docboxContact = qbe.execute();
        if (docboxContact == null || docboxContact.isEmpty()) {
            return null;
        }
        return (DocboxContact)((Object)docboxContact.get(0));
    }

    public static String getDocboxIdFor(Kontakt contact) {
        Query qbe = new Query(DocboxContact.class);
        qbe.add(FLD_CONTACT_ID, "=", contact.getId());
        List list = qbe.execute();
        if (list != null && !list.isEmpty()) {
            return ((DocboxContact)((Object)list.get(0))).getDocboxId();
        }
        return "";
    }

    public static Kontakt findContactForDocboxId(String docboxId) {
        DocboxContact docboxContact = DocboxContact.loadByDocboxId(docboxId);
        if (docboxContact == null) {
            return null;
        }
        Kontakt c = docboxContact.getContact();
        if (c.istPerson()) {
            return Person.load((String)c.getId());
        }
        if (c.istOrganisation()) {
            return Organisation.load((String)c.getId());
        }
        return c;
    }

    public static void importDocboxIdsFromKontaktExtinfo(IProgressMonitor monitor) {
        Query qbe = new Query(Kontakt.class);
        List contacts = qbe.execute();
        monitor.beginTask("DocboxIds <-> Kontakt Zuordnung wird in eigene DB-Tabelle \u00fcbertragen", contacts.size());
        for (Kontakt c : contacts) {
            monitor.subTask(c.getLabel());
            String docboxId = c.getInfoString("docboxId");
            if (docboxId != null && !docboxId.isEmpty()) {
                new DocboxContact(docboxId, c);
            }
            monitor.worked(1);
        }
        monitor.done();
    }

    public String getLabel() {
        return "DocboxId: " + this.getDocboxId() + " Kontakt: " + this.getContact().getLabel();
    }

    protected String getTableName() {
        return TABLENAME;
    }

    public String getDocboxId() {
        return this.get(FLD_DOCBOX_ID);
    }

    public void setDocboxId(String docboxId) {
        this.set(FLD_DOCBOX_ID, docboxId);
    }

    public Kontakt getContact() {
        String contactId = this.get(FLD_CONTACT_ID);
        return Kontakt.load((String)contactId);
    }

    public void setContactId(String contactId) {
        this.set(FLD_CONTACT_ID, contactId);
    }

    public void setContact(Kontakt contact) {
        String contactId = null;
        if (contact != null) {
            contactId = contact.getId();
        }
        this.setContactId(contactId);
    }
}

