/*
 * Decompiled with CFR 0.152.
 */
package ch.docbox.elexis;

import ch.docbox.elexis.UserDocboxPreferences;
import ch.docbox.ws.cdachservices.AppointmentType;
import ch.elexis.agenda.data.Termin;
import ch.elexis.agenda.util.Plannables;
import ch.elexis.core.data.util.NoPoUtil;
import ch.elexis.core.model.IAppointment;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.services.holder.CoreModelServiceHolder;
import ch.elexis.core.ui.util.Log;
import ch.elexis.data.PersistentObject;
import ch.elexis.data.Query;
import ch.rgw.tools.TimeTool;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import org.slf4j.LoggerFactory;

public class DocboxTermin {
    private Termin elexisTermin;
    private Termin elexisTerminDayAfter;
    protected static Log log = Log.get((String)"DocboxTermin");

    public boolean equals(Object obj) {
        if (obj != null && obj instanceof DocboxTermin) {
            return this.hashCode() == obj.hashCode();
        }
        return super.equals(obj);
    }

    public int hashCode() {
        int hashCode = super.hashCode();
        if (this.elexisTermin != null) {
            hashCode = this.elexisTermin.hashCode();
        }
        return hashCode;
    }

    private boolean loadTerminByDocboxUniqueId(String id) {
        this.elexisTermin = this.performDocboxIdLoad(id);
        if (this.elexisTermin != null && !this.elexisTermin.exists()) {
            this.elexisTermin = null;
        }
        if (this.elexisTermin != null && this.elexisTermin.isDeleted()) {
            this.elexisTermin.undelete();
        }
        this.elexisTerminDayAfter = this.performDocboxIdLoad(id + "2");
        if (this.elexisTerminDayAfter != null && !this.elexisTerminDayAfter.exists()) {
            this.elexisTerminDayAfter = null;
        }
        if (this.elexisTerminDayAfter != null && this.elexisTerminDayAfter.isDeleted()) {
            this.elexisTerminDayAfter.undelete();
        }
        return this.elexisTermin != null;
    }

    private Termin performDocboxIdLoad(String id) {
        Query terminQuery = new Query(Termin.class);
        terminQuery.add("Extension", "=", id);
        List execute = terminQuery.execute();
        if (!execute.isEmpty()) {
            return (Termin)execute.get(0);
        }
        return null;
    }

    private boolean loadTermin(Termin termin) {
        this.elexisTermin = termin;
        this.elexisTerminDayAfter = this.performDocboxIdLoad(termin.get("Extension") + "2");
        return this.elexisTermin != null;
    }

    static int TimeInMinutes(TimeTool t) {
        return t.get(11) * 60 + t.get(12);
    }

    private String getTerminUniqueId(String appointmentId, String bereich, boolean first) {
        return appointmentId + "[-" + bereich + "-]" + (first ? "" : "2");
    }

    public static String getDocboxTerminId(Termin termin) {
        String id;
        int pos;
        if (termin != null && (pos = (id = termin.get("Extension")).indexOf("[-")) > 0) {
            return id.substring(0, pos);
        }
        return "";
    }

    public boolean create(AppointmentType appointment, String bereich) {
        Object grund;
        String text;
        block20: {
            try {
                boolean twoday;
                this.loadTerminByDocboxUniqueId(this.getTerminUniqueId(appointment.getId(), bereich, true));
                Calendar cal = Calendar.getInstance();
                cal.setTimeInMillis(appointment.getDate().toGregorianCalendar().getTimeInMillis());
                int day = cal.get(7);
                int startMinutes = cal.get(12) + cal.get(11) * 60;
                TimeTool ttFrom = new TimeTool();
                ttFrom.setTimeInMillis(cal.getTimeInMillis());
                cal.add(12, (int)appointment.getDuration());
                TimeTool ttUntil = new TimeTool();
                ttUntil.setTimeInMillis(cal.getTimeInMillis());
                int day2 = cal.get(7);
                boolean bl = twoday = day != day2;
                if (!twoday && this.elexisTerminDayAfter != null && this.elexisTerminDayAfter != null) {
                    if (this.elexisTerminDayAfter.isLocked()) {
                        this.elexisTerminDayAfter.setLocked(false);
                    }
                    this.elexisTerminDayAfter.delete();
                }
                String terminType = Termin.typReserviert();
                String terminStatus = Termin.statusStandard();
                String tag = ttFrom.toString(9);
                Integer von = DocboxTermin.TimeInMinutes(ttFrom);
                Integer bis = DocboxTermin.TimeInMinutes(ttUntil);
                if (this.elexisTermin == null) {
                    this.elexisTermin = new Termin(bereich, tag, von.intValue(), bis.intValue(), terminType, terminStatus);
                    this.elexisTermin.set("Extension", this.getTerminUniqueId(appointment.getId(), bereich, true));
                }
                if (twoday && this.elexisTerminDayAfter == null) {
                    this.elexisTerminDayAfter = new Termin(bereich, tag, von.intValue(), bis.intValue(), terminType, terminStatus);
                    this.elexisTerminDayAfter.set("Extension", this.getTerminUniqueId(appointment.getId(), bereich, false));
                }
                this.setLocked(false);
                Plannables.loadTermine((String)bereich, (TimeTool)ttFrom);
                if (!twoday) {
                    this.elexisTermin.set(new String[]{"BeiWem", "Tag", "Beginn", "Typ", "Status", "ErstelltVon", "Dauer"}, new String[]{bereich, ttFrom.toString(9), Integer.toString(startMinutes), terminType, terminStatus, UserDocboxPreferences.getDocboxLoginID(false), Integer.toString((int)appointment.getDuration())});
                } else {
                    Plannables.loadTermine((String)bereich, (TimeTool)ttUntil);
                    this.elexisTermin.set(new String[]{"BeiWem", "Tag", "Beginn", "Typ", "Status", "ErstelltVon", "Dauer"}, new String[]{bereich, ttFrom.toString(9), Integer.toString(startMinutes), terminType, terminStatus, UserDocboxPreferences.getDocboxLoginID(false), Integer.toString(1440 - startMinutes)});
                    this.elexisTerminDayAfter.set(new String[]{"BeiWem", "Tag", "Beginn", "Typ", "Status", "ErstelltVon", "Dauer"}, new String[]{bereich, ttUntil.toString(9), Integer.toString(0), terminType, terminStatus, UserDocboxPreferences.getDocboxLoginID(false) + "-sys", Integer.toString((int)((long)startMinutes + appointment.getDuration()) % 1440)});
                }
                text = "";
                grund = "";
                if (appointment.getReasonDetails() != null) {
                    grund = appointment.getReasonDetails();
                }
                if ("salesrepresentative-open".equals(appointment.getState())) {
                    text = "offener \u00c4rztebesuchertermin";
                    break block20;
                }
                if ("salesrepresentative-booked".equals(appointment.getState())) {
                    text = String.format("%1$s (\u00c4rztebesuchertermin): %2$s", appointment.getVisitor(), appointment.getReasonTitle());
                    break block20;
                }
                if ("salesrepresentative-openrequest".equals(appointment.getState())) {
                    text = String.format("offene Anfrage von %1$s", appointment.getVisitor());
                    grund = appointment.getReasonTitle();
                    break block20;
                }
                if ("salesrepresentative-openinvitation".equals(appointment.getState())) {
                    text = String.format("offene Einladung an %1$s", appointment.getVisitor());
                    grund = appointment.getReasonTitle();
                    break block20;
                }
                if ("salesrepresentative-phone".equals(appointment.getState())) {
                    text = String.format("%1$s (manuell eingetragen)", appointment.getVisitor());
                    break block20;
                }
                if ("emergencyservice".equals(appointment.getState())) {
                    text = String.format("Notfalldienst  %1$s", appointment.getReasonTitle());
                    break block20;
                }
                if ("terminierung-booked".equals(appointment.getState())) {
                    text = appointment.getVisitor();
                    grund = appointment.getReasonTitle();
                    grund = (String)grund + "\r\n";
                    grund = (String)grund + appointment.getReasonDetails();
                    break block20;
                }
                if ("terminierung-open".equals(appointment.getState())) {
                    text = "offene Terminvereinbarung";
                    break block20;
                }
                if (!"canceled".equals(appointment.getState())) break block20;
                this.elexisTermin.delete();
                return true;
            }
            catch (Exception exception) {
                LoggerFactory.getLogger(this.getClass()).error("Termin konnte nicht gespeichert werden", (Throwable)exception);
                return false;
            }
        }
        if (text != null && text.length() > 80) {
            int seperator = text.indexOf(",", 65);
            if (seperator > 80 || seperator <= 65) {
                seperator = 79;
            }
            text = text.substring(0, seperator);
        }
        this.setText(text);
        this.setGrund((String)grund);
        this.setLocked(true);
        NoPoUtil.loadAsIdentifiable((PersistentObject)this.elexisTermin, IAppointment.class).ifPresent(a -> CoreModelServiceHolder.get().refresh((Identifiable)a, true));
        log.log("Termin " + this.elexisTermin.getId() + " " + this.elexisTermin.getText() + " " + this.elexisTermin.getGrund() + " - " + this.elexisTermin.getDay(), 5);
        return true;
    }

    public void setText(String text) {
        this.elexisTermin.setText(text);
        if (this.elexisTerminDayAfter != null) {
            this.elexisTerminDayAfter.setText(text);
        }
    }

    public void setGrund(String text) {
        this.elexisTermin.setGrund(text);
        if (this.elexisTerminDayAfter != null) {
            this.elexisTerminDayAfter.setGrund(text);
        }
    }

    public void setLocked(boolean locked) {
        this.elexisTermin.setLocked(locked);
        if (this.elexisTerminDayAfter != null) {
            this.elexisTerminDayAfter.setLocked(locked);
        }
    }

    public boolean delete() {
        if (this.elexisTerminDayAfter != null && this.elexisTerminDayAfter.exists()) {
            if (this.elexisTerminDayAfter.isLocked()) {
                this.elexisTerminDayAfter.setLocked(false);
            }
            this.elexisTerminDayAfter.delete();
        }
        if (this.elexisTermin != null && this.elexisTermin.exists()) {
            log.log("Terminid " + this.elexisTermin.getId() + " " + this.elexisTermin.getText() + " " + this.elexisTermin.getGrund() + "- " + this.elexisTermin.getBereich(), 5);
            if (this.elexisTermin.isLocked()) {
                this.elexisTermin.setLocked(false);
            }
            this.elexisTermin.delete();
            return true;
        }
        return false;
    }

    public static List<DocboxTermin> getDocboxTermine() {
        Query terminQuery = new Query(Termin.class);
        terminQuery.add("ErstelltVon", "=", UserDocboxPreferences.getDocboxLoginID(false));
        terminQuery.add("Tag", ">=", new TimeTool().toString(9));
        terminQuery.add("BeiWem", "=", UserDocboxPreferences.getAppointmentsBereich());
        List termine = terminQuery.execute();
        log.log("Termine bestehend " + termine.size(), 5);
        ArrayList<DocboxTermin> docboxTermine = new ArrayList<DocboxTermin>();
        for (Termin termin : termine) {
            DocboxTermin docboxTermin = new DocboxTermin();
            docboxTermin.loadTermin(termin);
            log.log("Terminid " + termin.getId() + " " + termin.getText() + " " + termin.getGrund(), 5);
            docboxTermine.add(docboxTermin);
        }
        return docboxTermine;
    }
}

