/*
 * Decompiled with CFR 0.152.
 */
package ch.docbox.cdach;

import ch.docbox.cdach.CdaNamespaceContext;
import ch.docbox.cdach.DocboxCDA;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class CdaChXPath {
    public static final String oid_loinc = "2.16.840.1.113883.6.1";
    public static final String oid_ean = "1.3.88";
    private static final String oid_docbox_old = "2.25.327919736312109525688528068157180855579";
    private static final String oid_docbox = "2.16.756.5.30.1.105";
    public static final String oid_ahv13 = "2.16.756.5.32";
    private static XPathFactory factory;
    private static XPath xpath;
    private Document doc;
    private String xml;
    private static Map<String, XPathExpression> expressionCache;

    static {
        expressionCache = new HashMap<String, XPathExpression>();
    }

    public static String getOidUserDocboxId() {
        return "2.16.756.5.30.1.105.1.1";
    }

    public static String getOidPraxisSoftwareId() {
        return "2.16.756.5.30.1.105.1.3";
    }

    private String getOidOrganizationId() {
        return "2.16.756.5.30.1.105.1.2";
    }

    private String getOidDepartmentId() {
        return "2.16.756.5.30.1.105.1.2.1";
    }

    private String getOidDocboxLeistungId() {
        return "2.16.756.5.30.1.105.2.1";
    }

    public static String getOidDocboxSectionId() {
        return "2.16.756.5.30.1.105.2.2";
    }

    public static String getOidUserDocboxIdOld() {
        return "2.25.327919736312109525688528068157180855579.1.1";
    }

    private String getOidDepartmentIdOld() {
        return "2.25.327919736312109525688528068157180855579.1.2.1";
    }

    private String getOidOrganizationIdOld() {
        return "2.25.327919736312109525688528068157180855579.1.2";
    }

    private String getOidDocboxLeistungIdOld() {
        return "2.25.327919736312109525688528068157180855579.2.1";
    }

    private String getOidDocboxSectionIdOld() {
        return "2.25.327919736312109525688528068157180855579.2.2";
    }

    public CdaChXPath() {
        if (factory == null) {
            factory = XPathFactory.newInstance();
            xpath = factory.newXPath();
            xpath.setNamespaceContext(new CdaNamespaceContext());
        }
    }

    public Options getOptions(String value) {
        if (value != null) {
            if ("ja".equals(value)) {
                return Options.JA;
            }
            if ("nein".equals(value)) {
                return Options.NEIN;
            }
            if ("unbekannt".equals(value)) {
                return Options.UNBEKANNT;
            }
        }
        return null;
    }

    public Options getFieldValueOptions(String expression) {
        return this.getOptions(this.getFieldValue(expression));
    }

    public String getFieldValue(String expression) {
        return this.getFieldValue(expression, false);
    }

    public String getFieldValue(String expression, boolean convertCdaBrToBr) {
        Object result = null;
        try {
            XPathExpression xpathCheckTypeId = expressionCache.get(expression);
            if (xpathCheckTypeId == null) {
                xpathCheckTypeId = xpath.compile(expression);
                try {
                    expressionCache.put(expression, xpathCheckTypeId);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            result = xpathCheckTypeId.evaluate(this.doc, XPathConstants.NODESET);
        }
        catch (XPathExpressionException e) {
            System.out.println(e.getMessage());
            return null;
        }
        if (result == null) {
            return null;
        }
        NodeList nodes = (NodeList)result;
        if (nodes.getLength() > 0) {
            Object text = "";
            Node node = nodes.item(0).getFirstChild();
            do {
                if (node == null) continue;
                if (node.getNodeType() == 3) {
                    text = (String)text + node.getNodeValue().trim();
                }
                if (node.getNodeType() == 1 && node.getLocalName().equals("br") && convertCdaBrToBr) {
                    text = (String)text + "<br />";
                }
                node = node.getNextSibling();
            } while (node != null);
            return text;
        }
        return null;
    }

    public String[] getFieldValues(String expression) {
        Object result = null;
        try {
            XPathExpression xpathCheckTypeId = expressionCache.get(expression);
            if (xpathCheckTypeId == null) {
                xpathCheckTypeId = xpath.compile(expression);
                expressionCache.put(expression, xpathCheckTypeId);
            }
            result = xpathCheckTypeId.evaluate(this.doc, XPathConstants.NODESET);
        }
        catch (XPathExpressionException e) {
            System.out.println(e.getMessage());
            return null;
        }
        if (result == null) {
            return null;
        }
        NodeList nodes = (NodeList)result;
        if (nodes.getLength() > 0) {
            String[] results = new String[nodes.getLength()];
            int i = 0;
            while (i < nodes.getLength()) {
                Node node = nodes.item(i);
                results[i] = node.getFirstChild().getNodeValue();
                ++i;
            }
            return results;
        }
        return null;
    }

    public String setPatientDocument(String document) {
        DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
        docBuilderFactory.setNamespaceAware(true);
        DocumentBuilder docBuilder = null;
        try {
            docBuilder = docBuilderFactory.newDocumentBuilder();
            this.doc = docBuilder.parse(new ByteArrayInputStream(document.getBytes("UTF-8")));
        }
        catch (SAXException e) {
            System.out.println(e.getMessage());
            return e.toString();
        }
        catch (ParserConfigurationException e) {
            System.out.println(e.getMessage());
            return e.toString();
        }
        catch (IOException e) {
            System.out.println(e.getMessage());
            return e.toString();
        }
        this.xml = document;
        return null;
    }

    public String getTitle() {
        String str = "//cda:ClinicalDocument/cda:title";
        return this.getFieldValue(str);
    }

    public String getPatientHospitalPid() {
        String str = "//cda:ClinicalDocument/cda:recordTarget/cda:patientRole/cda:id[@root = '" + DocboxCDA.getOidPidHospital() + "']/@extension";
        return this.getFieldValue(str);
    }

    public String getPatientHospitalFid() {
        String str = "//cda:ClinicalDocument/cda:recordTarget/cda:patientRole/cda:id[@root = '" + DocboxCDA.getOidFidHospital() + "']/@extension";
        return this.getFieldValue(str);
    }

    public String getCodeCode() {
        String str = "//cda:ClinicalDocument/cda:code/@code";
        if (this.getFieldValue(str) == null) {
            str = "//cda:ClinicalDocument/cda:code/cda:translation/@code";
        }
        return this.getFieldValue(str);
    }

    public String getCodeCodeSystem() {
        String str = "//cda:ClinicalDocument/cda:code/@codeSystem";
        if (this.getFieldValue(str) == null) {
            str = "//cda:ClinicalDocument/cda:code/cda:translation/@codeSystem";
        }
        return this.getFieldValue(str);
    }

    public String getCodeDisplayName() {
        String str = "//cda:ClinicalDocument/cda:code/@displayName";
        return this.getFieldValue(str);
    }

    public String getDossierId() {
        String str = "//cda:ClinicalDocument/cda:component/cda:structuredBody/cda:component/cda:section[cda:code[@nullFlavor=\"NA\"]/cda:translation[@code=\"DOSSIERID\" and (@codeSystem=\"" + this.getOidDocboxSectionIdOld() + "\" or @codeSystem=\"" + CdaChXPath.getOidDocboxSectionId() + "\")]]/cda:text";
        return this.getFieldValue(str);
    }

    public String getDossierUrl() {
        String str = "//cda:ClinicalDocument/cda:component/cda:structuredBody/cda:component/cda:section[cda:code[@nullFlavor=\"NA\"]/cda:translation[@code=\"DOSSIERURL\" and (@codeSystem=\"" + this.getOidDocboxSectionIdOld() + "\" or @codeSystem=\"" + CdaChXPath.getOidDocboxSectionId() + "\")]]/cda:text/cda:linkHtml";
        return this.getFieldValue(str);
    }

    private String getSubStringBefore(String str, String niddle) {
        if (str == null || str.trim().length() == 0) {
            return "";
        }
        if (str.lastIndexOf(niddle) > -1) {
            String result = str.substring(0, str.lastIndexOf(niddle));
            return result;
        }
        if (str.equals("ja") || str.equals("nein") || str.equals("unbekannt")) {
            return str;
        }
        return "";
    }

    private String getSubStringAfter(String str, String niddle) {
        if (str == null || str.trim().length() == 0) {
            return "";
        }
        if (str.lastIndexOf(niddle) > -1) {
            String result = str.substring(str.lastIndexOf(niddle) + 1);
            return result;
        }
        if (str.equals("ja") || str.equals("nein") || str.equals("unbekannt")) {
            return "";
        }
        return str;
    }

    private String formatString(String str) {
        if (str == null || "".equals(str)) {
            return "";
        }
        StringBuffer str1 = new StringBuffer();
        String[] stringArray = this.explodeString(str);
        int len = stringArray.length;
        if (len < 2) {
            return str;
        }
        int i = 0;
        while (i < len) {
            str1.append(stringArray[i]);
            if (i != len - 1) {
                str1.append("\n");
            }
            ++i;
        }
        return str1.toString();
    }

    private String[] explodeString(String str) {
        str = str.replaceAll("\\n|\\r", "");
        String exp1 = "(&lt;|<)(?i)br[\\s]*/?(&gt;|>)";
        String exp2 = "^" + exp1;
        while (str.split(exp1)[0].length() == 0 && !"".equals(str)) {
            str = str.replaceAll(exp2, "");
        }
        return str.split(exp1);
    }

    public String getDocumentIdDocbox() {
        return this.getFieldValue("//cda:ClinicalDocument/cda:id[@root='2.16.756.5.30.1.105'or @root='2.25.327919736312109525688528068157180855579']/@extension");
    }

    public boolean isDocboxReferral() {
        return "28616-1".equals(this.getCodeCode()) && this.getDocumentIdDocbox() != null;
    }

    public String getReferralHospitalName() {
        return this.getFieldValue("//cda:ClinicalDocument/cda:informationRecipient[@typeCode='PRCP' or string-length(normalize-space(@typeCode)) = 0]/cda:intendedRecipient/cda:receivedOrganization/cda:name[1]");
    }

    public String getReferralHospitalId() {
        return this.getFieldValue("//cda:ClinicalDocument/cda:informationRecipient[@typeCode='PRCP' or string-length(normalize-space(@typeCode)) = 0]/cda:intendedRecipient/cda:receivedOrganization/cda:id[@root='" + this.getOidOrganizationId() + "' or @root='" + this.getOidOrganizationIdOld() + "']/@extension");
    }

    public String getReferralDepartmentName() {
        return this.getFieldValue("//cda:ClinicalDocument/cda:informationRecipient[@typeCode='PRCP' or string-length(normalize-space(@typeCode)) = 0]/cda:intendedRecipient/cda:receivedOrganization/cda:name[2]");
    }

    public String getReferralDepartmentId() {
        return this.getFieldValue("//cda:ClinicalDocument/cda:informationRecipient[@typeCode='PRCP' or string-length(normalize-space(@typeCode)) = 0]/cda:intendedRecipient/cda:receivedOrganization/cda:id[@root='" + this.getOidDepartmentId() + "' or @root='" + this.getOidDepartmentIdOld() + "']/@extension");
    }

    public String getAuthorDocboxId() {
        return this.getFieldValue("//cda:ClinicalDocument/cda:author/cda:assignedAuthor/cda:id[@root='" + CdaChXPath.getOidUserDocboxId() + "' or @root='" + CdaChXPath.getOidUserDocboxIdOld() + "']/@extension");
    }

    public String getAuthorEancodeId() {
        return this.getFieldValue("//cda:ClinicalDocument/cda:author/cda:assignedAuthor/cda:id[@root='1.3.88']/@extension");
    }

    public String getAuthorHospitalId() {
        return this.getFieldValue("//cda:ClinicalDocument/cda:author/cda:assignedAuthor/cda:id[@root='" + DocboxCDA.getOidDoctorHospitalId() + "']/@extension");
    }

    public String getAuthorLastName() {
        return this.getFieldValue("//cda:ClinicalDocument/cda:author/cda:assignedAuthor/cda:assignedPerson/cda:name/cda:family");
    }

    public String getAuthorFirstName() {
        return this.getFieldValue("//cda:ClinicalDocument/cda:author/cda:assignedAuthor/cda:assignedPerson/cda:name/cda:given");
    }

    public String getAuthorName() {
        if (this.getAuthorLastName() == null) {
            return this.getFieldValue("//cda:ClinicalDocument/cda:author/cda:assignedAuthor/cda:assignedPerson/cda:name");
        }
        if (this.getAuthorFirstName() == null) {
            return this.getAuthorLastName();
        }
        return this.getAuthorFirstName() + " " + this.getAuthorLastName();
    }

    public int getReceivers() {
        String[] receivers = this.getFieldValues("//cda:ClinicalDocument/cda:informationRecipient");
        return receivers != null ? receivers.length : 0;
    }

    public String getReceiverDocboxId(int i) {
        return this.getFieldValue("//cda:ClinicalDocument/cda:informationRecipient[position() = " + (i + 1) + "]/cda:intendedRecipient/cda:id[@root='" + CdaChXPath.getOidUserDocboxId() + "' or @root='" + CdaChXPath.getOidUserDocboxIdOld() + "']/@extension");
    }

    public String getReceiverEanCodeId(int i) {
        return this.getFieldValue("//cda:ClinicalDocument/cda:informationRecipient[position() = " + (i + 1) + "]/cda:intendedRecipient/cda:id[@root='1.3.88']/@extension");
    }

    public String getReceiverLastName(int i) {
        return this.getFieldValue("//cda:ClinicalDocument/cda:informationRecipient[position() = " + (i + 1) + "]/cda:intendedRecipient/cda:informationRecipient/cda:name/cda:family");
    }

    public String getReceiverFirstName(int i) {
        return this.getFieldValue("//cda:ClinicalDocument/cda:informationRecipient[position() = " + (i + 1) + "]/cda:intendedRecipient/cda:informationRecipient/cda:name/cda:given");
    }

    public String getCustodianHospitalName() {
        return this.getFieldValue("//cda:ClinicalDocument/cda:custodian/cda:assignedCustodian/cda:representedCustodianOrganization/cda:name[1]");
    }

    public String getCustodianHospitalId() {
        return this.getFieldValue("//cda:ClinicalDocument/cda:custodian/cda:assignedCustodian/cda:representedCustodianOrganization/cda:id[@root='" + this.getOidOrganizationId() + "' or @root='" + this.getOidOrganizationIdOld() + "']/@extension");
    }

    public String getCustodianDocboxId() {
        return this.getFieldValue("//cda:ClinicalDocument/cda:custodian/cda:assignedCustodian/cda:representedCustodianOrganization/cda:id[@root='" + CdaChXPath.getOidUserDocboxId() + "' or @root='" + CdaChXPath.getOidUserDocboxIdOld() + "']/@extension");
    }

    public String getCustodianEanCode() {
        return this.getFieldValue("//cda:ClinicalDocument/cda:custodian/cda:assignedCustodian/cda:representedCustodianOrganization/cda:id[@root='1.3.88']/@extension");
    }

    public String getCustodianDepartmentName() {
        return this.getFieldValue("//cda:ClinicalDocument/cda:custodian/cda:assignedCustodian/cda:representedCustodianOrganization/cda:name[2]");
    }

    public String getCustodianDepartmentId() {
        return this.getFieldValue("//cda:ClinicalDocument/cda:custodian/cda:assignedCustodian/cda:representedCustodianOrganization/cda:id[@root='" + this.getOidDepartmentId() + "' or @root='" + this.getOidDepartmentIdOld() + "']/@extension");
    }

    public String getDocboxReferralInfo() {
        StringBuffer strBuf = new StringBuffer();
        strBuf.append("Docbox Dokument ID:\t" + this.getDocumentIdDocbox() + "\n");
        strBuf.append("Auftrags ID docbox:\t" + this.getAuftragsnummmer() + "\n");
        strBuf.append("Spital:\t" + this.getReferralHospitalName() + "\n");
        strBuf.append("SpitalId:\t" + this.getReferralHospitalId() + "\n");
        strBuf.append("Fachbereich:\t" + this.getReferralDepartmentName() + "\n");
        strBuf.append("FachbereichId:\t" + this.getReferralDepartmentId() + "\n");
        strBuf.append("Sender Arzt ID docbox:\t" + this.getAuthorDocboxId() + "\n");
        strBuf.append("Sender Arzt Nachname:\t" + this.getAuthorLastName() + "\n");
        strBuf.append("Sender Arzt Vorname:\t" + this.getAuthorFirstName() + "\n");
        strBuf.append("Empf\u00e4nger ID docbox:\t" + this.getReceiverDocboxId(0) + "\n");
        strBuf.append("Empf\u00e4nger Nachname:\t" + this.getReceiverLastName(0) + "\n");
        strBuf.append("Empf\u00e4nger Vorname:\t" + this.getReceiverFirstName(0) + "\n");
        strBuf.append("PID-Hausarzt docbox:\t" + this.getPatientNumber() + "\n");
        strBuf.append("Patient Nachname:\t" + this.getPatientLastName() + "\n");
        strBuf.append("Patient Vorname:\t" + this.getPatientFirstName() + "\n");
        strBuf.append("Patient Geburtstag:\t" + this.getPatientDateOfBirth() + "\n");
        return strBuf.toString();
    }

    public String toString() {
        if (this.doc == null) {
            return "no document set";
        }
        StringBuffer strBuf = new StringBuffer();
        if (oid_loinc.equals(this.getCodeCodeSystem())) {
            if (this.isDocboxReferral()) {
                strBuf.append("Docbox Spital\u00fcberweisung\n");
                strBuf.append(this.getDocboxReferralInfo());
                return strBuf.toString();
            }
        } else if ("NA".equals(this.getCodeCode())) {
            strBuf.append("TOBEDONE");
        } else {
            strBuf.append("WARNING: code not identified for document");
        }
        strBuf.append(this.xml);
        return strBuf.toString();
    }

    public String getPatientLastName() {
        String str = "//cda:ClinicalDocument/cda:recordTarget/cda:patientRole/cda:patient/cda:name/cda:family";
        return this.getFieldValue(str);
    }

    public String getPatientFirstName() {
        String str = "//cda:ClinicalDocument/cda:recordTarget/cda:patientRole/cda:patient/cda:name/cda:given";
        return this.getFieldValue(str);
    }

    public String getPatientStreet() {
        String str = "//cda:ClinicalDocument/cda:recordTarget/cda:patientRole/cda:addr/cda:streetAddressLine";
        return this.getFieldValue(str);
    }

    public String getPatientPlz() {
        String str = "//cda:ClinicalDocument/cda:recordTarget/cda:patientRole/cda:addr/cda:postalCode";
        return this.getFieldValue(str);
    }

    public String getPatientCity() {
        String str = "//cda:ClinicalDocument/cda:recordTarget/cda:patientRole/cda:addr/cda:city";
        return this.getFieldValue(str);
    }

    public String getPatientAhv13() {
        String str = "//cda:ClinicalDocument/cda:recordTarget/cda:patientRole/cda:id[@root = '2.16.756.5.32']/@extension";
        return this.getFieldValue(str);
    }

    public String getPatientDateOfBirth() {
        String str = "//cda:ClinicalDocument/cda:recordTarget/cda:patientRole/cda:patient/cda:birthTime/@value";
        return this.getFieldValue(str);
    }

    public String getPatientGender() {
        String str = "//cda:ClinicalDocument/cda:recordTarget/cda:patientRole/cda:patient/cda:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1']/@code";
        return this.getFieldValue(str);
    }

    public String getPatientNumber() {
        String str = "//cda:ClinicalDocument/cda:recordTarget/cda:patientRole/cda:id[@root = '" + DocboxCDA.getOidPraxisSoftwareId() + "' or @root = '" + DocboxCDA.getOidPraxisSoftwareIdOld() + "' or string-length(normalize-space(@root)) = 0]/@extension";
        return this.getFieldValue(str);
    }

    public String getPatientHomePhone() {
        String str = "//cda:ClinicalDocument/cda:recordTarget/cda:patientRole/cda:telecom[substring(@value, 1, 3) = 'tel' and @use='HP']/@value";
        return this.getSubStringAfter(this.getFieldValue(str), ":");
    }

    public String getPatientOfficePhone() {
        String str = "//cda:ClinicalDocument/cda:recordTarget/cda:patientRole/cda:telecom[substring(@value, 1, 3) = 'tel' and @use='WP']/@value";
        return this.getSubStringAfter(this.getFieldValue(str), ":");
    }

    public String getPatientMobile() {
        String str = "//cda:ClinicalDocument/cda:recordTarget/cda:patientRole/cda:telecom[substring(@value, 1, 3) = 'tel' and string-length(normalize-space(@use)) = 0]/@value";
        return this.getSubStringAfter(this.getFieldValue(str), ":");
    }

    public String getPatientEmail() {
        String str = "//cda:ClinicalDocument/cda:recordTarget/cda:patientRole/cda:telecom[substring(@value, 1, 4) = 'mail']/@value";
        return this.getSubStringAfter(this.getFieldValue(str), ":");
    }

    private String getSectionTextPath(String code, String title, String codeSystem, String oldCodeSystem) {
        if (title == null && code == null && codeSystem != null) {
            return "//cda:ClinicalDocument/cda:component/cda:structuredBody/cda:component/cda:section[cda:code[@nullFlavor='NA']/cda:translation[@codeSystem='" + codeSystem + "' or @codeSystem='" + oldCodeSystem + "']]/cda:text";
        }
        if (title == null) {
            return "//cda:ClinicalDocument/cda:component/cda:structuredBody/cda:component/cda:section[cda:code[@nullFlavor='NA']/cda:translation[@code='" + code + "' and (@codeSystem='" + codeSystem + "' or @codeSystem='" + oldCodeSystem + "')]]/cda:text";
        }
        return "//cda:ClinicalDocument/cda:component/cda:structuredBody/cda:component/cda:section[cda:title='" + title + "' or cda:code[@nullFlavor='NA']/cda:translation[@code='" + code + "' and (@codeSystem='" + codeSystem + "' or @codeSystem='" + oldCodeSystem + "')]]/cda:text";
    }

    private String getSectionTextPath(String code) {
        return this.getSectionTextPath(code, null, CdaChXPath.getOidDocboxSectionId(), this.getOidDocboxSectionIdOld());
    }

    public String getAuftragsnummmer() {
        return this.getFieldValue(this.getSectionTextPath("AOK"));
    }

    public String getVersicherungsklasse() {
        return this.getFieldValue(this.getSectionTextPath("AVK"));
    }

    public String getKrankenkasse() {
        return this.getFieldValue(this.getSectionTextPath("AKK"));
    }

    public String getKrankenkassePolicenummer() {
        return this.getFieldValue(this.getSectionTextPath("AKP"));
    }

    public String getKrankenkasseZusatzversicherung() {
        return this.getFieldValue(this.getSectionTextPath("AZK"));
    }

    public String getKrankenkasseZusatzversicherungPolicenummer() {
        return this.getFieldValue(this.getSectionTextPath("AZP"));
    }

    public String getUnfallversicherung() {
        return this.getFieldValue(this.getSectionTextPath("AUV"));
    }

    public String getUnfallversicherungPolicenummer() {
        return this.getFieldValue(this.getSectionTextPath("AUP"));
    }

    public String getUnfallZusatzversicherung() {
        return this.getFieldValue(this.getSectionTextPath("AZU"));
    }

    public String getUnfallZusatzversicherungPolicenummer() {
        return this.getFieldValue(this.getSectionTextPath("AZPU"));
    }

    public String getArbeitgeber() {
        return this.getFieldValue(this.getSectionTextPath("AAG"));
    }

    public String getEinweisungsgrund() {
        return this.getFieldValue(this.getSectionTextPath("AEG"));
    }

    public String getAufenthaltsart() {
        return this.getFieldValue(this.getSectionTextPath("AAA"));
    }

    public String getEintrittDatum() {
        return this.getFieldValue(this.getSectionTextPath("AED"));
    }

    public String getEintrittZeit() {
        return this.getFieldValue(this.getSectionTextPath("AEZ"));
    }

    public Options getEintrittVortag() {
        return this.getFieldValueOptions(this.getSectionTextPath("AEV"));
    }

    public Options getEintrittNuechtern() {
        return this.getFieldValueOptions(this.getSectionTextPath("AEN"));
    }

    public String getOperationDatum() {
        return this.getFieldValue(this.getSectionTextPath("AOPD"));
    }

    public String getOperationZeit() {
        return this.getFieldValue(this.getSectionTextPath("AOPZ"));
    }

    public String getOperationFixZeit() {
        return this.getFieldValue(this.getSectionTextPath("AOPFZ"));
    }

    public String getDringlichkeit() {
        return this.getFieldValue(this.getSectionTextPath("ADRINDGLICHKEIT"));
    }

    public String getFruehereAufenthalte() {
        return this.getFieldValue(this.getSectionTextPath("AFAS"));
    }

    public String getHauszart() {
        return this.getFieldValue(this.getSectionTextPath("ANH"));
    }

    public Options getPraeoperativHausarzt() {
        return this.getFieldValueOptions(this.getSectionTextPath("APH"));
    }

    public String getBemerkungenBeilagen() {
        return this.getFieldValue(this.getSectionTextPath("ABB"));
    }

    public String[] getGewuenschteLeistungen() {
        return this.getFieldValues(this.getSectionTextPath(null, null, this.getOidDocboxLeistungId(), this.getOidDocboxLeistungIdOld()));
    }

    public String getErgaenzungenLeistung() {
        return this.getFieldValue(this.getSectionTextPath("LE"));
    }

    public String getKlinischeAngabeFragestellung() {
        return this.getFieldValue(this.getSectionTextPath("LKA"));
    }

    public String getDiagnose() {
        return this.getFieldValue(this.getSectionTextPath("LD"));
    }

    public String getDiagnoseVerlauf() {
        return this.getFieldValue(this.getSectionTextPath("LDV"));
    }

    public String getNotiz() {
        return this.getFieldValue(this.getSectionTextPath("NOTIZ"));
    }

    public String getAnamnese() {
        return this.getFieldValue(this.getSectionTextPath("LA"));
    }

    public String getGewuenschteKoerperregion() {
        return this.getFieldValue(this.getSectionTextPath("LK"));
    }

    public String getMedikamente() {
        return this.formatString(this.getFieldValue(this.getSectionTextPath("KMED", "Medikamente", CdaChXPath.getOidDocboxSectionId(), this.getOidDocboxSectionIdOld()), true));
    }

    public String getSchwangerschaft() {
        return this.getFieldValue(this.getSectionTextPath("KSCH", "Schwangerschaft/Stillzeit", CdaChXPath.getOidDocboxSectionId(), this.getOidDocboxSectionIdOld()));
    }

    public Options getHasSchwangerschaft() {
        return this.getOptions(this.getSubStringBefore(this.getSchwangerschaft(), ":"));
    }

    public String getSchwangerschaftBemerkung() {
        return this.getSubStringAfter(this.getSchwangerschaft(), ":");
    }

    public String getAllergie() {
        return this.formatString(this.getFieldValue(this.getSectionTextPath("KALL", "Allergien", CdaChXPath.getOidDocboxSectionId(), this.getOidDocboxSectionIdOld()), true));
    }

    public Options getHasAllergie() {
        return this.getOptions(this.getSubStringBefore(this.getAllergie(), ":"));
    }

    public String getAllergieBemerkung() {
        return this.getSubStringAfter(this.getAllergie(), ":");
    }

    public String getKreatininwert() {
        return this.getFieldValue(this.getSectionTextPath("KKRET", "Kreatininwert", CdaChXPath.getOidDocboxSectionId(), this.getOidDocboxSectionIdOld()));
    }

    public String getInr() {
        return this.getFieldValue(this.getSectionTextPath("KINR", "INR", CdaChXPath.getOidDocboxSectionId(), this.getOidDocboxSectionIdOld()));
    }

    public String getThrombozyten() {
        return this.getFieldValue(this.getSectionTextPath("KTHROMBO", "Thrombozyten", CdaChXPath.getOidDocboxSectionId(), this.getOidDocboxSectionIdOld()));
    }

    public Options getSchilddruesenUeberfunktion() {
        return this.getFieldValueOptions(this.getSectionTextPath("KSCHILD", "Schilddr\u00fcsen-\u00dcberfunktion", CdaChXPath.getOidDocboxSectionId(), this.getOidDocboxSectionIdOld()));
    }

    public Options getBiguanidMedication() {
        return this.getFieldValueOptions(this.getSectionTextPath("KBIUGANID", "Biguanid Medikation", CdaChXPath.getOidDocboxSectionId(), this.getOidDocboxSectionIdOld()));
    }

    public Options getHerzschrittmacher() {
        return this.getFieldValueOptions(this.getSectionTextPath("KHERZSCHRITT", "Herzschrittmacher", CdaChXPath.getOidDocboxSectionId(), this.getOidDocboxSectionIdOld()));
    }

    public Options getMetallImplantate() {
        return this.getFieldValueOptions(this.getSectionTextPath("KMETALL", "Metallimplantate", CdaChXPath.getOidDocboxSectionId(), this.getOidDocboxSectionIdOld()));
    }

    public Options getClipsMetallSplitter() {
        return this.getFieldValueOptions(this.getSectionTextPath("KCLIPS", "Clips/Metallsplitter", CdaChXPath.getOidDocboxSectionId(), this.getOidDocboxSectionIdOld()));
    }

    public Options getGehoerImplantat() {
        return this.getFieldValueOptions(this.getSectionTextPath("KGEH\u00d6RIMPL", "Geh\u00f6rimplantat", CdaChXPath.getOidDocboxSectionId(), this.getOidDocboxSectionIdOld()));
    }

    public Options getPlatzangst() {
        return this.getFieldValueOptions(this.getSectionTextPath("KPLATZANGST", "Platzangst", CdaChXPath.getOidDocboxSectionId(), this.getOidDocboxSectionIdOld()));
    }

    public Options getKindZurSedation() {
        return this.getFieldValueOptions(this.getSectionTextPath("KKINDSEDATION"));
    }

    public String getOpDauer() {
        return this.getFieldValue(this.getSectionTextPath("KOPD"));
    }

    public String getAufenthaltsdauer() {
        return this.getFieldValue(this.getSectionTextPath("KOPAUF"));
    }

    public String getOperateur() {
        return this.getFieldValue(this.getSectionTextPath("KOPERATEUR"));
    }

    public String getOpAssitent() {
        return this.getFieldValue(this.getSectionTextPath("KOPASSISTANT"));
    }

    public String getInstrumente() {
        return this.formatString(this.getFieldValue(this.getSectionTextPath("KINSTRUMENT"), true));
    }

    public String getLagerung() {
        return this.formatString(this.getFieldValue(this.getSectionTextPath("KLAGERUNG"), true));
    }

    public String getAnaesthesie() {
        return this.formatString(this.getFieldValue(this.getSectionTextPath("KAN\u00c4STHESIE"), true));
    }

    public Options getAnaesthesieSprechstunde() {
        return this.getFieldValueOptions(this.getSectionTextPath("KAN\u00c4STHESIEAUFBIETEN"));
    }

    public String[] getAttachments() {
        return this.getFieldValues("//cda:ClinicalDocument/cda:component/cda:structuredBody/cda:component/cda:section[cda:code[@nullFlavor='NA']/cda:translation[@code='ATT' and (@codeSystem='" + CdaChXPath.getOidDocboxSectionId() + "' or @codeSystem='" + this.getOidDocboxSectionIdOld() + "')]]/cda:text/cda:linkHtml");
    }

    public String getDocumentIdInSection() {
        return this.getFieldValue(this.getSectionTextPath("DOCID"));
    }

    public String getDatumAufgebot() {
        return this.getFieldValue(this.getSectionTextPath("MDATUMAUFGEBOT"));
    }

    public String getDatumAufgebotAenderung() {
        return this.getFieldValue(this.getSectionTextPath("MDATUMAUFGEBOT\u00c4NDERUNG"));
    }

    public String getDatumEintritt() {
        return this.getFieldValue(this.getSectionTextPath("MDATUMEINTRITT"));
    }

    public String getDatumStornoEintritt() {
        return this.getFieldValue(this.getSectionTextPath("MDATUMSTORNOEINTRITT"));
    }

    public String getDatumAustritt() {
        return this.getFieldValue(this.getSectionTextPath("MDATUMAUSRITT"));
    }

    public String getDatumStornoAustritt() {
        return this.getFieldValue(this.getSectionTextPath("MDATUMSTORNOAUSTRITT"));
    }

    private Element getId(String root, String extension, String prefix) {
        Element id = this.getElement("id", prefix);
        id.setAttribute("root", root);
        id.setAttribute("extension", extension);
        return id;
    }

    private Element getElement(String name, String prefix) {
        Element element = this.doc.createElementNS("urn:hl7-org:v3", name);
        element.setPrefix(prefix);
        return element;
    }

    private Node getId(NodeList nodeList, String root) {
        int i = 0;
        while (i < nodeList.getLength()) {
            Node node = nodeList.item(i);
            Node attribute = node.getAttributes().getNamedItem("root");
            if (attribute == null) {
                return null;
            }
            String value = attribute.getNodeValue();
            if (root.equals(value)) {
                return node;
            }
            ++i;
        }
        return null;
    }

    public boolean addAuthorToDocument(String docboxId, String eanCode, String firstName, String lastName) {
        Element assignedPerson;
        Element name;
        Element given;
        Node node;
        NodeList nodeList = this.doc.getElementsByTagNameNS("urn:hl7-org:v3", "author");
        String prefix = "";
        Element author = null;
        if (nodeList.getLength() == 0) {
            NodeList listRecordTargets = this.doc.getElementsByTagNameNS("urn:hl7-org:v3", "recordTarget");
            if (listRecordTargets.getLength() == 0) {
                return false;
            }
            Node recordTarget = listRecordTargets.item(listRecordTargets.getLength() - 1);
            prefix = recordTarget.getPrefix();
            author = this.getElement("author", prefix);
            if (recordTarget.getNextSibling() == null) {
                recordTarget.getParentNode().appendChild(author);
            } else {
                recordTarget.getParentNode().insertBefore(author, recordTarget.getNextSibling());
            }
        } else {
            author = (Element)nodeList.item(0);
            prefix = author.getPrefix();
        }
        this.getOrCreateChild(author, "time", prefix, true);
        Element assignedAuthor = this.getOrCreateChild(author, "assignedAuthor", prefix, false);
        nodeList = assignedAuthor.getElementsByTagNameNS("urn:hl7-org:v3", "id");
        if (docboxId != null) {
            node = this.getId(nodeList, CdaChXPath.getOidUserDocboxId());
            if (node == null) {
                Element idDocbox = this.getId(CdaChXPath.getOidUserDocboxId(), docboxId, prefix);
                if (assignedAuthor.getFirstChild() == null) {
                    assignedAuthor.appendChild(idDocbox);
                } else {
                    assignedAuthor.insertBefore(idDocbox, assignedAuthor.getFirstChild());
                }
            } else if (!docboxId.equals(node.getAttributes().getNamedItem("extension").getNodeValue())) {
                return false;
            }
        }
        if (eanCode != null) {
            node = this.getId(nodeList, oid_ean);
            if (node == null) {
                Element idEanCode = this.getId(oid_ean, eanCode, prefix);
                if (assignedAuthor.getFirstChild() == null) {
                    assignedAuthor.appendChild(idEanCode);
                } else {
                    assignedAuthor.insertBefore(idEanCode, assignedAuthor.getFirstChild());
                }
            } else if (!eanCode.equals(node.getAttributes().getNamedItem("extension").getNodeValue())) {
                return false;
            }
        }
        if ((given = this.getOrCreateChild(name = this.getOrCreateChild(assignedPerson = this.getOrCreateChild(assignedAuthor, "assignedPerson", prefix, false), "name", prefix, false), "given", prefix, false)).getLastChild() != null && firstName != null) {
            firstName.equals(given.getLastChild().getNodeValue());
        } else if (firstName != null) {
            given.appendChild(this.doc.createTextNode(firstName));
        }
        Element family = this.getOrCreateChild(name, "family", prefix, false);
        if (family.getLastChild() != null && lastName != null) {
            lastName.equals(family.getLastChild().getNodeValue());
        } else if (lastName != null) {
            family.appendChild(this.doc.createTextNode(lastName));
        }
        return true;
    }

    public boolean addCustodianToDocument(String docboxId, String organizationId, String name) {
        NodeList listNames;
        Node node;
        NodeList nodeList = this.doc.getElementsByTagNameNS("urn:hl7-org:v3", "custodian");
        String prefix = "";
        Element custodian = null;
        if (nodeList.getLength() == 0) {
            NodeList listAuthors = this.doc.getElementsByTagNameNS("urn:hl7-org:v3", "author");
            if (listAuthors.getLength() == 0) {
                return false;
            }
            Node author = listAuthors.item(listAuthors.getLength() - 1);
            prefix = author.getPrefix();
            custodian = this.getElement("custodian", prefix);
            if (author.getNextSibling() == null) {
                author.getParentNode().appendChild(custodian);
            } else {
                author.getParentNode().insertBefore(custodian, author.getNextSibling());
            }
        } else {
            custodian = (Element)nodeList.item(0);
            prefix = custodian.getPrefix();
        }
        Element assignedCustodian = this.getOrCreateChild(custodian, "assignedCustodian", prefix, false);
        Element representedCustodian = this.getOrCreateChild(assignedCustodian, "representedCustodianOrganization", prefix, false);
        nodeList = representedCustodian.getElementsByTagNameNS("urn:hl7-org:v3", "id");
        if (docboxId != null) {
            node = this.getId(nodeList, CdaChXPath.getOidUserDocboxId());
            if (node == null) {
                Element idDocbox = this.getId(CdaChXPath.getOidUserDocboxId(), docboxId, prefix);
                if (representedCustodian.getFirstChild() == null) {
                    representedCustodian.appendChild(idDocbox);
                } else {
                    representedCustodian.insertBefore(idDocbox, representedCustodian.getFirstChild());
                }
            } else if (!docboxId.equals(node.getAttributes().getNamedItem("extension").getNodeValue())) {
                return false;
            }
        }
        if (organizationId != null) {
            node = this.getId(nodeList, this.getOidOrganizationId());
            if (node == null) {
                Element idEanCode = this.getId(this.getOidOrganizationId(), organizationId, prefix);
                if (representedCustodian.getFirstChild() == null) {
                    representedCustodian.appendChild(idEanCode);
                } else {
                    representedCustodian.insertBefore(idEanCode, representedCustodian.getFirstChild());
                }
            } else if (!organizationId.equals(node.getAttributes().getNamedItem("extension").getNodeValue())) {
                return false;
            }
        }
        if ((listNames = representedCustodian.getElementsByTagNameNS("urn:hl7-org:v3", "name")).getLength() == 0) {
            Element nameElement = this.getOrCreateChild(representedCustodian, "name", prefix, false);
            if (name != null) {
                nameElement.appendChild(this.doc.createTextNode(name));
            }
        }
        return true;
    }

    private Element getOrCreateChild(Element parent, String childName, String prefix, boolean first) {
        NodeList nodeList = parent.getElementsByTagNameNS("urn:hl7-org:v3", childName);
        Element child = null;
        if (nodeList.getLength() > 0) {
            child = (Element)nodeList.item(0);
        } else {
            child = this.getElement(childName, prefix);
            if (!first || parent.getFirstChild() == null) {
                parent.appendChild(child);
            } else {
                parent.insertBefore(child, parent.getFirstChild());
            }
        }
        return child;
    }

    public String getDocumentSerialized() {
        Transformer serializer;
        StringWriter stringWriter = new StringWriter();
        DOMSource domSource = new DOMSource(this.doc);
        StreamResult streamResult = new StreamResult(stringWriter);
        TransformerFactory tf = TransformerFactory.newInstance();
        try {
            serializer = tf.newTransformer();
        }
        catch (TransformerConfigurationException e) {
            e.printStackTrace();
            return null;
        }
        serializer.setOutputProperty("encoding", "UTF8");
        try {
            serializer.transform(domSource, streamResult);
        }
        catch (TransformerException e) {
            e.printStackTrace();
            return null;
        }
        return stringWriter.toString();
    }

    public boolean isCdaDocboxType(DOCBOXCDATYPE docboxCdaType) {
        return docboxCdaType.name().equals(this.getFieldValue("//cda:ClinicalDocument/cda:templateId[@root='2.16.756.5.30.1.105' or @root='2.25.327919736312109525688528068157180855579']/@extension"));
    }

    public boolean isCdaDocboxSpitalArzt() {
        return this.isCdaDocboxType(DOCBOXCDATYPE.Docbox_Spital_Arzt);
    }

    public boolean isCdaDocboxSpitalAnmeldung() {
        return this.isCdaDocboxType(DOCBOXCDATYPE.Docbox_Spital_Anmeldung);
    }

    public boolean isCdaDocboxTeminvereinbarung() {
        return this.isCdaDocboxType(DOCBOXCDATYPE.Docbox_Terminvereinbarung);
    }

    public boolean isCdaDocboxArztArzt() {
        return this.isCdaDocboxType(DOCBOXCDATYPE.Docbox_Arzt_Arzt);
    }

    public static enum DOCBOXCDATYPE {
        Eingang_Anmeldung,
        Datum_Aufgebot,
        Eintritt,
        Austritt,
        Dossier_Freigabe,
        Dossier_Freigabe_Beendet,
        Docbox_Spital_Anmeldung,
        Docbox_Spital_Arzt,
        Docbox_Arzt_Arzt,
        Docbox_Nachricht,
        Docbox_Terminvereinbarung;

    }

    public static enum Options {
        JA,
        NEIN,
        UNBEKANNT;

    }
}

