/*
 * Decompiled with CFR 0.152.
 */
package at.medevit.elexis.outbox.model.impl;

import at.medevit.elexis.outbox.model.IOutboxElement;
import at.medevit.elexis.outbox.model.IOutboxElementService;
import at.medevit.elexis.outbox.model.IOutboxUpdateListener;
import at.medevit.elexis.outbox.model.impl.DocumentStoreServiceHolder;
import at.medevit.elexis.outbox.model.impl.ElementsProviderExtension;
import ch.elexis.core.model.Deleteable;
import ch.elexis.core.model.IDocument;
import ch.elexis.core.model.IMandator;
import ch.elexis.core.model.IPatient;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.services.IModelService;
import ch.elexis.core.services.IQuery;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import org.apache.commons.io.IOUtils;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@Component
public class OutboxElementService
implements IOutboxElementService {
    @Reference(target="(service.model.name=at.medevit.elexis.outbox.model)")
    private IModelService modelService;
    HashSet<IOutboxUpdateListener> listeners = new HashSet();

    @Override
    public IOutboxElement createOutboxElement(IPatient patient, IMandator mandator, String uri) {
        IOutboxElement element = (IOutboxElement)this.modelService.create(IOutboxElement.class);
        element.setPatient(patient);
        element.setMandator(mandator);
        element.setUri(uri);
        element.setState(IOutboxElementService.State.NEW);
        this.modelService.save((Identifiable)element);
        this.fireUpdate(element);
        return element;
    }

    @Override
    public void changeOutboxElementState(IOutboxElement element, IOutboxElementService.State state) {
        element.setState(state);
        this.modelService.save((Identifiable)element);
        this.fireUpdate(element);
    }

    @Override
    public List<IOutboxElement> getOutboxElements(String uri, IOutboxElementService.State state) {
        IQuery query = this.modelService.getQuery(IOutboxElement.class);
        if (uri != null) {
            query.and("uri", IQuery.COMPARATOR.EQUALS, (Object)uri);
        }
        if (state != null) {
            query.and("state", IQuery.COMPARATOR.EQUALS, (Object)Integer.toString(state.ordinal()));
        }
        return query.execute();
    }

    @Override
    public List<IOutboxElement> getOutboxElements(IMandator mandator, IPatient patient, IOutboxElementService.State state) {
        IQuery query = this.modelService.getQuery(IOutboxElement.class);
        if (mandator != null) {
            query.and("mandant", IQuery.COMPARATOR.EQUALS, (Object)mandator);
        }
        if (patient != null) {
            query.and("patient", IQuery.COMPARATOR.EQUALS, (Object)patient);
        }
        if (state != null) {
            query.and("state", IQuery.COMPARATOR.EQUALS, (Object)Integer.toString(state.ordinal()));
        }
        return query.execute();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addUpdateListener(IOutboxUpdateListener listener) {
        HashSet<IOutboxUpdateListener> hashSet = this.listeners;
        synchronized (hashSet) {
            this.listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeUpdateListener(IOutboxUpdateListener listener) {
        HashSet<IOutboxUpdateListener> hashSet = this.listeners;
        synchronized (hashSet) {
            this.listeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireUpdate(IOutboxElement element) {
        HashSet<IOutboxUpdateListener> hashSet = this.listeners;
        synchronized (hashSet) {
            for (IOutboxUpdateListener listener : this.listeners) {
                listener.update(element);
            }
        }
    }

    @Activate
    public void activate() {
        System.out.println("active providers");
        ElementsProviderExtension.activateAll();
    }

    @Deactivate
    public void deactivate() {
        System.out.println("deactive providers");
    }

    @Override
    public InputStream getContentsAsStream(IOutboxElement outboxElement) throws IOException {
        Object object = outboxElement.getObject();
        if (object instanceof Path) {
            Path path = (Path)object;
            return Files.newInputStream(path, new OpenOption[0]);
        }
        if (object instanceof IDocument) {
            Optional in = DocumentStoreServiceHolder.getService().loadContent((IDocument)object);
            if (in.isPresent()) {
                return (InputStream)in.get();
            }
        } else if (object instanceof Identifiable) {
            throw new UnsupportedOperationException("Identifiable to InputStream");
        }
        return null;
    }

    /*
     * Loose catch block
     */
    @Override
    public Optional<File> createTempFileWithContents(File folder, IOutboxElement outboxElement) throws IOException {
        block19: {
            Throwable throwable = null;
            Object var4_5 = null;
            try (InputStream in = this.getContentsAsStream(outboxElement);){
                Optional<File> optional;
                FileOutputStream fout;
                Throwable throwable2;
                block20: {
                    if (in == null || folder == null || !folder.exists()) break block19;
                    File tmpFile = new File(folder, outboxElement.getLabel());
                    throwable2 = null;
                    Object var8_11 = null;
                    fout = new FileOutputStream(tmpFile);
                    IOUtils.copy((InputStream)in, (OutputStream)fout);
                    tmpFile.deleteOnExit();
                    optional = Optional.of(tmpFile);
                    if (fout == null) break block20;
                    fout.close();
                }
                return optional;
                {
                    catch (Throwable throwable3) {
                        try {
                            if (fout != null) {
                                fout.close();
                            }
                            throw throwable3;
                        }
                        catch (Throwable throwable4) {
                            if (throwable2 == null) {
                                throwable2 = throwable4;
                            } else if (throwable2 != throwable4) {
                                throwable2.addSuppressed(throwable4);
                            }
                            throw throwable2;
                        }
                    }
                }
            }
            catch (Throwable throwable5) {
                if (throwable == null) {
                    throwable = throwable5;
                } else if (throwable != throwable5) {
                    throwable.addSuppressed(throwable5);
                }
                throw throwable;
            }
        }
        return Optional.empty();
    }

    @Override
    public void deleteOutboxElement(IOutboxElement outboxElement) {
        if (outboxElement != null) {
            this.modelService.delete((Deleteable)outboxElement);
            this.fireUpdate(outboxElement);
        }
    }
}

