/*
 * Decompiled with CFR 0.152.
 */
package at.medevit.elexis.outbox.model.impl;

import at.medevit.elexis.outbox.model.IOutboxElementsProvider;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ElementsProviderExtension {
    private static Logger logger = LoggerFactory.getLogger(ElementsProviderExtension.class);

    public static void activateAll() {
        List<IOutboxElementsProvider> providers = ElementsProviderExtension.getAllProviders();
        for (IOutboxElementsProvider iOutboxElementsProvider : providers) {
            iOutboxElementsProvider.activate();
        }
    }

    public static void deactivateAll() {
        List<IOutboxElementsProvider> providers = ElementsProviderExtension.getAllProviders();
        for (IOutboxElementsProvider iOutboxElementsProvider : providers) {
            iOutboxElementsProvider.deactivate();
        }
    }

    private static List<IOutboxElementsProvider> getAllProviders() {
        ArrayList<IOutboxElementsProvider> ret = new ArrayList<IOutboxElementsProvider>();
        IExtensionRegistry exr = Platform.getExtensionRegistry();
        IExtensionPoint exp = exr.getExtensionPoint("at.medevit.elexis.outbox.elementsprovider");
        if (exp != null) {
            IExtension[] extensions;
            IExtension[] iExtensionArray = extensions = exp.getExtensions();
            int n = extensions.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement[] elems;
                IExtension ex = iExtensionArray[n2];
                IConfigurationElement[] iConfigurationElementArray = elems = ex.getConfigurationElements();
                int n3 = elems.length;
                int n4 = 0;
                while (n4 < n3) {
                    IConfigurationElement el = iConfigurationElementArray[n4];
                    if (el.getName().equals("provider")) {
                        try {
                            ret.add((IOutboxElementsProvider)el.createExecutableExtension("class"));
                        }
                        catch (CoreException e) {
                            logger.error("Error creating IOutboxElementsProvider {}", (Throwable)e);
                        }
                    }
                    ++n4;
                }
                ++n2;
            }
        }
        return ret;
    }
}

