/*
 * Decompiled with CFR 0.152.
 */
package at.medevit.elexis.outbox.ui.part.provider;

import at.medevit.elexis.outbox.model.IOutboxElement;
import at.medevit.elexis.outbox.ui.part.provider.IOutboxElementUiProvider;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OutboxElementUiExtension {
    private static Logger logger = LoggerFactory.getLogger(OutboxElementUiExtension.class);
    private List<IOutboxElementUiProvider> providers = this.getExtensions();

    public List<IOutboxElementUiProvider> getProviders() {
        return this.providers;
    }

    private IOutboxElementUiProvider getProvider(IOutboxElement element) {
        for (IOutboxElementUiProvider iOutboxElementUiProvider : this.providers) {
            if (!iOutboxElementUiProvider.isProviderFor(element)) continue;
            return iOutboxElementUiProvider;
        }
        return null;
    }

    private List<IOutboxElementUiProvider> getExtensions() {
        ArrayList<IOutboxElementUiProvider> ret = new ArrayList<IOutboxElementUiProvider>();
        IExtensionRegistry exr = Platform.getExtensionRegistry();
        IExtensionPoint exp = exr.getExtensionPoint("at.medevit.elexis.outbox.ui.elementsui");
        if (exp != null) {
            IExtension[] extensions;
            IExtension[] iExtensionArray = extensions = exp.getExtensions();
            int n = extensions.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement[] elems;
                IExtension ex = iExtensionArray[n2];
                IConfigurationElement[] iConfigurationElementArray = elems = ex.getConfigurationElements();
                int n3 = elems.length;
                int n4 = 0;
                while (n4 < n3) {
                    IConfigurationElement el = iConfigurationElementArray[n4];
                    if (el.getName().equals("uiprovider")) {
                        try {
                            ret.add((IOutboxElementUiProvider)el.createExecutableExtension("class"));
                        }
                        catch (CoreException e) {
                            logger.error("Error creating IOutboxElementsProvider {}", (Throwable)e);
                        }
                    }
                    ++n4;
                }
                ++n2;
            }
        }
        return ret;
    }

    public String getText(IOutboxElement element) {
        IOutboxElementUiProvider provider = this.getProvider(element);
        if (provider != null && provider.getLabelProvider() != null) {
            return provider.getLabelProvider().getText((Object)element);
        }
        return null;
    }

    public Image getImage(IOutboxElement element) {
        IOutboxElementUiProvider provider = this.getProvider(element);
        if (provider != null && provider.getLabelProvider() != null) {
            return provider.getLabelProvider().getImage((Object)element);
        }
        return null;
    }

    public Color getForeground(IOutboxElement element) {
        IOutboxElementUiProvider provider = this.getProvider(element);
        if (provider != null && provider.getColorProvider() != null) {
            return provider.getColorProvider().getForeground((Object)element);
        }
        return null;
    }

    public Color getBackground(IOutboxElement element) {
        IOutboxElementUiProvider provider = this.getProvider(element);
        if (provider != null && provider.getColorProvider() != null) {
            return provider.getColorProvider().getBackground((Object)element);
        }
        return null;
    }

    public void fireDoubleClicked(IOutboxElement element) {
        IOutboxElementUiProvider provider = this.getProvider(element);
        if (provider != null) {
            provider.doubleClicked(element);
        }
    }

    public IOutboxElementUiProvider getProviderFor(IOutboxElement element) {
        return this.getProvider(element);
    }
}

