/*
 * Decompiled with CFR 0.152.
 */
package at.medevit.elexis.outbox.ui.part.model;

import at.medevit.elexis.outbox.model.IOutboxElement;
import ch.elexis.core.model.IPatient;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public class PatientOutboxElements {
    private IPatient patient;
    private HashSet<IOutboxElement> elements = new HashSet();

    public PatientOutboxElements(IPatient patient) {
        this.patient = patient;
    }

    public List<IOutboxElement> getElements() {
        return new ArrayList<IOutboxElement>(this.elements);
    }

    public void addElement(IOutboxElement element) {
        this.elements.add(element);
    }

    public void removeElement(IOutboxElement element) {
        this.elements.remove(element);
    }

    public IPatient getPatient() {
        return this.patient;
    }

    public String toString() {
        if (this.patient == null) {
            return "nicht zugeordnet";
        }
        return this.patient.getLabel();
    }

    public Long getHighestLastupdate() {
        return this.elements.stream().mapToLong(e -> e.getLastupdate()).max().orElse(0L);
    }

    public void clear() {
        this.elements = new HashSet();
    }

    public boolean isEmpty() {
        return this.elements.isEmpty();
    }
}

