/*
 * Decompiled with CFR 0.152.
 */
package at.medevit.elexis.loinc.ui.providers;

import at.medevit.elexis.loinc.model.LoincCode;
import at.medevit.elexis.loinc.ui.LoincServiceComponent;
import ch.elexis.core.data.events.ElexisEventDispatcher;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class EditLoincCodeDialog
extends TitleAreaDialog {
    private Text code;
    private Text shortDesc;
    private Text unit;
    private Text text;
    private Text clazz;
    private LoincCode loincCode;

    public EditLoincCodeDialog(Shell parentShell, LoincCode code) {
        super(parentShell);
        this.loincCode = code;
    }

    protected Control createContents(Composite parent) {
        Control contents = super.createContents(parent);
        if (this.loincCode == null) {
            this.setTitle("Neuer LOINC Code");
            this.setMessage("Die Daten des neuen LOINC Code erfassen.");
        } else {
            this.setTitle("LOINC Code editieren");
            this.setMessage("Die Daten des LOINC Code \u00e4ndern.");
        }
        return contents;
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        Composite areaComposite = new Composite(composite, 0);
        areaComposite.setLayoutData((Object)new GridData(1808));
        areaComposite.setLayout((Layout)new FormLayout());
        Label lbl = new Label(areaComposite, 0);
        lbl.setText("Code");
        this.code = new Text(areaComposite, 2048);
        if (this.loincCode != null) {
            this.code.setText(this.loincCode.getCode());
        }
        FormData fd = new FormData();
        fd.top = new FormAttachment(0, 5);
        fd.left = new FormAttachment(0, 5);
        fd.right = new FormAttachment(20, -5);
        lbl.setLayoutData((Object)fd);
        fd = new FormData();
        fd.top = new FormAttachment(0, 5);
        fd.left = new FormAttachment(20, 5);
        fd.right = new FormAttachment(100, -5);
        this.code.setLayoutData((Object)fd);
        lbl = new Label(areaComposite, 0);
        lbl.setText("Kurz Beschreibung");
        this.shortDesc = new Text(areaComposite, 2048);
        if (this.loincCode != null) {
            this.shortDesc.setText(this.loincCode.get("shortname"));
        }
        fd = new FormData();
        fd.top = new FormAttachment((Control)this.code, 5);
        fd.left = new FormAttachment(0, 5);
        fd.right = new FormAttachment(20, -5);
        lbl.setLayoutData((Object)fd);
        fd = new FormData();
        fd.top = new FormAttachment((Control)this.code, 5);
        fd.left = new FormAttachment(20, 5);
        fd.right = new FormAttachment(100, -5);
        this.shortDesc.setLayoutData((Object)fd);
        lbl = new Label(areaComposite, 0);
        lbl.setText("Einheit");
        this.unit = new Text(areaComposite, 2048);
        if (this.loincCode != null) {
            this.unit.setText(this.loincCode.get("unit"));
        }
        fd = new FormData();
        fd.top = new FormAttachment((Control)this.shortDesc, 5);
        fd.left = new FormAttachment(0, 5);
        fd.right = new FormAttachment(20, -5);
        lbl.setLayoutData((Object)fd);
        fd = new FormData();
        fd.top = new FormAttachment((Control)this.shortDesc, 5);
        fd.left = new FormAttachment(20, 5);
        fd.right = new FormAttachment(100, -5);
        this.unit.setLayoutData((Object)fd);
        lbl = new Label(areaComposite, 0);
        lbl.setText("Text");
        this.text = new Text(areaComposite, 2626);
        if (this.loincCode != null) {
            this.text.setText(this.loincCode.get("longname"));
        }
        fd = new FormData();
        fd.top = new FormAttachment((Control)this.unit, 5);
        fd.left = new FormAttachment(0, 5);
        fd.right = new FormAttachment(20, -5);
        lbl.setLayoutData((Object)fd);
        fd = new FormData();
        fd.top = new FormAttachment((Control)this.unit, 5);
        fd.left = new FormAttachment(20, 5);
        fd.right = new FormAttachment(100, -5);
        fd.height = 100;
        this.text.setLayoutData((Object)fd);
        lbl = new Label(areaComposite, 0);
        lbl.setText("Klassifikation");
        this.clazz = new Text(areaComposite, 2048);
        if (this.loincCode != null) {
            this.clazz.setText(this.loincCode.get("class"));
        }
        fd = new FormData();
        fd.top = new FormAttachment((Control)this.text, 5);
        fd.left = new FormAttachment(0, 5);
        fd.right = new FormAttachment(20, -5);
        lbl.setLayoutData((Object)fd);
        fd = new FormData();
        fd.top = new FormAttachment((Control)this.text, 5);
        fd.left = new FormAttachment(20, 5);
        fd.right = new FormAttachment(100, -5);
        this.clazz.setLayoutData((Object)fd);
        return composite;
    }

    protected void okPressed() {
        String textTxt = this.text.getText();
        String codeTxt = this.code.getText();
        String shortTxt = this.shortDesc.getText();
        String unitTxt = this.unit.getText();
        String clazzTxt = this.clazz.getText();
        if (codeTxt.length() == 0) {
            this.setErrorMessage("LOINC code darf nicht leer sein.");
            return;
        }
        LoincCode existing = LoincServiceComponent.getService().getByCode(codeTxt);
        if (existing != null) {
            this.setErrorMessage("LOINC mit dem code " + codeTxt + " bereits vorhanden.");
            return;
        }
        this.loincCode = new LoincCode(codeTxt, textTxt, shortTxt, clazzTxt, unitTxt);
        ElexisEventDispatcher.reload(LoincCode.class);
        super.okPressed();
    }
}

