/*
 * Decompiled with CFR 0.152.
 */
package at.medevit.elexis.loinc.ui.importer;

import at.medevit.elexis.loinc.model.LoincCode;
import at.medevit.elexis.loinc.ui.LoincServiceComponent;
import ch.elexis.core.data.events.ElexisEventDispatcher;
import ch.elexis.core.l10n.Messages;
import ch.elexis.core.status.ElexisStatus;
import ch.elexis.core.ui.util.ImporterPage;
import ch.elexis.core.ui.util.SWTHelper;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class LoincCodeCsvImporter
extends ImporterPage {
    public LoincCodeCsvImporter() {
        this.results = new String[2];
    }

    public IStatus doImport(IProgressMonitor monitor) throws Exception {
        FileInputStream fis = null;
        if (this.results[0] != null && !this.results[0].isEmpty()) {
            File csv = new File(this.results[0]);
            try {
                try {
                    fis = new FileInputStream(csv);
                    LoincServiceComponent.getService().importFromCsv((InputStream)fis, LoincCodeCsvImporter.getFieldMapping());
                }
                catch (RuntimeException e) {
                    ElexisStatus elexisStatus = new ElexisStatus(4, "at.medevit.elexis.loinc.ui", 1, "Import failed", (Exception)e);
                    if (fis != null) {
                        fis.close();
                    }
                    return elexisStatus;
                }
            }
            finally {
                if (fis != null) {
                    fis.close();
                }
            }
            ElexisEventDispatcher.reload(LoincCode.class);
        }
        return Status.OK_STATUS;
    }

    public String getTitle() {
        return "LOINC Code CSV Importer";
    }

    public String getDescription() {
        return "LOIN Code Import aus einer CSV Datei. Format CODE,LONGNAME,SHORTNAME,CLASS,UNIT";
    }

    public List<String> getObjectClass() {
        return Collections.singletonList(LoincCode.class.getName());
    }

    public Composite createPage(Composite parent) {
        Composite area = new Composite(parent, 0);
        area.setLayout((Layout)new GridLayout(1, true));
        area.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        LoincFileBasedImporter fis = new LoincFileBasedImporter(area, this, "Loinc Code CSV Datei:", 0);
        fis.setLayoutData(new GridData(4, 0x1000000, true, false, 1, 1));
        return area;
    }

    private static Map<Integer, String> getFieldMapping() {
        HashMap<Integer, String> ret = new HashMap<Integer, String>();
        ret.put(0, "code");
        ret.put(1, "longname");
        ret.put(2, "shortname");
        ret.put(3, "class");
        ret.put(4, "unit");
        return ret;
    }

    private static class LoincFileBasedImporter
    extends Composite {
        public Text tFname;
        private String[] filterExts = new String[]{"*.csv"};
        private String[] filterNames = new String[]{Messages.Core_All_Files};

        public LoincFileBasedImporter(final Composite parent, final ImporterPage home, String message, final int resultIdx) {
            super(parent, 2048);
            this.setLayout((Layout)new GridLayout(1, false));
            Label lFile = new Label((Composite)this, 0);
            this.tFname = new Text((Composite)this, 2048);
            home.results[resultIdx] = this.tFname.getText();
            lFile.setText(message);
            lFile.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)false));
            this.tFname.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)false));
            Button bFile = new Button((Composite)this, 8);
            bFile.setText(Messages.ImporterPage_browse);
            bFile.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    FileDialog fdl = new FileDialog(parent.getShell(), 4096);
                    fdl.setFilterExtensions(filterExts);
                    fdl.setFilterNames(filterNames);
                    String filename = fdl.open();
                    if (filename != null) {
                        tFname.setText(filename);
                        home.results[resultIdx] = filename;
                    }
                }
            });
        }
    }
}

