/*
 * Decompiled with CFR 0.152.
 */
package at.medevit.elexis.loinc.ui.dialogs;

import at.medevit.elexis.loinc.model.LoincCode;
import at.medevit.elexis.loinc.ui.LoincServiceComponent;
import java.util.Comparator;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.DialogSettings;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.FilteredItemsSelectionDialog;
import org.eclipse.ui.internal.WorkbenchMessages;

public class LoincSelektor
extends FilteredItemsSelectionDialog {
    private boolean ignoreErrors;

    public LoincSelektor(Shell shell) {
        super(shell);
        this.setTitle("LOINC Code Selektion");
        this.setListLabelProvider((ILabelProvider)new LabelProvider(){

            public String getText(Object element) {
                if (element == null) {
                    return "";
                }
                return ((LoincCode)element).getLabel();
            }
        });
    }

    public LoincSelektor(Shell shell, Object data) {
        this(shell);
        if (data instanceof String && data.equals("ignoreErrors")) {
            this.ignoreErrors = true;
        }
    }

    protected void updateButtonsEnableState(IStatus status) {
        if (!this.ignoreErrors) {
            super.updateButtonsEnableState(status);
        }
    }

    protected Control createDialogArea(Composite parent) {
        String oldListLabel = WorkbenchMessages.FilteredItemsSelectionDialog_listLabel;
        this.setMessage("");
        WorkbenchMessages.FilteredItemsSelectionDialog_listLabel = "";
        Control ret = super.createDialogArea(parent);
        WorkbenchMessages.FilteredItemsSelectionDialog_listLabel = oldListLabel;
        return ret;
    }

    protected IDialogSettings getDialogSettings() {
        return new DialogSettings("loincselector");
    }

    protected IStatus validateItem(Object item) {
        return Status.OK_STATUS;
    }

    protected void okPressed() {
        if (this.ignoreErrors) {
            this.updateStatus(Status.OK_STATUS);
        }
        super.okPressed();
    }

    protected FilteredItemsSelectionDialog.ItemsFilter createFilter() {
        return new FilteredItemsSelectionDialog.ItemsFilter(this){

            public boolean isConsistentItem(Object item) {
                return true;
            }

            public boolean matchItem(Object item) {
                LoincCode code = (LoincCode)item;
                return this.matches(code.getLabel());
            }
        };
    }

    protected Comparator<LoincCode> getItemsComparator() {
        return new Comparator<LoincCode>(){

            @Override
            public int compare(LoincCode o1, LoincCode o2) {
                return o1.getLabel().compareTo(o2.getLabel());
            }
        };
    }

    protected void fillContentProvider(FilteredItemsSelectionDialog.AbstractContentProvider contentProvider, FilteredItemsSelectionDialog.ItemsFilter itemsFilter, IProgressMonitor progressMonitor) throws CoreException {
        List allCodes = LoincServiceComponent.getService().getAllCodes();
        for (LoincCode code : allCodes) {
            if (progressMonitor.isCanceled()) {
                return;
            }
            contentProvider.add((Object)code, itemsFilter);
        }
    }

    public String getElementName(Object item) {
        LoincCode code = (LoincCode)item;
        return code.getLabel();
    }

    protected Control createExtendedContentArea(Composite parent) {
        return null;
    }
}

