/*
 * Decompiled with CFR 0.152.
 */
package at.medevit.elexis.loinc.ui;

import at.medevit.elexis.loinc.model.ILoincCodeService;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.ui.PlatformUI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoincServiceComponent {
    private static Logger logger = LoggerFactory.getLogger(LoincServiceComponent.class);
    private static ILoincCodeService service;
    private static boolean updated;

    static {
        updated = false;
    }

    public static ILoincCodeService getService() {
        logger.info("Get updated " + updated + " service " + String.valueOf(service));
        if (!updated) {
            final IRunnableWithProgress job = new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException {
                    monitor.setTaskName("Updating Data");
                    service.updateData();
                }
            };
            PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

                @Override
                public void run() {
                    try {
                        PlatformUI.getWorkbench().getProgressService().busyCursorWhile(job);
                        updated = true;
                    }
                    catch (InvocationTargetException e) {
                        throw new IllegalStateException("Update failed." + String.valueOf(e));
                    }
                    catch (InterruptedException e) {
                        throw new IllegalStateException("Update failed." + String.valueOf(e));
                    }
                }
            });
        }
        return service;
    }

    public synchronized void setService(ILoincCodeService service) {
        LoincServiceComponent.service = service;
    }

    public synchronized void unsetService(ILoincCodeService service) {
        if (LoincServiceComponent.service == service) {
            LoincServiceComponent.service = null;
        }
    }
}

