/*
 * Decompiled with CFR 0.152.
 */
package at.medevit.elexis.inbox.ui.command;

import at.medevit.elexis.inbox.model.IInboxElement;
import at.medevit.elexis.inbox.model.IInboxElementService;
import at.medevit.elexis.inbox.ui.InboxModelServiceHolder;
import at.medevit.elexis.inbox.ui.part.InboxView;
import ch.elexis.core.model.Identifiable;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.handlers.HandlerUtil;
import org.slf4j.LoggerFactory;

public class IgnoreCommand
extends AbstractHandler
implements IHandler {
    public Object execute(final ExecutionEvent event) throws ExecutionException {
        IWorkbenchPart part = HandlerUtil.getActivePart((ExecutionEvent)event);
        if (part instanceof InboxView) {
            final InboxView view = (InboxView)part;
            if (MessageDialog.openQuestion((Shell)HandlerUtil.getActiveShell((ExecutionEvent)event), (String)"Als gelesen markieren", (String)"Wollen Sie alle Inbox Eintr\u00e4ge wirklich als gelesen markieren?")) {
                Shell activeshell = HandlerUtil.getActiveShell((ExecutionEvent)event);
                ProgressMonitorDialog progressDialog = new ProgressMonitorDialog(activeshell);
                try {
                    progressDialog.run(true, true, new IRunnableWithProgress(){

                        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                            List<IInboxElement> openElements = view.getOpenInboxElements();
                            monitor.beginTask("Inbox Eintr\u00e4ge als gelesen markieren", openElements.size());
                            for (IInboxElement ie : openElements) {
                                ie.setState(IInboxElementService.State.SEEN);
                                InboxModelServiceHolder.get().save((Identifiable)ie);
                                monitor.worked(1);
                                if (monitor.isCanceled()) break;
                            }
                            Display.getDefault().asyncExec(() -> {
                                IWorkbenchPart part = HandlerUtil.getActivePart((ExecutionEvent)event);
                                if (part instanceof InboxView) {
                                    InboxView view2 = (InboxView)part;
                                    view2.reload();
                                }
                            });
                        }
                    });
                }
                catch (InterruptedException | InvocationTargetException e) {
                    LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Error ignoring inbox entries", (Throwable)e);
                }
            }
        }
        return null;
    }
}

