/*
 * Decompiled with CFR 0.152.
 */
package at.medevit.elexis.inbox.ui.part.provider;

import at.medevit.elexis.inbox.model.IInboxElement;
import at.medevit.elexis.inbox.ui.part.model.PatientInboxElements;
import at.medevit.elexis.inbox.ui.part.provider.InboxElementUiExtension;
import ch.elexis.core.model.IPatient;
import ch.elexis.core.types.Gender;
import ch.elexis.core.ui.icons.Images;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;

public class InboxElementLabelProvider
extends LabelProvider
implements IColorProvider {
    private InboxElementUiExtension extension = new InboxElementUiExtension();

    public String getText(Object element) {
        if (element instanceof PatientInboxElements) {
            return ((PatientInboxElements)element).toString();
        }
        if (element instanceof IInboxElement) {
            String text = this.extension.getText((IInboxElement)element);
            if (text != null) {
                return text;
            }
            Object obj = ((IInboxElement)element).getObject();
            if (obj != null) {
                return "unbekannt [" + obj.getClass().getSimpleName() + "]";
            }
            return "unbekannt";
        }
        return super.getText(element);
    }

    public Image getImage(Object element) {
        if (element instanceof PatientInboxElements) {
            IPatient pat = ((PatientInboxElements)element).getPatient();
            if (pat != null) {
                if (pat.getGender() == Gender.MALE) {
                    return Images.IMG_MANN.getImage();
                }
                return Images.IMG_FRAU.getImage();
            }
            return Images.IMG_QUESTION_MARK.getImage();
        }
        if (element instanceof IInboxElement) {
            Image image = this.extension.getImage((IInboxElement)element);
            if (image != null) {
                return image;
            }
            return Images.IMG_QUESTION_MARK.getImage();
        }
        return null;
    }

    public Color getForeground(Object element) {
        Color color;
        if (element instanceof IInboxElement && (color = this.extension.getForeground((IInboxElement)element)) != null) {
            return color;
        }
        return Display.getCurrent().getSystemColor(2);
    }

    public Color getBackground(Object element) {
        Color color;
        if (element instanceof IInboxElement && (color = this.extension.getBackground((IInboxElement)element)) != null) {
            return color;
        }
        return Display.getCurrent().getSystemColor(1);
    }

    public boolean isVisible(IInboxElement element) {
        return this.extension.isVisible(element);
    }
}

