/*
 * Decompiled with CFR 0.152.
 */
package at.medevit.elexis.inbox.ui.part.provider;

import at.medevit.elexis.inbox.model.IInboxElement;
import at.medevit.elexis.inbox.model.IInboxElementService;
import at.medevit.elexis.inbox.ui.part.InboxView;
import at.medevit.elexis.inbox.ui.part.model.PatientInboxElements;
import ch.elexis.core.model.IMandator;
import ch.elexis.core.model.IPatient;
import ch.elexis.core.services.holder.ContextServiceHolder;
import ch.elexis.core.ui.e4.fieldassist.PatientSearchToken;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Display;
import org.slf4j.LoggerFactory;

public class InboxElementContentProvider
implements IStructuredContentProvider {
    private static final int PAGING_FETCHSIZE = 100;
    private int page = 1;
    private List<IInboxElement> items;
    private InboxView inboxView;
    private String searchText;
    private List<IInboxElement> filteredItems;
    private Job currentJob;

    public InboxElementContentProvider(InboxView inboxView) {
        this.inboxView = inboxView;
    }

    public Object[] getElements(Object inputElement) {
        List<IInboxElement> list;
        this.page = this.inboxView.getPagingComposite().getCurrentPage();
        List<IInboxElement> list2 = list = this.filteredItems != null ? this.filteredItems : this.items;
        if (list != null) {
            if (this.page > 0 && list.size() > 0) {
                if (list.size() >= this.page * 100) {
                    return list.subList((this.page - 1) * 100, this.page * 100).toArray();
                }
                return list.subList((this.page - 1) * 100, list.size() - 1).toArray();
            }
            return list.toArray();
        }
        return Collections.emptyList().toArray();
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        if (newInput instanceof List) {
            List input = (List)newInput;
            LoggerFactory.getLogger(this.getClass()).info("items empty [" + input.size() + "]");
            this.items = Collections.emptyList();
            this.filteredItems = null;
            Display.getDefault().asyncExec(() -> viewer.refresh());
            if (this.currentJob != null) {
                this.currentJob.cancel();
            }
            this.currentJob = new LoadingInboxJob(input);
            this.currentJob.schedule();
        }
    }

    public void refreshElement(IInboxElement element) {
        if (this.items != null) {
            if (element.getState() == IInboxElementService.State.SEEN) {
                this.items.remove(element);
                if (this.filteredItems != null) {
                    this.filteredItems.remove(element);
                }
            } else {
                IMandator activeMandant = ContextServiceHolder.get().getActiveMandator().orElse(null);
                IMandator inboxMandant = element.getMandator();
                if (!inboxMandant.equals(activeMandant)) {
                    this.items.remove(element);
                    if (this.filteredItems != null) {
                        this.filteredItems.remove(element);
                    }
                } else if (this.currentJob == null) {
                    this.items.addFirst(element);
                    Display.getDefault().asyncExec(() -> {
                        this.page = 1;
                        this.inboxView.getPagingComposite().setup(this.page, this.items.size(), 100);
                        this.inboxView.getViewer().refresh();
                    });
                }
            }
        }
    }

    public void setSearchText(String search) {
        this.searchText = search;
        CompletableFuture.runAsync(() -> {
            if (this.searchText != null && this.searchText.length() > 1) {
                List searchParts = PatientSearchToken.getPatientSearchTokens((String[])this.searchText.toLowerCase().split(" "));
                this.filteredItems = this.items.stream().filter(i -> this.filterPatient(searchParts, (IInboxElement)i)).collect(Collectors.toList());
                Display.getDefault().asyncExec(() -> {
                    this.page = 1;
                    this.inboxView.getPagingComposite().setup(this.page, this.filteredItems.size(), 100);
                    this.inboxView.getViewer().refresh();
                });
            } else {
                this.filteredItems = null;
                Display.getDefault().asyncExec(() -> {
                    this.page = 1;
                    this.inboxView.getPagingComposite().setup(this.page, this.items.size(), 100);
                    this.inboxView.getViewer().refresh();
                });
            }
        });
    }

    private boolean filterPatient(List<PatientSearchToken> searchParts, IInboxElement i) {
        if (i.getPatient() != null) {
            return searchParts.parallelStream().allMatch(st -> st.test(i.getPatient()));
        }
        return false;
    }

    private class LoadingInboxJob
    extends Job {
        private List<IInboxElement> input;

        public LoadingInboxJob(List<IInboxElement> input) {
            super("Loading Inbox");
            this.input = input;
        }

        protected IStatus run(IProgressMonitor monitor) {
            monitor.beginTask("Lade Inbox", this.input.size());
            HashMap<IPatient, PatientInboxElements> map = new HashMap<IPatient, PatientInboxElements>();
            for (IInboxElement inboxElement : this.input) {
                IPatient patient = inboxElement.getPatient();
                PatientInboxElements patientInbox = (PatientInboxElements)map.get(patient);
                if (patientInbox == null) {
                    patientInbox = new PatientInboxElements(patient);
                    map.put(patient, patientInbox);
                }
                patientInbox.addElement(inboxElement);
                monitor.worked(1);
                if (!monitor.isCanceled()) continue;
                return Status.CANCEL_STATUS;
            }
            InboxElementContentProvider.this.items = map.values().stream().flatMap(pie -> pie.getElements().stream()).filter(ie -> ie != null).collect(Collectors.toList());
            InboxElementContentProvider.this.items.sort((l, r) -> r.getLastupdate().compareTo(l.getLastupdate()));
            if (monitor.isCanceled()) {
                return Status.CANCEL_STATUS;
            }
            if (StringUtils.isNotBlank((CharSequence)InboxElementContentProvider.this.searchText)) {
                InboxElementContentProvider.this.setSearchText(InboxElementContentProvider.this.searchText);
            }
            Display.getDefault().asyncExec(() -> {
                InboxElementContentProvider.this.page = 1;
                InboxElementContentProvider.this.inboxView.getPagingComposite().setup(InboxElementContentProvider.this.page, InboxElementContentProvider.this.items.size(), 100);
                InboxElementContentProvider.this.inboxView.getViewer().refresh();
            });
            InboxElementContentProvider.this.currentJob = null;
            return Status.OK_STATUS;
        }
    }
}

