/*
 * Decompiled with CFR 0.152.
 */
package at.medevit.elexis.inbox.core.ui;

import at.medevit.elexis.inbox.core.ui.LabGroupedInboxElements;
import at.medevit.elexis.inbox.core.ui.preferences.InboxPreferences;
import at.medevit.elexis.inbox.model.IInboxElement;
import ch.elexis.core.model.ILabResult;
import ch.elexis.core.ui.icons.Images;
import ch.elexis.data.LabResult;
import ch.rgw.tools.TimeTool;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.DecorationOverlayIcon;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.IToolTipProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class LabResultLabelProvider
extends LabelProvider
implements IColorProvider,
IToolTipProvider {
    private static Image pathologicLabImage;

    public Image getImage(Object element) {
        Object object;
        if (element instanceof LabGroupedInboxElements ? ((LabGroupedInboxElements)((Object)element)).isPathologic() : (object = ((IInboxElement)element).getObject()) instanceof ILabResult && ((ILabResult)object).isPathologic()) {
            return this.getPathologicLabImage();
        }
        return Images.IMG_VIEW_LABORATORY.getImage();
    }

    private Image getPathologicLabImage() {
        if (pathologicLabImage == null) {
            LabResultLabelProvider.initializeImages();
        }
        return pathologicLabImage;
    }

    private static void initializeImages() {
        ImageDescriptor[] overlays = new ImageDescriptor[]{AbstractUIPlugin.imageDescriptorFromPlugin((String)"at.medevit.elexis.inbox.ui", (String)"/rsc/img/achtung_overlay.png")};
        pathologicLabImage = new DecorationOverlayIcon(Images.IMG_VIEW_LABORATORY.getImage(), overlays).createImage();
    }

    public String getText(Object element) {
        if (element instanceof LabGroupedInboxElements) {
            return ((LabGroupedInboxElements)((Object)element)).getLabel();
        }
        Object object = ((IInboxElement)element).getObject();
        if (object instanceof LabResult) {
            LabResult labResult = (LabResult)object;
            List<LabelFields> labelFields = InboxPreferences.getChoosenLabel();
            StringBuilder sb = new StringBuilder();
            for (LabelFields lblField : labelFields) {
                sb.append(lblField.getValue(labResult));
                sb.append(", ");
            }
            if (!sb.toString().isEmpty() && sb.substring(sb.length() - 2, sb.length()).equals(", ")) {
                sb.replace(sb.length() - 2, sb.length(), "");
            }
            return sb.toString();
        }
        if (object instanceof ILabResult) {
            ILabResult labResult = (ILabResult)object;
            List<LabelFields> labelFields = InboxPreferences.getChoosenLabel();
            StringBuilder sb = new StringBuilder();
            for (LabelFields lblField : labelFields) {
                sb.append(lblField.getValue(labResult));
                sb.append(", ");
            }
            if (!sb.toString().isEmpty() && sb.substring(sb.length() - 2, sb.length()).equals(", ")) {
                sb.replace(sb.length() - 2, sb.length(), "");
            }
            return sb.toString();
        }
        return ((IInboxElement)element).getLabel();
    }

    public Color getForeground(Object element) {
        if (element instanceof LabGroupedInboxElements) {
            return Display.getCurrent().getSystemColor(2);
        }
        boolean pathologic = false;
        Object object = ((IInboxElement)element).getObject();
        if (object instanceof LabResult) {
            pathologic = ((LabResult)object).isFlag(1);
        } else if (object instanceof ILabResult) {
            pathologic = ((ILabResult)object).isPathologic();
        }
        if (pathologic) {
            return Display.getCurrent().getSystemColor(3);
        }
        return Display.getCurrent().getSystemColor(2);
    }

    public Color getBackground(Object element) {
        return Display.getCurrent().getSystemColor(1);
    }

    public String getToolTipText(Object element) {
        List<ILabResult> pathologicResults;
        if (element instanceof LabGroupedInboxElements && !(pathologicResults = ((LabGroupedInboxElements)((Object)element)).getPathologicResults()).isEmpty()) {
            StringBuilder sb = new StringBuilder("Pathologische Resultate:\n");
            for (ILabResult labResult : pathologicResults) {
                sb.append(labResult.getItem().getCode() + ", " + labResult.getItem().getName() + ", " + labResult.getResult()).append("\n");
            }
            return sb.toString();
        }
        return null;
    }

    public static enum LabelFields {
        LAB_VALUE_SHORT("K\u00fcrzel"),
        LAB_VALUE_NAME("Name"),
        REF_RANGE("Referenzbereich"),
        LAB_RESULT("Resultat"),
        ORIGIN("Herkunft"),
        DATE("Datum");

        private final String text;
        private DateTimeFormatter formatter = DateTimeFormatter.ofPattern("dd.MM.yyyy");

        private LabelFields(String text) {
            this.text = text;
        }

        public String toString() {
            return this.text;
        }

        public static LabelFields getEnum(String value) {
            if (value.equals(LAB_VALUE_SHORT.toString())) {
                return LAB_VALUE_SHORT;
            }
            if (value.equals(LAB_VALUE_NAME.toString())) {
                return LAB_VALUE_NAME;
            }
            if (value.equals(LAB_RESULT.toString())) {
                return LAB_RESULT;
            }
            if (value.equals(REF_RANGE.toString())) {
                return REF_RANGE;
            }
            if (value.equals(ORIGIN.toString())) {
                return ORIGIN;
            }
            if (value.equals(DATE.toString())) {
                return DATE;
            }
            return null;
        }

        public String getValue(LabResult labResult) {
            switch (this) {
                case LAB_VALUE_SHORT: {
                    return labResult.getItem().getKuerzel();
                }
                case LAB_VALUE_NAME: {
                    return labResult.getItem().getName();
                }
                case LAB_RESULT: {
                    return labResult.getResult();
                }
                case REF_RANGE: {
                    return labResult.getRefMale() + "/" + labResult.getRefFemale();
                }
                case ORIGIN: {
                    return labResult.getOrigin().getLabel();
                }
                case DATE: {
                    TimeTool observationTime = labResult.getObservationTime();
                    if (observationTime == null) {
                        return labResult.getDate();
                    }
                    return observationTime.toString(4);
                }
            }
            return "";
        }

        public String getValue(ILabResult labResult) {
            switch (this) {
                case LAB_VALUE_SHORT: {
                    return labResult.getItem().getCode();
                }
                case LAB_VALUE_NAME: {
                    return labResult.getItem().getName();
                }
                case LAB_RESULT: {
                    return labResult.getResult();
                }
                case REF_RANGE: {
                    return labResult.getReferenceMale() + "/" + labResult.getReferenceFemale();
                }
                case ORIGIN: {
                    return labResult.getOrigin().getLabel();
                }
                case DATE: {
                    LocalDateTime observationTime = labResult.getObservationTime();
                    if (observationTime == null) {
                        return labResult.getDate().format(this.formatter);
                    }
                    return observationTime.format(this.formatter);
                }
            }
            return "";
        }
    }
}

