/*
 * Decompiled with CFR 0.152.
 */
package at.medevit.elexis.inbox.core.elements;

import at.medevit.elexis.inbox.core.elements.service.ServiceComponent;
import ch.elexis.core.model.IContact;
import ch.elexis.core.model.ILabOrder;
import ch.elexis.core.model.ILabResult;
import ch.elexis.core.model.IMandator;
import ch.elexis.core.model.IPatient;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.services.holder.ContextServiceHolder;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AddLabInboxElement
implements Runnable {
    private static Logger logger = LoggerFactory.getLogger(AddLabInboxElement.class);
    private static final int MAX_WAIT = 40;
    private ILabResult labResult;

    public AddLabInboxElement(ILabResult labResult) {
        this.labResult = labResult;
    }

    @Override
    public void run() {
        if (this.labResult.getPatient() == null) {
            int waitForFields = 0;
            while (waitForFields < 40) {
                try {
                    ++waitForFields;
                    Thread.sleep(500L);
                    if (this.labResult.getPatient() == null) continue;
                    break;
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            if (waitForFields == 40) {
                logger.warn(String.format("Could not get data from result [%s].", this.labResult.getId()));
                return;
            }
        }
        IPatient patient = this.labResult.getPatient();
        IContact doctor = this.labResult.getPatient().getFamilyDoctor();
        IMandator assignedMandant = this.loadAssignedMandant(true);
        if (doctor == null) {
            if (assignedMandant == null) {
                assignedMandant = ContextServiceHolder.get().getActiveMandator().orElse(null);
            }
        } else if (doctor.isMandator()) {
            logger.debug("Creating InboxElement for result [" + this.labResult.getId() + "] and patient " + patient.getLabel() + " for mandant " + doctor.getLabel());
            ServiceComponent.get().createInboxElement(patient, ServiceComponent.load(doctor.getId(), IMandator.class), (Identifiable)this.labResult);
        }
        if (assignedMandant != null && !assignedMandant.equals(doctor)) {
            logger.debug("Creating InboxElement for result [" + this.labResult.getId() + "] and patient " + patient.getLabel() + " for mandant " + assignedMandant.getLabel());
            ServiceComponent.get().createInboxElement(patient, assignedMandant, (Identifiable)this.labResult);
        }
    }

    private IMandator loadAssignedMandant(boolean retry) {
        List<ILabOrder> orders = ServiceComponent.getLabOrders(this.labResult);
        if (orders != null && !orders.isEmpty() && orders.get(0).getMandator() != null) {
            return orders.get(0).getMandator();
        }
        if (retry) {
            try {
                Thread.sleep(1500L);
                return this.loadAssignedMandant(false);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return null;
    }
}

