/*
 * Decompiled with CFR 0.152.
 */
package at.medevit.elexis.impfplan.model.vaccplans;

import at.medevit.elexis.impfplan.model.vaccplans.AbstractVaccinationPlan;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class ImpfplanSchweiz2015
extends AbstractVaccinationPlan {
    private List<AbstractVaccinationPlan.RequiredVaccination> vaccPlan = null;
    private static final String[] vaccPlanCH2013 = new String[]{"2;J07AF/B,J07AM/B,J07AJ/B,J07BF/B,J07AG/B,J07AL/E", "4;J07AF/B,J07AM/B,J07AJ/B,J07BF/B,J07AG/B,J07AL/E", "6;J07AF/B,J07AM/B,J07AJ/B,J07BF/B,J07AG/B", "12;J07BD/B,J07BE/B,J07BJ/B,J07AL/E", "12-15;J07AH/E", "15-24;J07AF/B,J07AM/B,J07AJ/B,J07BF/B,J07AG/B,J07BD/B,J07BE/B,J07BJ/B", "48-84;J07AF/B,J07AM/B,J07AJ/B,J07BF/B", "132-180;J07AF/B,J07AM/B,J07AJ/B,J07BC01/B,J07BM/B", "300-348;J07AF/B,J07AM/B,J07AJ/B", "540;J07AF/B,J07AM/B", "780;J07AF/B,J07AM/B,J07AL,J07BB"};

    public ImpfplanSchweiz2015() {
        super("VACC_CH_2015", "Schweizerischer Impfplan 2015");
    }

    @Override
    protected void initialize() {
        this.vaccPlan = this.parseVaccPlan(new ArrayList<AbstractVaccinationPlan.RequiredVaccination>());
    }

    @Override
    public List<String> getOrderedBaseDiseases() {
        String[] values;
        ArrayList<String> rv = new ArrayList<String>();
        String[] stringArray = values = "J07AF,J07AM,J07AJ,J07BF,J07AG,J07BC01,J07BC02,J07BD,J07BE,J07BJ,J07BM".split(",");
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray[n2];
            rv.add(string);
            ++n2;
        }
        Collections.reverse(rv);
        return rv;
    }

    @Override
    public List<String> getOrderedExtendedDiseases() {
        String[] values;
        ArrayList<String> rv = new ArrayList<String>();
        String[] stringArray = values = "J07BK,J07AL,J07AH,J07BA01".split(",");
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray[n2];
            rv.add(string);
            ++n2;
        }
        Collections.reverse(rv);
        return rv;
    }

    @Override
    protected List<AbstractVaccinationPlan.RequiredVaccination> addBaseVaccinations(List<AbstractVaccinationPlan.RequiredVaccination> baseVaccinations) {
        for (AbstractVaccinationPlan.RequiredVaccination rv : this.vaccPlan) {
            if (!rv.diseaseAtcCode.endsWith("/B")) continue;
            baseVaccinations.add(rv);
        }
        return baseVaccinations;
    }

    @Override
    protected List<AbstractVaccinationPlan.RequiredVaccination> addExtendedVaccinations(List<AbstractVaccinationPlan.RequiredVaccination> extendedVaccinations) {
        for (AbstractVaccinationPlan.RequiredVaccination rv : this.vaccPlan) {
            if (!rv.diseaseAtcCode.endsWith("/E")) continue;
            extendedVaccinations.add(rv);
        }
        return extendedVaccinations;
    }

    private List<AbstractVaccinationPlan.RequiredVaccination> parseVaccPlan(List<AbstractVaccinationPlan.RequiredVaccination> vaccPlan) {
        String[] stringArray = vaccPlanCH2013;
        int n = vaccPlanCH2013.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            String[] split = line.split(";");
            int[] timeFrames = this.splitTimeFrames(split[0]);
            List<String> atcCodes = Arrays.asList(split[1].split(","));
            for (String atc : atcCodes) {
                AbstractVaccinationPlan.RequiredVaccination rv = new AbstractVaccinationPlan.RequiredVaccination(timeFrames[0], timeFrames[1], atc);
                vaccPlan.add(rv);
            }
            ++n2;
        }
        return vaccPlan;
    }

    private int[] splitTimeFrames(String timeString) {
        int[] retVal = new int[2];
        Arrays.fill(retVal, -1);
        String[] split = timeString.split("-");
        int i = 0;
        while (i < split.length) {
            retVal[i] = Integer.parseInt(split[i]);
            ++i;
        }
        return retVal;
    }
}

