/*
 * Decompiled with CFR 0.152.
 */
package at.medevit.elexis.impfplan.model.vaccplans;

import at.medevit.elexis.impfplan.model.vaccplans.AbstractVaccinationPlan;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class ImpfplanSchweiz2019
extends AbstractVaccinationPlan {
    private List<AbstractVaccinationPlan.RequiredVaccination> vaccPlan = null;
    private static final String[] vaccPlanCH2019 = new String[]{"2;J07AF/B,J07AM/B,J07AJ/B,J07BF/B,J07AG/B,J07AL/B,J07BC01/B", "4;J07AF/B,J07AM/B,J07AJ/B,J07BF/B,J07AG/B,J07AL/B,J07BC01/B", "9;J07BD/B,J07BE/B,J07BJ/B", "12;J07AF/B,J07AM/B,J07AJ/B,J07BF/B,J07AG/B,J07AL/B,J07BC01/B,J07BD/B,J07BE/B,J07BJ/B", "24;J07AH/E", "48-84;J07AF/B,J07AM/B,J07AJ/B,J07BF/B", "132-180;J07AF/B,J07AM/B,J07AJ/B,J07BC01/B,J07BM/B,J07BK01/B,J07AH/E", "300;J07AF/B,J07AM/B,J07AJ/B,J07BM/E", "180-312;J07BM/E", "540;J07AF/B,J07AM/B", "780;J07AF/B,J07AM/B,J07BB,J07BK02/E"};

    public ImpfplanSchweiz2019() {
        super("VACC_CH_2019", "Schweizerischer Impfplan 2022");
    }

    @Override
    protected void initialize() {
        this.vaccPlan = this.parseVaccPlan(new ArrayList<AbstractVaccinationPlan.RequiredVaccination>());
    }

    @Override
    public List<String> getOrderedBaseDiseases() {
        String[] values;
        ArrayList<String> rv = new ArrayList<String>();
        String[] stringArray = values = "J07AF,J07AM,J07AJ,J07AG,J07BF,J07BC01,J07AL,J07BD,J07BE,J07BJ,J07BK01,J07BM,J07BB".split(",");
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray[n2];
            rv.add(string);
            ++n2;
        }
        Collections.reverse(rv);
        return rv;
    }

    @Override
    public List<String> getOrderedExtendedDiseases() {
        String[] values;
        ArrayList<String> rv = new ArrayList<String>();
        String[] stringArray = values = "J07AH,J07BK02".split(",");
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray[n2];
            rv.add(string);
            ++n2;
        }
        Collections.reverse(rv);
        return rv;
    }

    @Override
    protected List<AbstractVaccinationPlan.RequiredVaccination> addBaseVaccinations(List<AbstractVaccinationPlan.RequiredVaccination> baseVaccinations) {
        for (AbstractVaccinationPlan.RequiredVaccination rv : this.vaccPlan) {
            if (!rv.diseaseAtcCode.endsWith("/B")) continue;
            baseVaccinations.add(rv);
        }
        return baseVaccinations;
    }

    @Override
    protected List<AbstractVaccinationPlan.RequiredVaccination> addExtendedVaccinations(List<AbstractVaccinationPlan.RequiredVaccination> extendedVaccinations) {
        for (AbstractVaccinationPlan.RequiredVaccination rv : this.vaccPlan) {
            if (!rv.diseaseAtcCode.endsWith("/E")) continue;
            extendedVaccinations.add(rv);
        }
        return extendedVaccinations;
    }

    private List<AbstractVaccinationPlan.RequiredVaccination> parseVaccPlan(List<AbstractVaccinationPlan.RequiredVaccination> vaccPlan) {
        String[] stringArray = vaccPlanCH2019;
        int n = vaccPlanCH2019.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            String[] split = line.split(";");
            int[] timeFrames = this.splitTimeFrames(split[0]);
            List<String> atcCodes = Arrays.asList(split[1].split(","));
            for (String atc : atcCodes) {
                AbstractVaccinationPlan.RequiredVaccination rv = new AbstractVaccinationPlan.RequiredVaccination(timeFrames[0], timeFrames[1], atc);
                vaccPlan.add(rv);
            }
            ++n2;
        }
        return vaccPlan;
    }

    private int[] splitTimeFrames(String timeString) {
        int[] retVal = new int[2];
        Arrays.fill(retVal, -1);
        String[] split = timeString.split("-");
        int i = 0;
        while (i < split.length) {
            retVal[i] = Integer.parseInt(split[i]);
            ++i;
        }
        return retVal;
    }
}

