/*
 * Decompiled with CFR 0.152.
 */
package at.medevit.elexis.impfplan.ui;

import at.medevit.elexis.impfplan.model.ArticleToImmunisationModel;
import at.medevit.elexis.impfplan.model.DiseaseDefinitionModel;
import at.medevit.elexis.impfplan.model.po.Vaccination;
import at.medevit.elexis.impfplan.ui.GraphicsUtil;
import at.medevit.elexis.impfplan.ui.VaccinationComposite;
import at.medevit.elexis.impfplan.ui.VaccinationPlanHeaderDefinition;
import ch.elexis.core.services.holder.ConfigServiceHolder;
import ch.elexis.core.ui.UiDesk;
import ch.rgw.tools.TimeTool;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.NavigableMap;
import java.util.TreeMap;
import org.eclipse.jface.resource.FontDescriptor;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Widget;

public class VaccinationCompositePaintListener
implements PaintListener {
    private static final String VACCINE = "Impfstoff";
    private static final String TRADENAME = "Handelsname";
    private static final String LOT_NO = "Lot Nr.";
    private static final String ADMINISTRATOR = "Arzt";
    private static final String DATE = "Datum";
    private static final String AGE = "Alter";
    private static final String SIDE = "Seite";
    private static int HEADER_HEIGHT = -1;
    private static final int SEPARATOR_WIDTH_BASE_EXTENDED = 2;
    private static final int OFFSET = 15;
    private final Color COLOR_WHITE = UiDesk.getColor((String)"weiss");
    private final Color COLOR_BOTTOM = UiDesk.getColorFromRGB((String)"D0DCF2");
    private final Color COLOR_DARKGREY = UiDesk.getColor((String)"dunkelgrau");
    private final Color COLOR_LIGHTGREY = UiDesk.getColorFromRGB((String)"F0F0F0");
    private final Color COLOR_BLACK = UiDesk.getColor((String)"schwarz");
    private final Color COLOR_GREEN = UiDesk.getColorFromRGB((String)"39961C");
    private final Color COLOR_CREME = UiDesk.getColorFromRGB((String)"FEFFB1");
    private final Font headerFont;
    private final Font boldFont;
    private final Font defaultFont;
    private final int fontHeightDefaultFont;
    private final int fontHeightBoldFont;
    private int separatorBoundary;
    private int locationOfLotNrBorder;
    private int locationOfDocBorder;
    private int locationOfDateBorder;
    private int locationOfAgeBorder;
    private int locationOfFirstDisease;
    private int locationOfSideBorder;
    private int distanceBetweenDiseases = 19;
    private int lengthOfBasisimpfungen;
    private int lengthOfDoctor;
    private int lengthOfLotNr;
    private int lengthOfDateString;
    private int lengthOfSide;
    private int leftStart;
    private List<Vaccination> _vaccinations;
    private List<DiseaseBoundary> diseaseBoundaries = new ArrayList<DiseaseBoundary>();
    private VaccinationPlanHeaderDefinition _vphd;
    private Vaccination selectedVacc;
    private TimeTool _administrationDate;
    private TimeTool _patientBirthDate;
    public NavigableMap<Integer, Vaccination> naviVacMap;
    private boolean showSide;
    private int maxLengthBasisImpf = 150;
    private int maxLengthDoctor = 100;
    private int maxLengthLotNr = 70;
    private int pageElementCount = 20;
    private int pageTotalSize = 1;
    private int entryHeight;
    private int defaultEntryHeight;
    private ScrolledComposite scrolledComposite;
    public int mouseX;
    public int mouseY;

    public VaccinationCompositePaintListener() {
        Display disp = Display.getCurrent();
        this.defaultFont = UiDesk.getFont((String)"anwender/stdfont");
        FontDescriptor boldDescriptor = FontDescriptor.createFrom((Font)this.defaultFont).setStyle(1);
        this.boldFont = boldDescriptor.createFont((Device)disp);
        this.headerFont = new Font((Device)disp, "Helvetica", 16, 1);
        this.distanceBetweenDiseases = (int)((double)this.distanceBetweenDiseases * this.getScaleFactor());
        this.fontHeightDefaultFont = (int)((double)(this.defaultFont.getFontData()[0].getHeight() + 5) * this.getScaleFactor());
        this.fontHeightBoldFont = (int)((double)(this.boldFont.getFontData()[0].getHeight() + 5) * this.getScaleFactor());
        this.defaultEntryHeight = this.entryHeight = (int)((double)(this.fontHeightBoldFont + 4) * this.getScaleFactor());
        this.naviVacMap = new TreeMap<Integer, Vaccination>();
        this.selectedVacc = null;
        this.showSide = ConfigServiceHolder.getUser((String)"plugins/impfplan/showside", (boolean)false);
    }

    private boolean shouldScale() {
        String osName = System.getProperty("os.name").toLowerCase();
        return osName.startsWith("win") && this.getWindowsVersion() < 10.0;
    }

    private double getWindowsVersion() {
        String osVersion = System.getProperty("os.version").toLowerCase();
        try {
            return Double.valueOf(osVersion);
        }
        catch (NumberFormatException numberFormatException) {
            return 6.1;
        }
    }

    public double getScaleFactor() {
        if (this.shouldScale()) {
            int dpi = Display.getDefault().getDPI().x;
            if (dpi == 120) {
                return 1.25;
            }
            if (dpi == 144) {
                return 1.5;
            }
        }
        return 1.0;
    }

    public void paintControl(PaintEvent e) {
        VaccinationComposite vaccinationComposite;
        Composite parent;
        if (this._vphd == null) {
            return;
        }
        this.paintControl(e.gc, e.display, e.width, e.height, false, -1);
        Widget widget = e.widget;
        if (widget instanceof VaccinationComposite && (parent = (vaccinationComposite = (VaccinationComposite)widget).getParent()) instanceof ScrolledComposite) {
            this.scrolledComposite = (ScrolledComposite)parent;
            this.scrolledComposite.setMinSize(vaccinationComposite.computeSize(-1, -1));
        }
    }

    public void paintControl(GC gc, Display display, int width, int height, boolean b, int pageIdx) {
        if (b) {
            this.showSide = false;
            width = 800;
            this.maxLengthBasisImpf = 150;
            this.maxLengthDoctor = 100;
            this.maxLengthLotNr = 70;
        } else {
            if (width < 800) {
                width = 800;
            }
            if (this.scrolledComposite != null && this.scrolledComposite.getVerticalBar().isVisible()) {
                width -= this.scrolledComposite.getVerticalBar().getSize().x;
            }
            if (this.locationOfLotNrBorder - 15 > 0) {
                this.maxLengthBasisImpf = this.locationOfLotNrBorder - 15;
            }
            if (this.locationOfDocBorder - 15 > 0) {
                this.maxLengthLotNr = this.locationOfDocBorder - 15;
                if ((float)width * 0.1f < (float)this.maxLengthLotNr) {
                    this.maxLengthLotNr = (int)((float)width * 0.1f);
                }
            }
            if (this.locationOfDateBorder - 15 > 0) {
                this.maxLengthDoctor = this.locationOfDateBorder - 15;
                if ((float)width * 0.2f < (float)this.maxLengthDoctor) {
                    this.maxLengthDoctor = (int)((float)width * 0.2f);
                }
            }
        }
        boolean wrapText = false;
        for (Vaccination vacc : this._vaccinations) {
            if (this.wrapTextByWidth(gc, vacc.getShortBusinessName(), this.maxLengthBasisImpf, false).contains("\n")) {
                wrapText = true;
                break;
            }
            if (this.wrapTextByWidth(gc, vacc.getLotNo(), this.maxLengthLotNr, true).contains("\n")) {
                wrapText = true;
                break;
            }
            if (!this.wrapTextByWidth(gc, vacc.getAdministratorLabel(), this.maxLengthDoctor, false).contains("\n")) continue;
            wrapText = true;
            break;
        }
        this.entryHeight = this.defaultEntryHeight;
        if (wrapText) {
            this.entryHeight += this.defaultEntryHeight;
        }
        if (b) {
            this.pageElementCount = (height - HEADER_HEIGHT) / this.entryHeight;
            this.pageTotalSize = (int)Math.ceil((float)this._vaccinations.size() / (float)this.pageElementCount);
        } else {
            this.pageTotalSize = 1;
        }
        this.determineMinWidth(gc, wrapText);
        this.drawHeader(gc, display, width, pageIdx);
        this.drawEntries(gc, display, width, b, pageIdx);
        if (b) {
            gc.drawLine(0, 0, width, 0);
            gc.drawLine(0, 0, 0, height);
            gc.drawLine(0, height - 1, width, height - 1);
            gc.drawLine(width - 1, 0, width - 1, height - 1);
        }
    }

    public int getPageTotalSize() {
        return this.pageTotalSize;
    }

    public void setVaccinationPlanHeader(VaccinationPlanHeaderDefinition vphd) {
        this._vphd = vphd;
    }

    public void setVaccinationEntries(List<Vaccination> vaccinations) {
        this._vaccinations = vaccinations;
    }

    public void setPatientBirthdate(TimeTool birthDate) {
        this._patientBirthDate = birthDate;
    }

    private int determineMinWidth(GC gc, boolean wrapText) {
        int minWidth = 0;
        this.lengthOfBasisimpfungen = this._vphd.base.size() * this.distanceBetweenDiseases;
        this.lengthOfDoctor = this.determineMaxAdministratorLabelLength(gc, wrapText) + 15;
        this.lengthOfLotNr = this.determineMaxLotNr(gc, wrapText) + 15;
        this.lengthOfDateString = gc.textExtent((String)"09.07.2014").x + 15;
        this.leftStart = this._vphd.extended.size() * this.distanceBetweenDiseases + 2;
        int lNames = this.determineMaxVaccNameLength(gc);
        gc.setFont(this.headerFont);
        String extendedVaccination = "sowie erg\u00e4nzende Impfungen";
        Point pt = gc.textExtent(extendedVaccination);
        if (pt.x > lNames) {
            lNames = pt.x;
        }
        gc.setFont(this.defaultFont);
        if (this.showSide) {
            this.lengthOfSide = gc.textExtent((String)"rechts").x + 15;
            minWidth = this.lengthOfSide + this.lengthOfBasisimpfungen + this.lengthOfDoctor + this.lengthOfLotNr + this.lengthOfDateString + this.leftStart + lNames;
        } else {
            minWidth = this.lengthOfBasisimpfungen + this.lengthOfDoctor + this.lengthOfLotNr + this.lengthOfDateString + this.leftStart + lNames;
        }
        return minWidth;
    }

    private void drawHeader(GC gc, Display display, int width, int pageIdx) {
        String diseaseLabel;
        boolean alternator = true;
        this.diseaseBoundaries.clear();
        if (HEADER_HEIGHT == -1) {
            HEADER_HEIGHT = this.determineMaxDiseaseStringExtension((GC)gc).x + 10;
        }
        int ehHeight = this.calcEhHeight(pageIdx);
        gc.setFont(this.headerFont);
        String baseVaccination = "Basisimpfungen";
        String extendedVaccination = "sowie erg\u00e4nzende Impfungen";
        Point pt = gc.textExtent(baseVaccination);
        gc.drawText(baseVaccination, 10, 10, true);
        gc.drawText(extendedVaccination, 10, pt.y + 10, true);
        gc.setFont(this.defaultFont);
        gc.drawText(this._vphd.name, 10, pt.y + 35, true);
        gc.setFont(this.boldFont);
        gc.drawText(VACCINE, 10, HEADER_HEIGHT - this.fontHeightDefaultFont * 2 - 2);
        gc.setFont(this.defaultFont);
        gc.setForeground(this.COLOR_DARKGREY);
        gc.drawText(TRADENAME, 10, HEADER_HEIGHT - this.fontHeightDefaultFont * 1 - 2);
        gc.setForeground(this.COLOR_BLACK);
        gc.setFont(this.boldFont);
        this.locationOfAgeBorder = (int)((double)(width - this.lengthOfBasisimpfungen - this.leftStart) - 35.0 * this.getScaleFactor());
        gc.drawText(AGE, this.locationOfAgeBorder + 2, HEADER_HEIGHT - this.fontHeightDefaultFont - 2);
        if (this.showSide) {
            this.locationOfSideBorder = this.locationOfAgeBorder - (this.lengthOfSide + 10);
            gc.drawText(SIDE, this.locationOfSideBorder + 2, HEADER_HEIGHT - this.fontHeightDefaultFont - 2);
            this.locationOfDateBorder = this.locationOfSideBorder - (this.lengthOfDateString + 10);
            gc.drawText(DATE, this.locationOfDateBorder + 2, HEADER_HEIGHT - this.fontHeightDefaultFont - 2);
        } else {
            this.locationOfDateBorder = this.locationOfAgeBorder - (this.lengthOfDateString + 10);
            gc.drawText(DATE, this.locationOfDateBorder + 2, HEADER_HEIGHT - this.fontHeightDefaultFont - 2);
        }
        this.locationOfDocBorder = this.locationOfDateBorder - (this.lengthOfDoctor + 10);
        gc.drawText(ADMINISTRATOR, this.locationOfDocBorder + 2, HEADER_HEIGHT - this.fontHeightDefaultFont - 2);
        this.locationOfLotNrBorder = this.locationOfDocBorder - (this.lengthOfLotNr + 10);
        gc.drawText(LOT_NO, this.locationOfLotNrBorder + 2, HEADER_HEIGHT - this.fontHeightDefaultFont - 2);
        gc.setFont(this.defaultFont);
        int spaceCounter = -this.distanceBetweenDiseases;
        for (String val : this._vphd.extended) {
            if (alternator) {
                gc.setBackground(this.COLOR_BOTTOM);
            } else {
                gc.setBackground(this.COLOR_WHITE);
            }
            gc.fillRectangle(width + spaceCounter, 0, this.distanceBetweenDiseases, ehHeight);
            gc.drawLine(width + spaceCounter, 0, width + spaceCounter, ehHeight);
            this.diseaseBoundaries.add(new DiseaseBoundary(width + spaceCounter, gc.getBackground(), val));
            diseaseLabel = DiseaseDefinitionModel.getLabelForAtcCode((String)val);
            GraphicsUtil.drawVerticalText(diseaseLabel, display, width + spaceCounter + 3, HEADER_HEIGHT - 3, gc, 1152);
            spaceCounter -= this.distanceBetweenDiseases;
            boolean bl = alternator = !alternator;
        }
        gc.setBackground(this.COLOR_WHITE);
        gc.setBackground(Display.getCurrent().getSystemColor(2));
        this.separatorBoundary = width - this.leftStart;
        gc.fillRectangle(this.separatorBoundary, 0, 2, ehHeight);
        spaceCounter = -this.distanceBetweenDiseases;
        this.locationOfFirstDisease = width - this.lengthOfBasisimpfungen - this.leftStart;
        for (String baseDisease : this._vphd.base) {
            if (alternator) {
                gc.setBackground(this.COLOR_BOTTOM);
            } else {
                gc.setBackground(this.COLOR_WHITE);
            }
            gc.fillRectangle(width + spaceCounter - this.leftStart, 0, this.distanceBetweenDiseases, ehHeight);
            gc.drawLine(width + spaceCounter - this.leftStart, 0, width + spaceCounter - this.leftStart, ehHeight);
            this.diseaseBoundaries.add(new DiseaseBoundary(width + spaceCounter - this.leftStart, gc.getBackground(), baseDisease));
            diseaseLabel = DiseaseDefinitionModel.getLabelForAtcCode((String)baseDisease);
            GraphicsUtil.drawVerticalText(diseaseLabel, display, width + spaceCounter + 3 - this.leftStart, HEADER_HEIGHT - 3, gc, 1152);
            spaceCounter -= this.distanceBetweenDiseases;
            boolean bl = alternator = !alternator;
        }
        gc.setBackground(this.COLOR_WHITE);
        gc.drawLine(0, HEADER_HEIGHT - 1, width, HEADER_HEIGHT - 1);
        if (ehHeight != HEADER_HEIGHT) {
            gc.drawLine(this.locationOfAgeBorder, HEADER_HEIGHT, this.locationOfAgeBorder, ehHeight);
            if (this.showSide) {
                gc.drawLine(this.locationOfSideBorder, HEADER_HEIGHT, this.locationOfSideBorder, ehHeight);
            }
            gc.drawLine(this.locationOfDateBorder, HEADER_HEIGHT, this.locationOfDateBorder, ehHeight);
            gc.drawLine(this.locationOfDocBorder, HEADER_HEIGHT, this.locationOfDocBorder, ehHeight);
            gc.drawLine(this.locationOfLotNrBorder, HEADER_HEIGHT, this.locationOfLotNrBorder, ehHeight);
        }
    }

    private int calcEhHeight(int pageIdx) {
        int diff;
        if (pageIdx > 0 && (diff = this._vaccinations.size() - this.pageElementCount * pageIdx) <= this.pageElementCount) {
            return HEADER_HEIGHT + diff * this.entryHeight;
        }
        return this.eh(pageIdx);
    }

    private Point determineMaxDiseaseStringExtension(GC gc) {
        Point maxExtent = new Point(0, 0);
        ArrayList<String> fullList = new ArrayList<String>();
        fullList.addAll(this._vphd.base);
        fullList.addAll(this._vphd.extended);
        for (String valS : fullList) {
            String diseaseLabel = DiseaseDefinitionModel.getLabelForAtcCode((String)valS);
            maxExtent = this.determineMax(diseaseLabel, maxExtent, gc);
        }
        return maxExtent;
    }

    private int determineMaxAdministratorLabelLength(GC gc, boolean wrapText) {
        Point maxExtended = new Point(0, 0);
        maxExtended = this.determineMax(ADMINISTRATOR, maxExtended, gc);
        for (Vaccination vac : this._vaccinations) {
            String doc = vac.getAdministratorLabel();
            maxExtended = this.determineMax(doc, maxExtended, gc);
        }
        if (wrapText && maxExtended.x > this.maxLengthDoctor) {
            maxExtended.x = this.maxLengthDoctor;
        }
        return maxExtended.x;
    }

    private int determineMaxLotNr(GC gc, boolean wrapText) {
        Point maxExtended = new Point(0, 0);
        maxExtended = this.determineMax(LOT_NO, maxExtended, gc);
        for (Vaccination vac : this._vaccinations) {
            String lotNr = vac.getLotNo();
            maxExtended = this.determineMax(lotNr, maxExtended, gc);
        }
        if (wrapText && maxExtended.x > this.maxLengthLotNr) {
            maxExtended.x = this.maxLengthLotNr;
        }
        return maxExtended.x;
    }

    private int determineMaxVaccNameLength(GC gc) {
        Point maxExtended = new Point(0, 0);
        maxExtended = this.determineMax(VACCINE, maxExtended, gc);
        for (Vaccination vac : this._vaccinations) {
            String sbn = vac.getBusinessName();
            maxExtended = this.determineMax(sbn, maxExtended, gc);
        }
        return maxExtended.x;
    }

    private Point determineMax(String text, Point maxExtended, GC gc) {
        Point val = gc.textExtent(text);
        if (val.x > maxExtended.x) {
            maxExtended.x = val.x;
        }
        if (val.y > maxExtended.y) {
            maxExtended.y = val.y;
        }
        return maxExtended;
    }

    private int eh(int pageIndex) {
        return HEADER_HEIGHT + (pageIndex == -1 || this._vaccinations.size() < this.pageElementCount ? this._vaccinations.size() : this.pageElementCount) * this.entryHeight;
    }

    private void drawEntries(GC gc, Display display, int width, boolean b, int pageIdx) {
        int lastHeightStart = 0;
        this.naviVacMap.clear();
        this.naviVacMap.put(0, null);
        int i = 0;
        int size = this._vaccinations.size();
        if (pageIdx > -1) {
            i = this.pageElementCount * pageIdx;
            size = this.pageElementCount * (pageIdx + 1);
        }
        int a = 0;
        while (i < size) {
            int heightStart;
            if (this._vaccinations.size() <= i) break;
            Vaccination vacc = this._vaccinations.get(i);
            gc.setBackground(this.COLOR_WHITE);
            gc.setForeground(this.COLOR_BLACK);
            lastHeightStart = heightStart = HEADER_HEIGHT + (this.entryHeight * a + 1);
            if (vacc.equals((Object)this.selectedVacc)) {
                this.highlightSelectedEntry(gc, heightStart, width, pageIdx);
            }
            gc.setFont(this.boldFont);
            gc.drawText(this.wrapTextByWidth(gc, vacc.getShortBusinessName(), this.maxLengthBasisImpf, false), 7, heightStart);
            gc.setFont(this.defaultFont);
            String lotNr = vacc.getLotNo();
            gc.drawText(this.wrapTextByWidth(gc, lotNr, this.maxLengthLotNr, true), this.locationOfLotNrBorder + 7, heightStart);
            String docName = vacc.getAdministratorLabel();
            if (vacc.isSupplement()) {
                gc.setForeground(this.COLOR_GREEN);
            }
            gc.drawText(this.wrapTextByWidth(gc, docName, this.maxLengthDoctor, false), this.locationOfDocBorder + 7, heightStart);
            gc.setForeground(this.COLOR_BLACK);
            this._administrationDate = vacc.getDateOfAdministration();
            gc.drawText(vacc.getDateOfAdministrationLabel(), this.locationOfDateBorder + 7, heightStart);
            if (this.showSide) {
                String side = vacc.getSide();
                gc.drawText(side, this.locationOfSideBorder + 7, heightStart);
            }
            gc.drawText(this.getAgeLabel(this._administrationDate), this.locationOfAgeBorder + 7, heightStart);
            this.drawDiseaseMarkers(gc, heightStart, vacc, gc.getBackground());
            gc.drawLine(0, heightStart + this.entryHeight - 1, width, heightStart + this.entryHeight - 1);
            gc.setBackground(this.COLOR_WHITE);
            this.naviVacMap.put(heightStart, vacc);
            ++a;
            ++i;
        }
        this.naviVacMap.put(lastHeightStart + this.entryHeight - 1, null);
    }

    private String wrapTextByWidth(GC gc, String text, int maxTextWidth, boolean wrapWithoutSeperator) {
        if (text != null) {
            int maxChars;
            int stringWidth = gc.stringExtent((String)text).x;
            int textLength = text.length();
            if (stringWidth > maxTextWidth && (maxChars = maxTextWidth * textLength / stringWidth) < textLength) {
                int idxLastSpace = text.substring(0, maxChars).lastIndexOf(" ") + 1;
                if (idxLastSpace > 1 && idxLastSpace < textLength) {
                    return text.replaceFirst("(.{" + idxLastSpace + "})", "$1\n");
                }
                return text.replaceFirst("(.{" + maxChars + "})", "$1" + (wrapWithoutSeperator ? "" : "-") + "\n");
            }
        }
        return text;
    }

    private void highlightSelectedEntry(GC gc, int heightStart, int width, int pageIdx) {
        gc.setForeground(this.COLOR_CREME);
        gc.setBackground(UiDesk.getColorFromRGB((String)"FEFFCB"));
        gc.drawRectangle(0, heightStart, width, this.entryHeight - 1);
        gc.fillGradientRectangle(0, heightStart, width, this.entryHeight - 1, true);
        gc.setForeground(this.COLOR_BLACK);
        int ehHeight = this.calcEhHeight(pageIdx);
        int yStart = HEADER_HEIGHT;
        if (ehHeight != HEADER_HEIGHT) {
            gc.drawLine(this.locationOfLotNrBorder, yStart, this.locationOfLotNrBorder, ehHeight);
            gc.drawLine(this.locationOfDocBorder, yStart, this.locationOfDocBorder, ehHeight);
            gc.drawLine(this.locationOfAgeBorder, yStart, this.locationOfAgeBorder, ehHeight);
            if (this.showSide) {
                gc.drawLine(this.locationOfSideBorder, yStart, this.locationOfSideBorder, ehHeight);
            }
            gc.drawLine(this.locationOfDateBorder, yStart, this.locationOfDateBorder, ehHeight);
            gc.drawLine(this.locationOfFirstDisease, yStart, this.locationOfFirstDisease, ehHeight);
            for (DiseaseBoundary db : this.diseaseBoundaries) {
                gc.drawLine(db.leftTrim, 0, db.leftTrim, ehHeight);
            }
            gc.setBackground(Display.getCurrent().getSystemColor(2));
            gc.fillRectangle(this.separatorBoundary, 0, 2, ehHeight);
            gc.setBackground(this.COLOR_CREME);
        }
    }

    private String getAgeLabel(TimeTool adminDate) {
        int daysTo = this._patientBirthDate.daysTo(adminDate);
        int months = daysTo / 30;
        if (months >= 48) {
            return daysTo / 365 + "J";
        }
        return months + "m";
    }

    private void drawDiseaseMarkers(GC gc, int heightStart, Vaccination vacc, Color background) {
        String atcCode = vacc.getAtcCode();
        HashSet immunisation = new HashSet(ArticleToImmunisationModel.getImmunisationForAtcCode((String)atcCode));
        if (immunisation == null || immunisation.isEmpty()) {
            immunisation = new HashSet(vacc.getVaccAgainstList());
        }
        for (DiseaseBoundary db : this.diseaseBoundaries) {
            if (!immunisation.contains(db.atcCode)) continue;
            if (!background.equals((Object)this.COLOR_CREME) && !background.equals((Object)this.COLOR_LIGHTGREY)) {
                gc.setBackground(db.backgroundColor);
            }
            gc.drawText("X", db.leftTrim + 5, heightStart);
            gc.setBackground(background);
        }
    }

    public void setSelection(Vaccination vaccination, Control control) {
        this.selectedVacc = vaccination;
        if (control != null) {
            control.redraw();
        }
    }

    public Vaccination getSelectedVaccination() {
        return this.selectedVacc;
    }

    public void restorePrePrintSettting() {
        this.showSide = ConfigServiceHolder.getUser((String)"plugins/impfplan/showside", (boolean)false);
    }

    public int getWidth() {
        return 800;
    }

    public int getHeight() {
        if (this._vaccinations == null) {
            return 64;
        }
        return this.eh(-1);
    }

    public boolean isTitleArea() {
        return this.mouseY > 1 && this.mouseX > 1 && this.mouseY < 90 && this.mouseX < 350;
    }

    private class DiseaseBoundary {
        int leftTrim;
        String atcCode;
        Color backgroundColor;

        public DiseaseBoundary(int leftTrim, Color background, String atcCode) {
            this.leftTrim = leftTrim;
            this.atcCode = atcCode;
            this.backgroundColor = background;
        }
    }
}

