/*
 * Decompiled with CFR 0.152.
 */
package at.medevit.elexis.impfplan.ui.handlers.progress;

import at.medevit.elexis.impfplan.ui.handlers.ImportLegacyVaccinationsHandler;
import ch.elexis.data.Patient;
import ch.elexis.data.Query;
import ch.elexis.impfplan.model.Vaccination;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImportLegacyVaccinationsProgress
implements IRunnableWithProgress {
    private static Logger log = LoggerFactory.getLogger(ImportLegacyVaccinationsHandler.class);
    private String administrator;
    private Map<Vaccination, ErrorCode> errorMap;
    private List<Vaccination> alreadyImported;

    public ImportLegacyVaccinationsProgress(String administrator) {
        this.administrator = administrator;
    }

    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        log.debug("Start vaccination import");
        monitor.beginTask("Importiere Impfungen", 2);
        monitor.subTask("Lese zu importierende Impfungen ein...");
        Query qbe = new Query(Vaccination.class);
        List list = qbe.execute();
        this.errorMap = new HashMap<Vaccination, ErrorCode>();
        this.alreadyImported = new ArrayList<Vaccination>();
        monitor.worked(1);
        monitor.subTask("Importiere...");
        for (Vaccination vacc : list) {
            String patId = vacc.getPatientId();
            if (!Patient.load((String)patId).exists()) {
                if (vacc.getId().equals("VERSION")) continue;
                log.warn(String.valueOf((Object)ErrorCode.PATIENT_NOTFOUND) + " [" + patId + "], Vacc[" + vacc.getId() + "], " + vacc.getLabel());
                this.errorMap.put(vacc, ErrorCode.PATIENT_NOTFOUND);
                continue;
            }
            if (vacc.getVaccinationType() == null) {
                log.warn(String.valueOf((Object)ErrorCode.VACC_TYPE_NOT_SET) + " - VaccinationTyp ref. missing, Vacc[" + vacc.getId() + "], " + vacc.getLabel());
                this.errorMap.put(vacc, ErrorCode.VACC_TYPE_NOT_SET);
                continue;
            }
            String vaccAgainst = vacc.getVaccinationType().getVaccAgainst();
            if (vaccAgainst == null || vaccAgainst.isEmpty()) {
                log.warn(String.valueOf((Object)ErrorCode.VACC_AGAINST_NOT_SET) + ", Vacc[" + vacc.getId() + "], " + vacc.getLabel());
                this.errorMap.put(vacc, ErrorCode.VACC_AGAINST_NOT_SET);
                continue;
            }
            if (this.alreadyImported(patId, vacc)) {
                log.debug("Already imported: " + vacc.getId() + ", " + vacc.getLabel());
                this.alreadyImported.add(vacc);
                continue;
            }
            String doa = vacc.getRawDateString();
            String vaccName = vacc.getVaccinationType().getLabel();
            at.medevit.elexis.impfplan.model.po.Vaccination v = new at.medevit.elexis.impfplan.model.po.Vaccination(patId, null, vaccName, null, null, doa, null, this.administrator);
            v.setVaccAgainst(vaccAgainst);
        }
        monitor.worked(1);
        monitor.done();
        log.debug("Vaccination import completed");
    }

    public boolean isAbnormalImport() {
        return !this.errorMap.isEmpty();
    }

    public Map<Vaccination, ErrorCode> getErrorMap() {
        return this.errorMap;
    }

    public List<Vaccination> getAlreadyImportedVaccinations() {
        return this.alreadyImported;
    }

    private boolean alreadyImported(String patId, Vaccination vacc) {
        Query qbe = new Query(at.medevit.elexis.impfplan.model.po.Vaccination.class);
        qbe.add("Patient_ID", "=", patId);
        qbe.add("BusinessName", "=", vacc.getVaccinationType().getLabel());
        List list = qbe.execute();
        return list != null && !list.isEmpty();
    }

    public static enum ErrorCode {
        PATIENT_NOTFOUND("Patient nicht gefunden"),
        VACC_AGAINST_NOT_SET("Impfung gegen Krankheit(en) nicht gesetzt"),
        VACC_TYPE_NOT_SET("Keiner Impfung zuzuordnen");

        private final String text;

        private ErrorCode(String text) {
            this.text = text;
        }

        public String toString() {
            return this.text;
        }
    }
}

