/*
 * Decompiled with CFR 0.152.
 */
package at.medevit.elexis.impfplan.ui.billing;

import ch.elexis.core.data.service.CodeElementServiceHolder;
import ch.elexis.core.model.IArticle;
import ch.elexis.core.model.IBillable;
import ch.elexis.core.model.IBilled;
import ch.elexis.core.model.IEncounter;
import ch.elexis.core.model.IPatient;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.model.ch.BillingLaw;
import ch.elexis.core.services.ICodeElementService;
import ch.elexis.core.services.ICodeElementServiceContribution;
import ch.elexis.core.services.holder.BillingServiceHolder;
import ch.elexis.core.services.holder.ConfigServiceHolder;
import ch.elexis.core.services.holder.ContextServiceHolder;
import ch.elexis.core.text.model.Samdas;
import ch.elexis.core.ui.dialogs.SelectOrCreateOpenKonsDialog;
import ch.elexis.core.ui.locks.AcquireLockBlockingUi;
import ch.elexis.core.ui.locks.ILockHandler;
import ch.elexis.core.ui.services.EncounterServiceHolder;
import java.time.LocalDate;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import org.eclipse.swt.widgets.Display;

public class AddVaccinationToKons {
    private static final String TARMED_5MIN_TARIF = "00.0010";
    private static Object selectKonsLock = new Object();
    private IEncounter actEncounter;
    private IPatient patient;
    private IArticle art;

    public AddVaccinationToKons(IPatient patient, IArticle art, String ean) {
        this.patient = patient;
        this.art = art;
        if (art == null) {
            CodeElementServiceHolder.get().getContribution(ICodeElementService.CodeElementTyp.ARTICLE, "Artikelstamm").ifPresent(contribution -> {
                Optional loaded = contribution.loadFromCode(ean);
                if (loaded.isPresent()) {
                    this.art = (IArticle)loaded.get();
                }
            });
        }
    }

    public IEncounter findOrCreateKons() {
        this.initKonsultation();
        if (this.actEncounter == null || !EncounterServiceHolder.get().isEditable(this.actEncounter)) {
            return null;
        }
        AcquireLockBlockingUi.aquireAndRun((Identifiable)this.actEncounter, (ILockHandler)new ILockHandler(){

            public void lockFailed() {
            }

            public void lockAcquired() {
                if (AddVaccinationToKons.this.actEncounter != null) {
                    BillingServiceHolder.get().bill((IBillable)AddVaccinationToKons.this.art, AddVaccinationToKons.this.actEncounter, 1.0);
                    Samdas samdas = new Samdas(AddVaccinationToKons.this.actEncounter.getVersionedEntry().getHead());
                    Samdas.Record rec = samdas.getRecord();
                    Object recText = rec.getText();
                    recText = (String)recText + "\nImpfung - " + AddVaccinationToKons.this.art.getName();
                    rec.setText((String)recText);
                    EncounterServiceHolder.get().updateVersionedEntry(AddVaccinationToKons.this.actEncounter, samdas);
                    if (ConfigServiceHolder.getUser((String)"plugins/impfplan/autobill", (boolean)true)) {
                        boolean addedCons = true;
                        List leistungen = AddVaccinationToKons.this.actEncounter.getBilled();
                        for (IBilled verrechnet : leistungen) {
                            IBillable verrechenbar = verrechnet.getBillable();
                            if (verrechenbar == null || !verrechenbar.getCodeSystemName().equals("Tarmed") || !verrechenbar.getCode().equals(AddVaccinationToKons.TARMED_5MIN_TARIF)) continue;
                            addedCons = false;
                            break;
                        }
                        IBillable consVerrechenbar = AddVaccinationToKons.this.getKonsVerrechenbar(AddVaccinationToKons.this.actEncounter);
                        if (addedCons && consVerrechenbar != null) {
                            BillingServiceHolder.get().bill(consVerrechenbar, AddVaccinationToKons.this.actEncounter, 1.0);
                        }
                    }
                    ContextServiceHolder.get().postEvent("info/elexis/model/update", (Object)AddVaccinationToKons.this.actEncounter);
                }
            }
        });
        return this.actEncounter;
    }

    private IBillable getKonsVerrechenbar(IEncounter encounter) {
        LocalDate encounterDate = encounter.getDate();
        if (encounter.getCoverage() != null) {
            BillingLaw law = encounter.getCoverage().getBillingSystem().getLaw();
            Optional tarmedContribution = CodeElementServiceHolder.get().getContribution(ICodeElementService.CodeElementTyp.SERVICE, "Tarmed");
            if (tarmedContribution.isPresent()) {
                HashMap<ICodeElementService.ContextKeys, Object> context = new HashMap<ICodeElementService.ContextKeys, Object>();
                context.put(ICodeElementService.ContextKeys.DATE, encounterDate);
                context.put(ICodeElementService.ContextKeys.LAW, law.name());
                Optional loaded = ((ICodeElementServiceContribution)tarmedContribution.get()).loadFromCode(TARMED_5MIN_TARIF, context);
                if (loaded.isPresent()) {
                    return (IBillable)loaded.get();
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initKonsultation() {
        Object object = selectKonsLock;
        synchronized (object) {
            this.actEncounter = EncounterServiceHolder.get().getLatestEncounter(this.patient, false).orElse(null);
            if (this.actEncounter == null || !EncounterServiceHolder.get().isEditable(this.actEncounter)) {
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        SelectOrCreateOpenKonsDialog dialog = new SelectOrCreateOpenKonsDialog(AddVaccinationToKons.this.patient, "Konsultation f\u00fcr die automatische Verrechnung ausw\u00e4hlen.");
                        if (dialog.open() == 0) {
                            AddVaccinationToKons.this.actEncounter = dialog.getKonsultation();
                        }
                    }
                });
            }
        }
    }
}

