/*
 * Decompiled with CFR 0.152.
 */
package at.medevit.elexis.impfplan.ui.handlers;

import at.medevit.elexis.impfplan.ui.billing.AddVaccinationToKons;
import ch.elexis.core.data.service.ContextServiceHolder;
import ch.elexis.core.model.IArticle;
import ch.elexis.core.model.IEncounter;
import ch.elexis.core.ui.UiDesk;
import ch.elexis.core.ui.actions.CodeSelectorHandler;
import ch.elexis.core.ui.actions.ICodeSelectorTarget;
import ch.elexis.core.ui.util.GenericObjectDropTarget;
import ch.elexis.core.ui.util.SWTHelper;
import ch.elexis.core.ui.views.codesystems.LeistungenView;
import ch.rgw.tools.StringTool;
import ch.rgw.tools.TimeTool;
import java.util.Date;
import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApplyVaccinationHandler
extends AbstractHandler {
    private static Logger logger = LoggerFactory.getLogger(ApplyVaccinationHandler.class);
    private static boolean inProgress = false;
    private GenericObjectDropTarget dropTarget;
    private static TimeTool doa;
    private static IEncounter actEncounter;
    private LeistungenView leistungenView;

    public Object execute(ExecutionEvent event) throws ExecutionException {
        if (this.dropTarget == null) {
            this.dropTarget = new GenericObjectDropTarget("Impfplan", (Control)UiDesk.getTopShell(), (GenericObjectDropTarget.IReceiver)new DropReceiver());
        }
        try {
            if (StringTool.isNothing((Object)"ch.elexis.LeistungenView")) {
                SWTHelper.alert((String)"Fehler", (String)"LeistungenView.ID");
            }
            this.leistungenView = (LeistungenView)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("ch.elexis.LeistungenView");
            CodeSelectorHandler csHandler = CodeSelectorHandler.getInstance();
            csHandler.setCodeSelectorTarget((ICodeSelectorTarget)this.dropTarget);
            csHandler.getCodeSelectorTarget().registered(false);
            CTabItem[] cTabItemArray = this.leistungenView.ctab.getItems();
            int n = cTabItemArray.length;
            int n2 = 0;
            while (n2 < n) {
                CTabItem cti = cTabItemArray[n2];
                if (cti.getText().equalsIgnoreCase("Artikelstamm")) {
                    this.leistungenView.setSelected(cti);
                    this.leistungenView.setFocus();
                    this.leistungenView.ctab.setSelection(cti);
                }
                ++n2;
            }
        }
        catch (Exception e) {
            logger.error("Error trying to open LeistungenView", (Throwable)e);
        }
        return null;
    }

    public static Date getKonsDate() {
        doa = new TimeTool(actEncounter.getDate());
        return doa.getTime();
    }

    public static boolean inProgress() {
        return inProgress;
    }

    private final class DropReceiver
    implements GenericObjectDropTarget.IReceiver {
        private DropReceiver() {
        }

        public void dropped(List<Object> list, DropTargetEvent ev) {
            for (Object object : list) {
                if (!(object instanceof IArticle)) continue;
                IArticle artikel = (IArticle)object;
                if (artikel.isVaccination()) {
                    AddVaccinationToKons addVacToKons = new AddVaccinationToKons(ContextServiceHolder.get().getActivePatient().orElse(null), artikel, artikel.getGtin());
                    actEncounter = addVacToKons.findOrCreateKons();
                    if (actEncounter == null) {
                        logger.warn("Could not insert vaccination as no consultation was found for this patient");
                        MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"Nicht erstellbar", (String)"Konnte Impfung nich eintragen, da keine Konsultation vorhanden ist.");
                    }
                    inProgress = true;
                    continue;
                }
                MessageDialog.openWarning((Shell)Display.getDefault().getActiveShell(), (String)"Nicht erstellbar", (String)"Der gew\u00e4hlte Artikel ist kein Impfstoff.");
            }
        }

        public boolean accept(List<Object> list) {
            if (ContextServiceHolder.get().getActivePatient().isPresent()) {
                for (Object object : list) {
                    if (!(object instanceof IArticle)) continue;
                    return true;
                }
            }
            return false;
        }
    }
}

