/*
 * Decompiled with CFR 0.152.
 */
package at.medevit.elexis.hin.sign.ui.handler;

import at.medevit.elexis.emediplan.core.EMediplanService;
import at.medevit.elexis.emediplan.core.EMediplanUtil;
import at.medevit.elexis.hin.sign.core.IHinSignService;
import at.medevit.elexis.hin.sign.ui.outputter.EPrescriptionOutputter;
import ch.elexis.core.data.interfaces.IOutputter;
import ch.elexis.core.data.util.NoPoUtil;
import ch.elexis.core.exceptions.ElexisException;
import ch.elexis.core.model.IDocument;
import ch.elexis.core.model.IDocumentLetter;
import ch.elexis.core.model.IRecipe;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.services.IDocumentStore;
import ch.elexis.core.services.holder.ContextServiceHolder;
import ch.elexis.core.services.holder.CoreModelServiceHolder;
import ch.elexis.core.status.ObjectStatus;
import ch.elexis.core.utils.OsgiServiceUtil;
import ch.elexis.data.OutputLog;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.time.format.DateTimeFormatter;
import java.util.Optional;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.slf4j.LoggerFactory;

public class CreateAndOpenEPrescription
extends AbstractHandler
implements IHandler {
    private EMediplanService eMediplanService;
    private IHinSignService hinSignService;
    private IDocumentStore letterDocumentStore;

    public Object execute(ExecutionEvent event) throws ExecutionException {
        Optional selectedRecipe = ContextServiceHolder.get().getTyped(IRecipe.class);
        if (selectedRecipe.isPresent() && this.getEMediplanService() != null && this.getHinSignService() != null) {
            Optional<String> existingUrl = this.getHinSignService().getPrescriptionUrl((IRecipe)selectedRecipe.get());
            if (existingUrl.isEmpty()) {
                try {
                    ObjectStatus status;
                    ByteArrayOutputStream output = new ByteArrayOutputStream();
                    this.getEMediplanService().exportEMediplanJson(ContextServiceHolder.getActiveMandatorOrThrow(), ((IRecipe)selectedRecipe.get()).getPatient(), ((IRecipe)selectedRecipe.get()).getPrescriptions(), (OutputStream)output);
                    String chmedJson = IOUtils.toString((InputStream)new ByteArrayInputStream(output.toByteArray()), (String)"UTF-8");
                    String chmed = EMediplanUtil.getEncodedJson((String)chmedJson);
                    if (StringUtils.isNotBlank((CharSequence)chmed) && (status = this.getHinSignService().createPrescription(chmed)).isOK() && status.get() instanceof String) {
                        String url = (String)status.get();
                        existingUrl = Optional.of(url);
                        this.getHinSignService().setPrescriptionUrl((IRecipe)selectedRecipe.get(), url);
                    }
                }
                catch (IOException e) {
                    LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Error creating eprescription", (Throwable)e);
                    return null;
                }
            }
            ByteArrayOutputStream pdfOutput = new ByteArrayOutputStream();
            ObjectStatus pdfResult = this.getHinSignService().exportPrescriptionPdf((IRecipe)selectedRecipe.get(), (OutputStream)pdfOutput);
            if (pdfResult.isOK()) {
                try {
                    this.savePrescriptionLetter((IRecipe)selectedRecipe.get(), "pdf", new ByteArrayInputStream(pdfOutput.toByteArray()));
                    new OutputLog(NoPoUtil.loadAsPersistentObject((Identifiable)((Identifiable)selectedRecipe.get())), (IOutputter)new EPrescriptionOutputter());
                    Program.launch((String)CreateAndOpenEPrescription.writeTempPdf(pdfOutput));
                }
                catch (ElexisException | IOException e) {
                    MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"Fehler", (String)"Das Rezept konnte nicht angezeigt werden.");
                }
            }
        }
        return null;
    }

    private void savePrescriptionLetter(IRecipe recipe, String contentType, InputStream content) throws ElexisException {
        IDocument letter = this.getLetterDocumentStore().createDocument(recipe.getPatient().getId(), "HIN eRezept " + DateTimeFormatter.ofPattern("dd.MM.yyyy HH:mm").format(recipe.getDate()), "Rezept");
        letter.setExtension(contentType);
        this.getLetterDocumentStore().saveDocument(letter, content);
        recipe.setDocument((IDocumentLetter)letter);
        CoreModelServiceHolder.get().save((Identifiable)recipe);
    }

    public static String writeTempPdf(ByteArrayOutputStream pdf) throws FileNotFoundException, IOException {
        File pdfFile = File.createTempFile("ePrescription_" + System.currentTimeMillis(), ".pdf");
        Throwable throwable = null;
        Object var3_4 = null;
        try (FileOutputStream fos = new FileOutputStream(pdfFile);){
            fos.write(pdf.toByteArray());
            fos.flush();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return pdfFile.getAbsolutePath();
    }

    private EMediplanService getEMediplanService() {
        if (this.eMediplanService == null) {
            this.eMediplanService = OsgiServiceUtil.getService(EMediplanService.class).orElse(null);
        }
        return this.eMediplanService;
    }

    private IHinSignService getHinSignService() {
        if (this.hinSignService == null) {
            this.hinSignService = OsgiServiceUtil.getService(IHinSignService.class).orElse(null);
        }
        return this.hinSignService;
    }

    private IDocumentStore getLetterDocumentStore() {
        if (this.letterDocumentStore == null) {
            this.letterDocumentStore = OsgiServiceUtil.getService(IDocumentStore.class, (String)"(storeid=ch.elexis.data.store.brief)").orElse(null);
        }
        return this.letterDocumentStore;
    }
}

