/*
 * Decompiled with CFR 0.152.
 */
package at.medevit.elexis.hin.sign.core.internal;

import at.medevit.elexis.hin.sign.core.IHinSignService;
import ch.elexis.core.utils.CoreUtil;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.BufferedReader;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermission;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.Platform;
import org.osgi.framework.Bundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CliProcess {
    private static Logger logger = LoggerFactory.getLogger(CliProcess.class);
    private List<String> command = new ArrayList<String>();
    private List<String> output;
    private List<String> errorOutput;
    private IHinSignService.Mode mode;

    private CliProcess() {
    }

    public boolean execute() {
        try {
            logger.info("Executing cli command [" + String.valueOf(this.command) + "]");
            ProcessBuilder processBuilder = new ProcessBuilder(this.command);
            processBuilder.environment().put("ENABLE_EPRESCRIPTION", "true");
            Process process = processBuilder.start();
            if (process.waitFor(30L, TimeUnit.SECONDS)) {
                this.output = this.readOutput(process.getInputStream());
                this.errorOutput = this.readOutput(process.getErrorStream());
                return process.exitValue() == 0;
            }
            logger.error("Error executing print command [" + String.valueOf(this.command) + "] process terminated.");
            process.destroy();
            return false;
        }
        catch (IOException | InterruptedException e) {
            logger.error("Error executing print command", (Throwable)e);
            return false;
        }
    }

    public List<String> getOutput() {
        return this.output;
    }

    public List<String> getErrorOutput() {
        return this.errorOutput;
    }

    public Map<?, ?> getOutputAsMap() {
        if (this.output != null && !this.output.isEmpty() && this.output.get(0).startsWith("{")) {
            Gson gson = new GsonBuilder().create();
            return (Map)gson.fromJson(this.output.stream().collect(Collectors.joining("\n")), Map.class);
        }
        return null;
    }

    private List<String> readOutput(InputStream inputStream) {
        ArrayList<String> ret = new ArrayList<String>();
        try {
            String line;
            BufferedReader in = new BufferedReader(new InputStreamReader(inputStream));
            while ((line = in.readLine()) != null) {
                ret.add(line);
            }
        }
        catch (IOException e) {
            logger.error("Error reading process output", (Throwable)e);
        }
        return ret;
    }

    private String getApiParamter() {
        return this.mode == IHinSignService.Mode.TEST ? "https://api.testnet.certifaction.io" : "https://api.certifaction.io";
    }

    private String getHinApiParamter() {
        return this.mode == IHinSignService.Mode.TEST ? "https://oauth2.sign-test.hin.ch/api" : "https://oauth2.sign.hin.ch/api";
    }

    private static Optional<File> getCliLocation() {
        File cliDirectory;
        Optional bundleLocation;
        Bundle fragment = null;
        if (CoreUtil.getOperatingSystemType() == CoreUtil.OS.WINDOWS) {
            fragment = Platform.getBundle((String)"at.medevit.elexis.hin.sign.cli.win");
        } else if (CoreUtil.getOperatingSystemType() == CoreUtil.OS.LINUX) {
            fragment = Platform.getBundle((String)"at.medevit.elexis.hin.sign.cli.linux");
        } else if (CoreUtil.getOperatingSystemType() == CoreUtil.OS.MAC) {
            fragment = Platform.getBundle((String)"at.medevit.elexis.hin.sign.cli.mac");
        }
        if (fragment != null && (bundleLocation = FileLocator.getBundleFileLocation((Bundle)fragment)).isPresent() && (cliDirectory = new File((File)bundleLocation.get(), "cli")).exists() && cliDirectory.isDirectory()) {
            return Optional.of(cliDirectory);
        }
        return Optional.empty();
    }

    private static String getExecutableName() {
        File cliDirectory = CliProcess.getCliLocation().get();
        File[] certifactionFiles = cliDirectory.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.startsWith("certifaction");
            }
        });
        return CliProcess.getFilePath(certifactionFiles[0]);
    }

    private static String getFilePath(File file) {
        String path = file.getAbsolutePath();
        if (CoreUtil.isWindows()) {
            path = path.replace("\\", "\\\\");
        } else if (CoreUtil.isLinux()) {
            HashSet<PosixFilePermission> perms = new HashSet<PosixFilePermission>();
            perms.add(PosixFilePermission.OWNER_READ);
            perms.add(PosixFilePermission.OWNER_EXECUTE);
            try {
                Files.setPosixFilePermissions(file.toPath(), perms);
            }
            catch (IOException e) {
                LoggerFactory.getLogger(CliProcess.class).error("Error setting executable file permissions", (Throwable)e);
            }
        }
        return path;
    }

    public static boolean isCliAvailable() {
        return CliProcess.getCliLocation().isPresent();
    }

    public static CliProcess createPrescription(String epdHandle, String chmed, IHinSignService.Mode mode) {
        if (CliProcess.isCliAvailable()) {
            try {
                Path tmpFile = Files.createTempFile("eprescription", ".tmp", new FileAttribute[0]);
                Files.writeString(tmpFile, (CharSequence)chmed, new OpenOption[0]);
                CliProcess ret = new CliProcess();
                ret.command.add(CliProcess.getExecutableName());
                ret.command.add("eprescription");
                ret.command.add("create");
                ret.command.add("--api");
                ret.command.add(ret.getApiParamter());
                ret.command.add("--hin-api");
                ret.command.add(ret.getHinApiParamter());
                ret.command.add("--token");
                ret.command.add(epdHandle);
                ret.command.add("-o");
                ret.command.add("-");
                ret.command.add("-f");
                ret.command.add("data");
                ret.command.add(CliProcess.getFilePath(tmpFile.toFile()));
                ret.setMode(mode);
                return ret;
            }
            catch (Exception e) {
                logger.error("Error creating chmed temp file", (Throwable)e);
                throw new IllegalStateException("Error creating chmed temp file");
            }
        }
        throw new IllegalStateException("No CLI available");
    }

    public static CliProcess verifyPrescription(String chmedUrl, IHinSignService.Mode mode) {
        if (CliProcess.isCliAvailable()) {
            CliProcess ret = new CliProcess();
            ret.command.add(CliProcess.getExecutableName());
            ret.command.add("eprescription");
            ret.command.add("verify");
            ret.command.add("--api");
            ret.command.add(ret.getApiParamter());
            ret.command.add("--hin-api");
            ret.command.add(ret.getHinApiParamter());
            ret.command.add(chmedUrl);
            ret.setMode(mode);
            return ret;
        }
        throw new IllegalStateException("No CLI available");
    }

    public static CliProcess revokePrescription(String epdHandle, String chmedId, IHinSignService.Mode mode) {
        if (CliProcess.isCliAvailable()) {
            CliProcess ret = new CliProcess();
            ret.command.add(CliProcess.getExecutableName());
            ret.command.add("eprescription");
            ret.command.add("revoke");
            ret.command.add("--api");
            ret.command.add(ret.getApiParamter());
            ret.command.add("--hin-api");
            ret.command.add(ret.getHinApiParamter());
            ret.command.add("--token");
            ret.command.add(epdHandle);
            ret.command.add("--epdg");
            ret.command.add(chmedId);
            ret.setMode(mode);
            return ret;
        }
        throw new IllegalStateException("No CLI available");
    }

    public static CliProcess cancelPrescription(String epdHandle, String chmedId, IHinSignService.Mode mode) {
        if (CliProcess.isCliAvailable()) {
            CliProcess ret = new CliProcess();
            ret.command.add(CliProcess.getExecutableName());
            ret.command.add("eprescription");
            ret.command.add("cancel");
            ret.command.add("--api");
            ret.command.add(ret.getApiParamter());
            ret.command.add("--hin-api");
            ret.command.add(ret.getHinApiParamter());
            ret.command.add("--token");
            ret.command.add(epdHandle);
            ret.command.add("--epdg");
            ret.command.add(chmedId);
            ret.setMode(mode);
            return ret;
        }
        throw new IllegalStateException("No CLI available");
    }

    private void setMode(IHinSignService.Mode mode) {
        this.mode = mode;
    }
}

