/*
 * Decompiled with CFR 0.152.
 */
package at.medevit.elexis.hin.auth.ui;

import at.medevit.elexis.hin.auth.core.IHinAuthUi;
import java.lang.reflect.InvocationTargetException;
import java.util.Optional;
import java.util.function.Supplier;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Display;
import org.osgi.service.component.annotations.Component;

@Component
public class HinAuthUi
implements IHinAuthUi {
    private String inputValue;
    private Object supplierValue;

    public void openBrowser(String url) {
        Program.launch((String)url);
    }

    public Optional<String> openInputDialog(String title, String message) {
        this.inputValue = null;
        Display.getDefault().syncExec(() -> {
            InputDialog dialog = new InputDialog(Display.getDefault().getActiveShell(), title, message, null, null);
            if (dialog.open() == 0) {
                this.inputValue = dialog.getValue();
            }
        });
        return Optional.ofNullable(this.inputValue);
    }

    public Object getWithCancelableProgress(String name, Supplier<?> supplier) {
        this.supplierValue = null;
        Display.getDefault().syncExec(() -> {
            ProgressMonitorDialog progressDialog = new ProgressMonitorDialog(Display.getDefault().getActiveShell());
            try {
                RetrySupplierRunnableWithProgress runnable = new RetrySupplierRunnableWithProgress(name, supplier);
                progressDialog.run(true, true, (IRunnableWithProgress)runnable);
                this.supplierValue = runnable.getValue();
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        return this.supplierValue;
    }

    private class RetrySupplierRunnableWithProgress
    implements IRunnableWithProgress {
        private Supplier<?> supplier;
        private String name;
        private Object value;

        public RetrySupplierRunnableWithProgress(String name, Supplier<?> supplier) {
            this.name = name;
            this.supplier = supplier;
        }

        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
            monitor.beginTask(this.name, -1);
            this.value = this.supplier.get();
            while (this.value == null && !monitor.isCanceled()) {
                Thread.sleep(2000L);
                this.value = this.supplier.get();
            }
            monitor.done();
        }

        public Object getValue() {
            return this.value;
        }
    }
}

