/*
 * Decompiled with CFR 0.152.
 */
package at.medevit.elexis.gdt;

import at.medevit.elexis.gdt.interfaces.IGDTCommunicationPartner;
import at.medevit.elexis.gdt.tools.DirectoryWatcher;
import at.medevit.elexis.gdt.tools.GDTCommPartnerCollector;
import java.io.File;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(property={"event.topics=org/eclipse/e4/ui/LifeCycle/appStartupComplete"})
public class StartupHandler
implements EventHandler {
    private static Logger logger = LoggerFactory.getLogger(StartupHandler.class);
    private ExecutorService executor = Executors.newSingleThreadExecutor();

    public void handleEvent(Event event) {
        logger.info("APPLICATION STARTUP COMPLETE");
        this.executor.execute(() -> {
            List<IGDTCommunicationPartner> lp = GDTCommPartnerCollector.getRegisteredCommPartners();
            if (lp == null) {
                logger.info("There are no registered communication partners");
                return;
            }
            for (IGDTCommunicationPartner igdtCommunicationPartner : lp) {
                if (igdtCommunicationPartner.getConnectionType() != 2) continue;
                String incomingDirString = igdtCommunicationPartner.getIncomingDirectory();
                logger.info("Found directory " + incomingDirString + "to watch by comm partner " + igdtCommunicationPartner.getLabel());
                File incomingDir = null;
                if (incomingDirString != null) {
                    incomingDir = new File(incomingDirString);
                }
                if (incomingDir == null || !incomingDir.isDirectory()) continue;
                DirectoryWatcher.getInstance().addDirectoryToWatch(incomingDir);
            }
        });
        this.executor.shutdown();
    }
}

