/*
 * Decompiled with CFR 0.152.
 */
package at.medevit.elexis.gdt.messages;

import at.medevit.elexis.gdt.messages.DateiArchivierungsKenner;
import at.medevit.elexis.gdt.messages.FreieKategorie;
import at.medevit.elexis.gdt.messages.GDTSatzNachricht;
import at.medevit.elexis.gdt.messages.TestIdent;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;

public class GDTSatzNachricht6310
extends GDTSatzNachricht {
    DateiArchivierungsKenner[] dateiArchivierungsKenner = null;
    String[] aktuelleDiagnose = null;
    String[] befund = null;
    String[] fremdBefund = null;
    String[] kommentar = null;
    String[] anzahlFortsetzungsZeilen6228 = null;
    String[] ergebnistabellenText = null;
    TestIdent[] testIdent = null;

    public GDTSatzNachricht6310(String patientenkennung, String nachnamePatient, String vornamePatient, String geburtsdatumPatient, String namenszusatz, String titelPatient, String versichertenNrPatient, String wohnortPatient, String strassePatient, String versichertenartPatient, String geschlechtPatient, String groessePatient, String gewichtPatient, String muttersprachePatient, String guvskf, String tagErhebungBehandlungsdaten, String uhrzeitErhebungBehandlungsdaten, String[] aktuelleDiagnose, String[] befund, String[] fremdbefund, String[] kommentar, String[] anzahlFortsetzungsZeilen6228, String[] ergebnistabellenText, TestIdent[] testIdent, DateiArchivierungsKenner[] dateiArchivierungsKenner, FreieKategorie[] freieKategorie, String signatur, String gdtIdReceiver, String gdtIdSender, String zeichensatz, String gdtVersion) {
        super(6310, gdtIdReceiver, gdtIdSender, zeichensatz, gdtVersion);
        this.values.put(3000, patientenkennung);
        this.values.put(3101, nachnamePatient);
        this.values.put(3102, vornamePatient);
        this.values.put(3103, geburtsdatumPatient);
        this.values.put(3100, namenszusatz);
        this.values.put(3104, titelPatient);
        this.values.put(3105, versichertenNrPatient);
        this.values.put(3106, wohnortPatient);
        this.values.put(3107, strassePatient);
        this.values.put(3108, versichertenartPatient);
        this.values.put(3110, geschlechtPatient);
        this.values.put(3622, groessePatient);
        this.values.put(3623, gewichtPatient);
        this.values.put(3628, muttersprachePatient);
        this.values.put(8402, guvskf);
        this.values.put(6200, tagErhebungBehandlungsdaten);
        this.values.put(6201, uhrzeitErhebungBehandlungsdaten);
        this.values.put(8990, signatur);
        this.dateiArchivierungsKenner = dateiArchivierungsKenner;
        this.aktuelleDiagnose = aktuelleDiagnose;
        this.befund = befund;
        this.fremdBefund = fremdbefund;
        this.kommentar = kommentar;
        this.anzahlFortsetzungsZeilen6228 = anzahlFortsetzungsZeilen6228;
        this.ergebnistabellenText = ergebnistabellenText;
        this.testIdent = testIdent;
    }

    public static GDTSatzNachricht6310 createfromStringArray(String[] satznachricht) {
        LinkedHashMap<Integer, String> ds = new LinkedHashMap<Integer, String>();
        LinkedList<String> aktDiag = new LinkedList<String>();
        LinkedList<String> befund = new LinkedList<String>();
        LinkedList<String> fremdBefund = new LinkedList<String>();
        LinkedList<String> kommentar = new LinkedList<String>();
        LinkedList<String> anzahlFortsetzungszeilen6228 = new LinkedList<String>();
        LinkedList<String> ergebnistabellenText = new LinkedList<String>();
        LinkedList<DateiArchivierungsKenner> dateiArchivierungskenner = new LinkedList<DateiArchivierungsKenner>();
        DateiArchivierungsKenner currDateiArchivierungsKenner = null;
        LinkedList<TestIdent> testIdents = new LinkedList<TestIdent>();
        TestIdent currTestIdent = null;
        LinkedList<FreieKategorie> freieKategorien = new LinkedList<FreieKategorie>();
        FreieKategorie currFreieKategorie = null;
        int i = 0;
        while (i < satznachricht.length) {
            int length = Integer.parseInt(satznachricht[i].substring(0, 3));
            int feldkennung = Integer.parseInt(satznachricht[i].substring(3, 7));
            String value = satznachricht[i].substring(7, length - 2);
            if (feldkennung >= 8410 && feldkennung <= 8480) {
                currTestIdent = GDTSatzNachricht6310.handleCurrentTestIdent(testIdents, currTestIdent, feldkennung, value);
            } else if (feldkennung >= 6330 && feldkennung <= 6399) {
                GDTSatzNachricht6310.handleCurrentFreieKategorie(freieKategorien, currFreieKategorie, feldkennung, value);
            } else if (feldkennung >= 6302 && feldkennung <= 6305) {
                GDTSatzNachricht6310.handleCurrentDateiArchivierungsKenner(dateiArchivierungskenner, currDateiArchivierungsKenner, feldkennung, value);
            } else {
                switch (feldkennung) {
                    case 6205: {
                        aktDiag.add(value);
                        break;
                    }
                    case 6220: {
                        befund.add(value);
                        break;
                    }
                    case 6221: {
                        fremdBefund.add(value);
                        break;
                    }
                    case 6227: {
                        kommentar.add(value);
                        break;
                    }
                    case 6226: {
                        anzahlFortsetzungszeilen6228.add(value);
                        break;
                    }
                    case 6228: {
                        ergebnistabellenText.add(value);
                        break;
                    }
                    default: {
                        ds.put(feldkennung, value);
                    }
                }
            }
            ++i;
        }
        if (currDateiArchivierungsKenner != null) {
            dateiArchivierungskenner.add(currDateiArchivierungsKenner);
        }
        if (currFreieKategorie != null) {
            freieKategorien.add(currFreieKategorie);
        }
        if (currTestIdent != null) {
            testIdents.add(currTestIdent);
        }
        return new GDTSatzNachricht6310((String)((HashMap)ds).get(3000), (String)((HashMap)ds).get(3101), (String)((HashMap)ds).get(3102), (String)((HashMap)ds).get(3103), (String)((HashMap)ds).get(3100), (String)((HashMap)ds).get(3104), (String)((HashMap)ds).get(3105), (String)((HashMap)ds).get(3106), (String)((HashMap)ds).get(3107), (String)((HashMap)ds).get(3108), (String)((HashMap)ds).get(3110), (String)((HashMap)ds).get(3622), (String)((HashMap)ds).get(3623), (String)((HashMap)ds).get(3628), (String)((HashMap)ds).get(8402), (String)((HashMap)ds).get(6200), (String)((HashMap)ds).get(6201), aktDiag.toArray(new String[0]), befund.toArray(new String[0]), fremdBefund.toArray(new String[0]), kommentar.toArray(new String[0]), anzahlFortsetzungszeilen6228.toArray(new String[0]), ergebnistabellenText.toArray(new String[0]), testIdents.toArray(new TestIdent[0]), dateiArchivierungskenner.toArray(new DateiArchivierungsKenner[0]), freieKategorien.toArray(new FreieKategorie[0]), (String)((HashMap)ds).get(8990), (String)((HashMap)ds).get(8315), (String)((HashMap)ds).get(8316), (String)((HashMap)ds).get(9206), (String)((HashMap)ds).get(9218));
    }

    private static TestIdent handleCurrentTestIdent(LinkedList<TestIdent> testIdents, TestIdent currTestIdent, int feldkennung, String value) {
        switch (feldkennung) {
            case 8410: {
                if (currTestIdent == null) {
                    currTestIdent = new TestIdent();
                } else {
                    testIdents.add(currTestIdent);
                }
                currTestIdent.setTestIdent(value);
                break;
            }
            default: {
                if (currTestIdent == null) {
                    currTestIdent = new TestIdent();
                }
                currTestIdent.setValue(feldkennung, value);
            }
        }
        return currTestIdent;
    }

    private static void handleCurrentFreieKategorie(LinkedList<FreieKategorie> freieKategorien, FreieKategorie currFreieKategorie, int feldkennung, String value) {
        switch (feldkennung) {
            case 6330: {
                if (currFreieKategorie == null) {
                    currFreieKategorie = new FreieKategorie();
                } else {
                    freieKategorien.add(currFreieKategorie);
                }
                currFreieKategorie.setName(value);
                break;
            }
            default: {
                if (currFreieKategorie == null) {
                    currFreieKategorie = new FreieKategorie();
                }
                currFreieKategorie.setValue(feldkennung, value);
            }
        }
    }

    private static void handleCurrentDateiArchivierungsKenner(LinkedList<DateiArchivierungsKenner> dateiArchivierungskenner, DateiArchivierungsKenner currDateiArchivierungsKenner, int feldkennung, String value) {
        switch (feldkennung) {
            case 6302: {
                if (currDateiArchivierungsKenner == null) {
                    currDateiArchivierungsKenner = new DateiArchivierungsKenner(value, null, null, null);
                    break;
                }
                dateiArchivierungskenner.add(currDateiArchivierungsKenner);
                break;
            }
            case 6303: {
                if (currDateiArchivierungsKenner == null) {
                    currDateiArchivierungsKenner = new DateiArchivierungsKenner(null, value, null, null);
                } else {
                    currDateiArchivierungsKenner.setValue(6303, value);
                }
            }
            case 6304: {
                if (currDateiArchivierungsKenner == null) {
                    currDateiArchivierungsKenner = new DateiArchivierungsKenner(null, null, value, null);
                } else {
                    currDateiArchivierungsKenner.setValue(6304, value);
                }
            }
            case 6305: {
                if (currDateiArchivierungsKenner == null) {
                    currDateiArchivierungsKenner = new DateiArchivierungsKenner(null, null, null, value);
                    break;
                }
                currDateiArchivierungsKenner.setValue(6305, value);
            }
        }
    }

    @Override
    protected void createMessage() {
        int i;
        super.createMessage();
        this.addLine("0102MEDELEXIS AG");
        this.addLine("0103MEDELEXIS");
        this.addLine("01322.1");
        this.addLine(3000);
        this.ifSetAddLine(3100);
        this.ifSetAddLine(3101);
        this.ifSetAddLine(3102);
        this.ifSetAddLine(3103);
        this.ifSetAddLine(3104);
        this.ifSetAddLine(3105);
        this.ifSetAddLine(3106);
        this.ifSetAddLine(3107);
        this.ifSetAddLine(3108);
        this.ifSetAddLine(3110);
        this.ifSetAddLine(3622);
        this.ifSetAddLine(3623);
        this.ifSetAddLine(3628);
        this.ifSetAddLine(8402);
        this.ifSetAddLine(6200);
        this.ifSetAddLine(6201);
        if (this.aktuelleDiagnose != null) {
            i = 0;
            while (i < this.aktuelleDiagnose.length) {
                this.addLine("6205" + this.aktuelleDiagnose[i]);
                ++i;
            }
        }
        if (this.befund != null) {
            i = 0;
            while (i < this.befund.length) {
                this.addLine("6220" + this.befund[i]);
                ++i;
            }
        }
        if (this.fremdBefund != null) {
            i = 0;
            while (i < this.fremdBefund.length) {
                this.addLine("6221" + this.fremdBefund[i]);
                ++i;
            }
        }
        if (this.kommentar != null) {
            i = 0;
            while (i < this.kommentar.length) {
                this.addLine("6227" + this.kommentar[i]);
                ++i;
            }
        }
        if (this.anzahlFortsetzungsZeilen6228 != null) {
            i = 0;
            while (i < this.anzahlFortsetzungsZeilen6228.length) {
                this.addLine("6226" + this.anzahlFortsetzungsZeilen6228[i]);
                ++i;
            }
        }
        if (this.ergebnistabellenText != null) {
            i = 0;
            while (i < this.ergebnistabellenText.length) {
                this.addLine("8480" + this.ergebnistabellenText[i]);
                ++i;
            }
        }
        if (this.testIdent != null) {
            i = 0;
            while (i < this.testIdent.length) {
                List<String> ergebnisTexte;
                List<String> anmerkungen;
                List<String> datenstrom;
                List<String> probenMaterialSpezfikation;
                TestIdent t = this.testIdent[i];
                if (t.getTestIdent() == null) {
                    this.addLine("8410TestNumber" + (i + 1));
                } else {
                    this.addLine("8410" + t.getTestIdent());
                }
                if (t.getTestBezeichnung() != null) {
                    this.addLine("8411" + t.getTestBezeichnung());
                }
                if (t.getProbenmaterialIdent() != null) {
                    this.addLine("8428" + t.getProbenmaterialIdent());
                }
                if (t.getProbenmaterialIndex() != null) {
                    this.addLine("8429" + t.getProbenmaterialIndex());
                }
                if (t.getProbenmaterialBezeichnung() != null) {
                    this.addLine("8430" + t.getProbenmaterialBezeichnung());
                }
                if ((probenMaterialSpezfikation = t.getProbenmaterialSpezifikation()) != null && probenMaterialSpezfikation.size() > 0) {
                    for (String string : probenMaterialSpezfikation) {
                        if (string == null) continue;
                        this.addLine("8431" + string);
                    }
                }
                if (t.getEinheitenFuerDatenstrom() != null) {
                    this.addLine("8437" + t.getEinheitenFuerDatenstrom());
                }
                if ((datenstrom = t.getDatenStrom()) != null && datenstrom.size() > 0) {
                    for (String string : datenstrom) {
                        if (string == null) continue;
                        this.addLine("8438" + string);
                    }
                }
                if (t.getTestStatus() != null) {
                    this.addLine("8418" + t.getTestStatus());
                }
                if (t.getErgebnisWert() != null) {
                    this.addLine("8420" + t.getErgebnisWert());
                }
                if (t.getEinheit() != null) {
                    this.addLine("8421" + t.getEinheit());
                }
                if (t.getAbnahmeDatum() != null) {
                    this.addLine("8432" + t.getAbnahmeDatum());
                }
                if (t.getAbnahmeZeit() != null) {
                    this.addLine("8439" + t.getAbnahmeZeit());
                }
                if (t.getNormalwertText() != null) {
                    this.addLine("8460" + t.getNormalwertText());
                }
                if (t.getNormalwertUntereGrenze() != null) {
                    this.addLine("8461" + t.getNormalwertUntereGrenze());
                }
                if (t.getNormalwertObereGrenze() != null) {
                    this.addLine("8462" + t.getNormalwertObereGrenze());
                }
                if ((anmerkungen = t.getAnmerkung()) != null) {
                    for (String string : anmerkungen) {
                        if (string == null) continue;
                        this.addLine("8470" + string);
                    }
                }
                if ((ergebnisTexte = t.getErgebnisText()) != null) {
                    for (String string : ergebnisTexte) {
                        if (string == null) continue;
                        this.addLine("8480" + string);
                    }
                }
                ++i;
            }
        }
        this.ifSetAddLine(8990);
    }

    public TestIdent[] getTestIdent() {
        return this.testIdent;
    }
}

