/*
 * Decompiled with CFR 0.152.
 */
package at.medevit.elexis.gdt.handler;

import at.medevit.elexis.gdt.data.GDTProtokoll;
import at.medevit.elexis.gdt.interfaces.HandlerProgramType;
import at.medevit.elexis.gdt.interfaces.IGDTCommunicationPartner;
import at.medevit.elexis.gdt.messages.GDTSatzNachricht;
import at.medevit.elexis.gdt.tools.GDTFileHelper;
import java.io.IOException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.statushandlers.StatusManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GDTOutputHandler {
    private static Logger logger = LoggerFactory.getLogger(GDTOutputHandler.class);

    public static void handleOutput(GDTSatzNachricht gdtSatzNachricht, IGDTCommunicationPartner cp, HandlerProgramType handlerType) {
        cp.handleOutput(gdtSatzNachricht);
        int connectionType = cp.getConnectionType();
        switch (connectionType) {
            case 2: {
                boolean success = GDTFileHelper.writeGDTSatzNachricht(gdtSatzNachricht, cp);
                if (success) {
                    GDTProtokoll.addEntry("OUT", cp, gdtSatzNachricht);
                } else {
                    String message = "Fehler beim Schreiben der GDT Satznachricht " + gdtSatzNachricht.getValue(8000) + " auf " + cp.getLabel();
                    Status status = new Status(2, "at.medevit.elexis.gdt", message);
                    StatusManager.getManager().handle((IStatus)status, 2);
                    logger.warn(message);
                }
                final IViewPart protokoll = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().findView("at.medevit.elexis.gdt.ui.GDTProtokollView");
                Display display = PlatformUI.getWorkbench().getDisplay();
                display.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (protokoll != null) {
                            protokoll.setFocus();
                        }
                    }
                });
                String handlerProgram = cp.getExternalHandlerProgram(handlerType);
                if (handlerProgram == null && handlerType == HandlerProgramType.VIEWER) {
                    handlerProgram = cp.getExternalHandlerProgram(HandlerProgramType.DEFAULT);
                }
                logger.info("Handler program of [" + cp.getLabel() + "] [" + handlerProgram + "]");
                if (handlerProgram == null) break;
                Boolean externalHandlerWait = cp.getExternalHandlerProgramWait();
                Runtime runtime = Runtime.getRuntime();
                logger.info("Command line [" + handlerProgram + "]");
                try {
                    Process exec = runtime.exec(handlerProgram);
                    if (externalHandlerWait.booleanValue()) {
                        int exitValue = exec.waitFor();
                        logger.debug("Return value of " + handlerProgram + ": " + exitValue);
                        break;
                    }
                    logger.debug("Execution of " + handlerProgram + ": no wait");
                }
                catch (IOException | InterruptedException e) {
                    String message = "Fehler beim Ausf\u00fchren von " + handlerProgram;
                    Status status = new Status(2, "at.medevit.elexis.gdt", message, (Throwable)e);
                    StatusManager.getManager().handle((IStatus)status, 2);
                    logger.error(message, (Throwable)e);
                }
                break;
            }
            case 1: {
                break;
            }
        }
    }
}

