/*
 * Decompiled with CFR 0.152.
 */
package at.medevit.elexis.gdt.data;

import at.medevit.elexis.gdt.interfaces.IGDTCommunicationPartner;
import at.medevit.elexis.gdt.messages.GDTSatzNachricht;
import ch.elexis.core.jdt.Nullable;
import ch.elexis.data.Patient;
import ch.elexis.data.PersistentObject;
import ch.elexis.data.Query;
import ch.rgw.tools.TimeTool;
import java.util.Collections;
import java.util.List;

public class GDTProtokoll
extends PersistentObject {
    public static final String FLD_DATETIME = "DateTime";
    public static final String FLD_PATIENT_ID = "PatientID";
    public static final String FLD_BEZEICHNUNG = "Bezeichnung";
    public static final String FLD_BEMERKUNGEN = "Bemerkungen";
    public static final String FLD_MESSAGE_TYPE = "MessageType";
    public static final String FLD_MESSAGE_DIRECTION = "MessageDirection";
    public static final String FLD_GEGENSTELLE = "Remote";
    public static final String FLD_MESSAGE = "Message";
    public static final String MESSAGE_DIRECTION_IN = "IN";
    public static final String MESSAGE_DIRECTION_OUT = "OUT";
    static final String TABLENAME = "at_medevit_elexis_gdt_protokoll";

    static {
        GDTProtokoll.addMapping((String)TABLENAME, (String[])new String[]{FLD_DATETIME, FLD_PATIENT_ID, FLD_BEZEICHNUNG, FLD_BEMERKUNGEN, FLD_MESSAGE_TYPE, FLD_MESSAGE_DIRECTION, FLD_GEGENSTELLE, FLD_MESSAGE});
    }

    GDTProtokoll() {
    }

    protected GDTProtokoll(String id) {
        super(id);
    }

    public <U extends GDTSatzNachricht> GDTProtokoll(String messageDirection, IGDTCommunicationPartner cp, U satzNachricht) {
        this.create(null);
        Patient pat = Patient.loadByPatientID((String)satzNachricht.getValue(3000));
        StringBuilder sb = new StringBuilder();
        String[] message = satzNachricht.getMessage();
        int i = 0;
        while (i < message.length) {
            sb.append(message[i]);
            ++i;
        }
        this.set(new String[]{FLD_DATETIME, FLD_PATIENT_ID, FLD_MESSAGE_TYPE, FLD_MESSAGE_DIRECTION, FLD_GEGENSTELLE, FLD_MESSAGE, FLD_BEZEICHNUNG}, new String[]{new TimeTool().toString(13), pat != null ? pat.getId() : "nicht zugeordnet", satzNachricht.getValue(8000), messageDirection, cp.getLabel(), sb.toString(), satzNachricht.getValue(8410)});
        int satznachrichtType = Integer.parseInt(satzNachricht.getValue(8000));
        if (messageDirection.equalsIgnoreCase(MESSAGE_DIRECTION_OUT)) {
            switch (satznachrichtType) {
                case 6302: {
                    this.set(FLD_BEZEICHNUNG, "Anforderung Untersuchung: " + satzNachricht.getValue(8402));
                    break;
                }
                case 6311: {
                    this.set(FLD_BEZEICHNUNG, "Anzeige Untersuchung: " + satzNachricht.getValue(8402));
                    break;
                }
                case 6301: {
                    this.set(FLD_BEZEICHNUNG, "Stammdaten \u00fcbermittelt");
                    break;
                }
            }
        }
        if (messageDirection.equalsIgnoreCase(MESSAGE_DIRECTION_IN)) {
            switch (satznachrichtType) {
                case 6310: {
                    this.set(FLD_BEZEICHNUNG, "Resultat Untersuchung: " + satzNachricht.getValue(8402));
                    break;
                }
            }
        }
    }

    public static GDTProtokoll load(String id) {
        return new GDTProtokoll(id);
    }

    protected String getTableName() {
        return TABLENAME;
    }

    public String getLabel() {
        StringBuilder sb = new StringBuilder();
        TimeTool tt = new TimeTool(this.get(FLD_DATETIME));
        Patient pat = Patient.loadByPatientID((String)this.get(FLD_PATIENT_ID));
        sb.append(tt.toString(4) + ": " + pat.getLabel() + " MessageType MessageDirection");
        return sb.toString();
    }

    public String getMenuLabel() {
        StringBuilder sb = new StringBuilder();
        TimeTool tt = new TimeTool(this.get(FLD_DATETIME));
        sb.append(tt.toString(4) + ": " + this.get(FLD_BEZEICHNUNG) + " [" + this.get(FLD_GEGENSTELLE) + "]");
        return sb.toString();
    }

    public static <U extends GDTSatzNachricht> GDTProtokoll addEntry(String messageDirection, IGDTCommunicationPartner cp, U satzNachricht) {
        return new GDTProtokoll(messageDirection, cp, satzNachricht);
    }

    public static GDTProtokoll[] getAllEntries() {
        Query qbe = new Query(GDTProtokoll.class);
        qbe.add("ID", "<>", "VERSION");
        List qre = qbe.execute();
        return qre.toArray(new GDTProtokoll[0]);
    }

    public static List<GDTProtokoll> getEntriesForPatient(String patientId, @Nullable String remoteName, @Nullable String messageType) {
        if (patientId != null) {
            Query qbe = new Query(GDTProtokoll.class, FLD_PATIENT_ID, patientId, TABLENAME, new String[]{FLD_MESSAGE_TYPE, FLD_MESSAGE_DIRECTION, FLD_DATETIME});
            if (remoteName != null) {
                qbe.add(FLD_GEGENSTELLE, "=", remoteName);
            }
            if (messageType != null) {
                qbe.add(FLD_MESSAGE_TYPE, "=", messageType);
            }
            return qbe.execute();
        }
        return Collections.emptyList();
    }

    public String getMessageDirection() {
        return this.get(FLD_MESSAGE_DIRECTION);
    }

    public TimeTool getEntryTime() {
        return new TimeTool(this.get(FLD_DATETIME));
    }

    public String getMessageType() {
        return this.get(FLD_MESSAGE_TYPE);
    }

    public Patient getEntryRelatedPatient() {
        return Patient.load((String)this.get(FLD_PATIENT_ID));
    }

    public String getBezeichnung() {
        return this.get(FLD_BEZEICHNUNG);
    }

    public void setBezeichnung(String bezeichnung) {
        this.set(FLD_BEZEICHNUNG, bezeichnung);
    }

    public String getBemerkungen() {
        return this.get(FLD_BEMERKUNGEN);
    }

    public void setBemerkungen(String bemerkung) {
        this.set(FLD_BEMERKUNGEN, bemerkung);
    }

    public String getGegenstelle() {
        return this.get(FLD_GEGENSTELLE);
    }

    public String getMessage() {
        return this.get(FLD_MESSAGE);
    }
}

