/*
 * Decompiled with CFR 0.152.
 */
package at.medevit.elexis.gdt.defaultfilecp.ui;

import at.medevit.elexis.gdt.defaultfilecp.FileCommPartner;
import at.medevit.elexis.gdt.defaultfilecp.ui.GDTPreferencePageFileTransfer;
import ch.elexis.core.ui.UiDesk;
import ch.elexis.core.ui.util.SWTHelper;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferencePage;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class FileCommPartnerComposite
extends Composite {
    private final FileCommPartner fileCommPartner;
    private final IPreferencePage preferencePage;
    private final ScrolledComposite scrolledComposite;
    private Text txtName;
    private Text txtIdReceiver;
    private Text txtIdShortReceiver;
    private Text txtExchangeDir;
    private Text txtExchangeInDir;
    private Text txtExchangeOutDir;
    private Text txtExecutable;
    private Text txtViewerExecutable;
    private Text txtAdditionalParam;
    private Button btnExecutableWait;
    private Button[] btnFileTypes = new Button[2];

    public FileCommPartnerComposite(IPreferencePage preferencePage, ScrolledComposite scrolledComposite, Composite editorParent, FileCommPartner fileCommPartner) {
        super(editorParent, 2048);
        this.preferencePage = preferencePage;
        this.fileCommPartner = fileCommPartner;
        this.createElements();
        this.scrolledComposite = scrolledComposite;
        this.refreshParent(this.getParent());
    }

    private void createElements() {
        this.setLayoutData(new GridData(4, 2048, true, false, 3, 1));
        this.setLayout((Layout)new GridLayout(3, false));
        GridData gridData1Col = SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)false);
        gridData1Col.widthHint = 120;
        GridData gridData2Col = SWTHelper.getFillGridData((int)2, (boolean)true, (int)1, (boolean)false);
        GridData gridData3Col = SWTHelper.getFillGridData((int)3, (boolean)true, (int)1, (boolean)false);
        Label label = new Label((Composite)this, 131072);
        label.setText("");
        label.setLayoutData((Object)gridData3Col);
        label.setBackground(UiDesk.getColor((String)"hellgrau"));
        new Label((Composite)this, 0).setText("Ger\u00e4tename");
        this.txtName = new Text((Composite)this, 2048);
        this.txtName.setLayoutData((Object)gridData2Col);
        this.txtName.setText(this.getValueByConfigKey(this.fileCommPartner.getFileTransferName()));
        new Label((Composite)this, 0).setText("Lange GDT ID Receiver");
        this.txtIdReceiver = new Text((Composite)this, 2048);
        this.txtIdReceiver.setLayoutData((Object)gridData2Col);
        this.txtIdReceiver.setText(this.getValueByConfigKey(this.fileCommPartner.getFileTransferIdReceiver()));
        new Label((Composite)this, 0).setText("Kurze GDT ID Receiver");
        this.txtIdShortReceiver = new Text((Composite)this, 2048);
        this.txtIdShortReceiver.setLayoutData((Object)gridData2Col);
        this.txtIdShortReceiver.setText(this.getValueByConfigKey(this.fileCommPartner.getFileTransferShortIdReceiver()));
        new Label((Composite)this, 0).setText("Standard-Austausch-Verzeichnis");
        this.txtExchangeDir = new Text((Composite)this, 2048);
        this.txtExchangeDir.setLayoutData((Object)gridData1Col);
        this.txtExchangeDir.setText(this.getValueByConfigKey(this.fileCommPartner.getFileTransferDirectory()));
        Button btnExchangeDir = new Button((Composite)this, 8);
        btnExchangeDir.setText("Browse...");
        btnExchangeDir.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                DirectoryDialog dlg = new DirectoryDialog(FileCommPartnerComposite.this.getShell());
                dlg.setFilterPath(FileCommPartnerComposite.this.txtExchangeDir.getText());
                dlg.setText("Ordner suchen");
                String dir = dlg.open();
                if (dir != null) {
                    FileCommPartnerComposite.this.txtExchangeDir.setText(dir);
                }
            }
        });
        new Label((Composite)this, 0).setText("Verzeichnis Eingehend");
        this.txtExchangeInDir = new Text((Composite)this, 2048);
        this.txtExchangeInDir.setLayoutData((Object)gridData1Col);
        this.txtExchangeInDir.setText(this.getValueByConfigKey(this.fileCommPartner.getFileTransferInDirectory()));
        Button btnExchangeInDir = new Button((Composite)this, 8);
        btnExchangeInDir.setText("Browse...");
        btnExchangeInDir.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                DirectoryDialog dlg = new DirectoryDialog(FileCommPartnerComposite.this.getShell());
                dlg.setFilterPath(FileCommPartnerComposite.this.txtExchangeInDir.getText());
                dlg.setText("Ordner suchen");
                String dir = dlg.open();
                if (dir != null) {
                    FileCommPartnerComposite.this.txtExchangeInDir.setText(dir);
                }
            }
        });
        new Label((Composite)this, 0).setText("Verzeichnis Ausgehend");
        this.txtExchangeOutDir = new Text((Composite)this, 2048);
        this.txtExchangeOutDir.setLayoutData((Object)gridData1Col);
        this.txtExchangeOutDir.setText(this.getValueByConfigKey(this.fileCommPartner.getFileTransferOutDirectory()));
        Button btnExchangeOutDir = new Button((Composite)this, 8);
        btnExchangeOutDir.setText("Browse...");
        btnExchangeOutDir.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                DirectoryDialog dlg = new DirectoryDialog(FileCommPartnerComposite.this.getShell());
                dlg.setFilterPath(FileCommPartnerComposite.this.txtExchangeOutDir.getText());
                dlg.setText("Ordner suchen");
                String dir = dlg.open();
                if (dir != null) {
                    FileCommPartnerComposite.this.txtExchangeOutDir.setText(dir);
                }
            }
        });
        Group groupFileTypes = new Group((Composite)this, 4);
        groupFileTypes.setLayoutData((Object)SWTHelper.getFillGridData((int)3, (boolean)true, (int)1, (boolean)false));
        groupFileTypes.setText("Zu verwendender Dateityp");
        groupFileTypes.setLayout((Layout)new RowLayout(512));
        this.btnFileTypes[0] = new Button((Composite)groupFileTypes, 16);
        this.btnFileTypes[0].setText("fest");
        this.btnFileTypes[0].setSelection("fest".equals(this.getValueByConfigKey(this.fileCommPartner.getFileTransferUsedType())));
        this.btnFileTypes[1] = new Button((Composite)groupFileTypes, 16);
        this.btnFileTypes[1].setText("hochz\u00e4hlend");
        this.btnFileTypes[1].setSelection("hochzaehlend".equals(this.getValueByConfigKey(this.fileCommPartner.getFileTransferUsedType())));
        new Label((Composite)this, 0).setText("Verarbeitungsprogramm");
        this.txtExecutable = new Text((Composite)this, 2048);
        this.txtExecutable.setLayoutData((Object)gridData1Col);
        this.txtExecutable.setText(this.getValueByConfigKey(this.fileCommPartner.getFileTransferExecuteable()));
        Button btnExecutable = new Button((Composite)this, 8);
        btnExecutable.setText("Browse...");
        btnExecutable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                FileDialog dlg = new FileDialog(FileCommPartnerComposite.this.getShell());
                dlg.setFilterPath(FileCommPartnerComposite.this.txtExecutable.getText());
                dlg.setText("Datei suchen");
                String dir = dlg.open();
                if (dir != null) {
                    FileCommPartnerComposite.this.txtExecutable.setText(dir);
                }
            }
        });
        new Label((Composite)this, 0).setText("Anzeigeprogramm");
        this.txtViewerExecutable = new Text((Composite)this, 2048);
        this.txtViewerExecutable.setLayoutData((Object)gridData1Col);
        this.txtViewerExecutable.setText(this.getValueByConfigKey(this.fileCommPartner.getFileTransferViewerExecuteable()));
        Button btnViewerExecutable = new Button((Composite)this, 8);
        btnViewerExecutable.setText("Browse...");
        btnViewerExecutable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                FileDialog dlg = new FileDialog(FileCommPartnerComposite.this.getShell());
                dlg.setFilterPath(FileCommPartnerComposite.this.txtViewerExecutable.getText());
                dlg.setText("Datei suchen");
                String dir = dlg.open();
                if (dir != null) {
                    FileCommPartnerComposite.this.txtViewerExecutable.setText(dir);
                }
            }
        });
        new Label((Composite)this, 0).setText("Zusatzparameter");
        this.txtAdditionalParam = new Text((Composite)this, 2048);
        this.txtAdditionalParam.setLayoutData((Object)gridData2Col);
        this.txtAdditionalParam.setText(this.getValueByConfigKey(this.fileCommPartner.getFileAdditionalParams()));
        Label seperator = new Label((Composite)this, 258);
        seperator.setLayoutData((Object)new GridData(4, 0, true, true, 3, 1));
        new Label((Composite)this, 0).setText("Auf Programm Antwort warten");
        this.btnExecutableWait = new Button((Composite)this, 32);
        this.btnExecutableWait.setLayoutData((Object)gridData2Col);
        this.btnExecutableWait.setSelection(this.getBooleanValueByConfigKey(this.fileCommPartner.getFileTransferExecuteableWait()).booleanValue());
        Label itemText = new Label((Composite)this, 0);
        itemText.setText("Ger\u00e4t");
        Composite compositeBtns = new Composite((Composite)this, 0);
        compositeBtns.setLayout((Layout)new GridLayout(2, false));
        compositeBtns.setLayoutData((Object)new GridData(4, 0, true, false, 2, 1));
        Button btnRemove = new Button(compositeBtns, 0x1000000);
        btnRemove.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileCommPartnerComposite.this.remove();
            }
        });
        btnRemove.setText("Entfernen");
        btnRemove.setEnabled(!"DEFAULT".equals(this.fileCommPartner.getId()));
        Button btnAdd = new Button(compositeBtns, 0x1000000);
        btnAdd.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String id;
                InputDialog inDlg = new InputDialog(FileCommPartnerComposite.this.getShell(), "Ger\u00e4t", "Ger\u00e4t hinzuf\u00fcgen", "", null);
                if (inDlg.open() == 0 && !FileCommPartnerComposite.this.add(id = UUID.randomUUID().toString(), inDlg.getValue())) {
                    MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"Fehler", (String)"Dieses Ger\u00e4t wird bereits verwendet.");
                }
            }
        });
        btnAdd.setText("Hinzuf\u00fcgen");
    }

    private Boolean getBooleanValueByConfigKey(String cfgKey) {
        return this.fileCommPartner.getSettings().getBoolean(cfgKey);
    }

    private String getValueByConfigKey(String cfgKey) {
        return this.fileCommPartner.getSettings().getString(cfgKey);
    }

    private boolean add(String id, String name) {
        if (this.addFileCommPartner(id)) {
            ((GDTPreferencePageFileTransfer)this.preferencePage).createNewFileCommPartnerComposite(id, name, this.scrolledComposite);
            return true;
        }
        return false;
    }

    private boolean addFileCommPartner(String id) {
        String cfg = this.getAllFileCommPartners();
        if (!cfg.contains(id)) {
            this.updateFileCommPartner(cfg + ",;," + id);
            return true;
        }
        return false;
    }

    private String getAllFileCommPartners() {
        return (String)StringUtils.defaultIfBlank((CharSequence)this.fileCommPartner.getSettings().getString("GDT/fileTransferTypes"), (CharSequence)"DEFAULT");
    }

    private void removeFileCommPartner(String id) {
        String cfg = this.getAllFileCommPartners();
        if (cfg.contains(id)) {
            String newCfg = cfg.replaceFirst(",;," + id, "");
            this.updateFileCommPartner(newCfg);
        }
    }

    private void updateFileCommPartner(String cfg) {
        this.fileCommPartner.getSettings().setValue("GDT/fileTransferTypes", cfg);
    }

    private void remove() {
        this.removeFileCommPartner(this.fileCommPartner.getId());
        this.fileCommPartner.getSettings().setValue(this.fileCommPartner.getFileTransferIdReceiver(), null);
        this.fileCommPartner.getSettings().setValue(this.fileCommPartner.getFileTransferShortIdReceiver(), null);
        this.fileCommPartner.getSettings().setValue(this.fileCommPartner.getFileTransferDirectory(), null);
        this.fileCommPartner.getSettings().setValue(this.fileCommPartner.getFileTransferInDirectory(), null);
        this.fileCommPartner.getSettings().setValue(this.fileCommPartner.getFileTransferOutDirectory(), null);
        this.fileCommPartner.getSettings().setValue(this.fileCommPartner.getFileTransferUsedType(), null);
        this.fileCommPartner.getSettings().setValue(this.fileCommPartner.getFileTransferExecuteable(), null);
        this.fileCommPartner.getSettings().setValue(this.fileCommPartner.getFileTransferExecuteableWait(), null);
        this.fileCommPartner.getSettings().setValue(this.fileCommPartner.getFileTransferViewerExecuteable(), null);
        this.fileCommPartner.getSettings().setValue(this.fileCommPartner.getFileAdditionalParams(), null);
        this.fileCommPartner.getSettings().setValue(this.fileCommPartner.getFileTransferName(), null);
        Composite parent = this.getParent();
        this.dispose();
        this.refreshParent(parent);
    }

    public void save() {
        if (!this.isDisposed()) {
            this.fileCommPartner.getSettings().setValue(this.fileCommPartner.getFileTransferIdReceiver(), this.txtIdReceiver.getText());
            this.fileCommPartner.getSettings().setValue(this.fileCommPartner.getFileTransferShortIdReceiver(), this.txtIdShortReceiver.getText());
            this.fileCommPartner.getSettings().setValue(this.fileCommPartner.getFileTransferDirectory(), this.txtExchangeDir.getText());
            this.fileCommPartner.getSettings().setValue(this.fileCommPartner.getFileTransferInDirectory(), this.txtExchangeInDir.getText());
            this.fileCommPartner.getSettings().setValue(this.fileCommPartner.getFileTransferOutDirectory(), this.txtExchangeOutDir.getText());
            this.fileCommPartner.getSettings().setValue(this.fileCommPartner.getFileTransferUsedType(), this.btnFileTypes[1].getSelection() ? "hochzaehlend" : "fest");
            this.fileCommPartner.getSettings().setValue(this.fileCommPartner.getFileTransferExecuteable(), this.txtExecutable.getText());
            this.fileCommPartner.getSettings().setValue(this.fileCommPartner.getFileTransferExecuteableWait(), this.btnExecutableWait.getSelection());
            this.fileCommPartner.getSettings().setValue(this.fileCommPartner.getFileTransferViewerExecuteable(), this.txtViewerExecutable.getText());
            this.fileCommPartner.getSettings().setValue(this.fileCommPartner.getFileAdditionalParams(), this.txtAdditionalParam.getText());
            this.fileCommPartner.getSettings().setValue(this.fileCommPartner.getFileTransferName(), this.txtName.getText());
        }
    }

    private void refreshParent(Composite parent) {
        if (this.scrolledComposite != null) {
            this.scrolledComposite.setMinSize(parent.getParent().computeSize(-1, -1));
        }
        parent.layout();
    }
}

