/*
 * Decompiled with CFR 0.152.
 */
package at.medevit.elexis.emediplan;

import at.medevit.elexis.emediplan.core.EMediplanServiceHolder;
import at.medevit.elexis.emediplan.core.model.chmed16a.Medication;
import at.medevit.elexis.emediplan.ui.ImportEMediplanDialog;
import ch.elexis.barcode.scanner.BarcodeScannerMessage;
import ch.elexis.core.jdt.NonNull;
import ch.elexis.core.model.IPatient;
import ch.elexis.core.services.holder.ContextServiceHolder;
import ch.elexis.core.services.holder.CoreModelServiceHolder;
import ch.elexis.core.ui.UiDesk;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Base64;
import java.util.Optional;
import java.util.Timer;
import java.util.TimerTask;
import java.util.zip.GZIPInputStream;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(property={"event.topics=info/elexis/model/update"})
public class StartupHandler
implements EventHandler {
    private static Logger logger = LoggerFactory.getLogger(StartupHandler.class);
    private volatile StringBuffer buffer;

    public static void openEMediplanImportDialog(String chunk, String selectedPatientId) {
        final Medication medication = EMediplanServiceHolder.getService().createModelFromChunk(chunk);
        if (selectedPatientId != null && medication.Patient != null) {
            medication.Patient.patientId = selectedPatientId;
        }
        EMediplanServiceHolder.getService().addExistingArticlesToMedication(medication);
        if (medication != null) {
            if (medication.Patient != null && medication.Patient.patientId != null) {
                Optional patient = CoreModelServiceHolder.get().load(medication.Patient.patientId, IPatient.class);
                if (patient.isPresent()) {
                    ContextServiceHolder.get().setActivePatient((IPatient)patient.get());
                    UiDesk.getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("ch.elexis.core.ui.medication.views.MedicationView");
                            }
                            catch (PartInitException e) {
                                logger.warn("cannot open view with id: ch.elexis.core.ui.medication.views.MedicationView", (Throwable)e);
                            }
                            logger.debug("Opening ImportEMediplanDialog");
                            ImportEMediplanDialog dlg = new ImportEMediplanDialog(UiDesk.getTopShell(), medication, StringUtils.isNotBlank((CharSequence)medication.Patient.patientId));
                            dlg.open();
                        }
                    });
                } else {
                    logger.warn("Patient with id [" + medication.Patient.patientId + "] could not be loaded for emediplan");
                }
            } else {
                logger.warn("No patientid for emediplan");
            }
        }
    }

    private boolean hasMediplanHeader(String chunk) {
        return chunk.startsWith("CHMED");
    }

    public static String getDecodedJsonString(@NonNull String encodedJson) {
        String content = encodedJson.substring(9);
        byte[] zipped = Base64.getMimeDecoder().decode(content);
        StringBuilder sb = new StringBuilder();
        try {
            String read;
            GZIPInputStream gzip = new GZIPInputStream(new ByteArrayInputStream(zipped));
            InputStreamReader reader = new InputStreamReader(gzip);
            BufferedReader in = new BufferedReader(reader);
            while ((read = in.readLine()) != null) {
                sb.append(read);
            }
        }
        catch (IOException e) {
            LoggerFactory.getLogger(StartupHandler.class).error("Error decoding json", (Throwable)e);
            throw new IllegalStateException("Error decoding json", e);
        }
        return sb.toString();
    }

    public void handleEvent(Event event) {
        if (event.getTopic().equals("info/elexis/model/update") && event.getProperty("org.eclipse.e4.data") instanceof BarcodeScannerMessage) {
            BarcodeScannerMessage b = (BarcodeScannerMessage)event.getProperty("org.eclipse.e4.data");
            if (this.hasMediplanHeader(b.getChunk())) {
                this.chunkBuffer(b);
            } else if (this.buffer != null) {
                this.chunkBuffer(b);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void chunkBuffer(BarcodeScannerMessage message) {
        StartupHandler startupHandler = this;
        synchronized (startupHandler) {
            if (this.buffer == null) {
                logger.info("Start emdiplan buffer");
                this.buffer = new StringBuffer();
                new Timer().schedule(new TimerTask(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        StartupHandler startupHandler = StartupHandler.this;
                        synchronized (startupHandler) {
                            if (StartupHandler.this.buffer != null) {
                                try {
                                    logger.info("Import emdiplan buffer [" + StartupHandler.this.buffer.length() + "]");
                                    StartupHandler.openEMediplanImportDialog(StartupHandler.this.buffer.toString(), null);
                                }
                                finally {
                                    StartupHandler.this.buffer = null;
                                }
                            }
                        }
                    }
                }, 500L);
            }
            if (this.buffer != null) {
                this.buffer.append(message.getChunk());
            }
        }
    }
}

