/*
 * Decompiled with CFR 0.152.
 */
package at.medevit.elexis.ehc.ui.extension;

import at.medevit.elexis.ehc.ui.dialog.WizardCategory;
import at.medevit.elexis.ehc.ui.dialog.WizardDescriptor;
import at.medevit.elexis.ehc.ui.extension.IImportWizard;
import at.medevit.elexis.ehc.ui.extension.IWizardCategory;
import at.medevit.elexis.ehc.ui.extension.IWizardDescriptor;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImportWizardsExtension {
    private static Logger logger = LoggerFactory.getLogger(ImportWizardsExtension.class);
    private static final String OTHER_CATEGORYID = "at.medevit.elexis.ehc.ui.OtherCategoryId";
    private static List<IWizardCategory> cacheCategoriesList;
    private static List<IWizardDescriptor> cacheWizardsList;

    public static List<IWizardCategory> getCategories(boolean refresh) {
        if (refresh || cacheCategoriesList == null) {
            ImportWizardsExtension.refreshCache();
        }
        return cacheCategoriesList;
    }

    public static List<IWizardDescriptor> getWizards(boolean refresh) {
        if (refresh || cacheWizardsList == null) {
            ImportWizardsExtension.refreshCache();
        }
        return cacheWizardsList;
    }

    public static void setImportDocument(InputStream document) {
        List<IWizardDescriptor> wizards = ImportWizardsExtension.getWizards(false);
        for (IWizardDescriptor iWizardDescriptor : wizards) {
            try {
                IImportWizard wizard = (IImportWizard)iWizardDescriptor.createWizard();
                wizard.setDocument(document);
            }
            catch (CoreException e) {
                logger.error("Could not create import wizard.", (Throwable)e);
            }
        }
    }

    private static void refreshCache() {
        cacheCategoriesList = new ArrayList<IWizardCategory>();
        cacheWizardsList = new ArrayList<IWizardDescriptor>();
        logger.info("Initializing or refreshing Import Wizards.");
        IExtensionRegistry exr = Platform.getExtensionRegistry();
        IExtensionPoint exp = exr.getExtensionPoint("at.medevit.elexis.ehc.ui.ehcimport");
        if (exp != null) {
            IConfigurationElement el;
            int n;
            int n2;
            IConfigurationElement[] iConfigurationElementArray;
            IConfigurationElement[] elems;
            IExtension ex;
            IExtension[] extensions = exp.getExtensions();
            logger.info("Initializing or refreshing Import Wizards found " + extensions.length + " implementations.");
            IExtension[] iExtensionArray = extensions;
            int n3 = extensions.length;
            int n4 = 0;
            while (n4 < n3) {
                ex = iExtensionArray[n4];
                iConfigurationElementArray = elems = ex.getConfigurationElements();
                n2 = elems.length;
                n = 0;
                while (n < n2) {
                    el = iConfigurationElementArray[n];
                    if (el.getName().equals("category")) {
                        WizardCategory category = new WizardCategory(el);
                        cacheCategoriesList.add(category);
                    }
                    ++n;
                }
                ++n4;
            }
            iExtensionArray = extensions;
            n3 = extensions.length;
            n4 = 0;
            while (n4 < n3) {
                ex = iExtensionArray[n4];
                iConfigurationElementArray = elems = ex.getConfigurationElements();
                n2 = elems.length;
                n = 0;
                while (n < n2) {
                    el = iConfigurationElementArray[n];
                    if (el.getName().equals("wizard")) {
                        WizardDescriptor descriptor = new WizardDescriptor(el);
                        IWizardCategory matchingCategory = null;
                        for (IWizardCategory category : cacheCategoriesList) {
                            if (!category.getId().equals(descriptor.getCategoryId())) continue;
                            matchingCategory = category;
                            break;
                        }
                        if (matchingCategory == null) {
                            for (IWizardCategory category : cacheCategoriesList) {
                                if (!category.getId().equals(OTHER_CATEGORYID)) continue;
                                matchingCategory = category;
                                break;
                            }
                        }
                        if (matchingCategory == null) {
                            IWizardCategory category;
                            category = new WizardCategory(OTHER_CATEGORYID, "Other");
                            cacheCategoriesList.add(category);
                            matchingCategory = category;
                        }
                        matchingCategory.addWizard(descriptor);
                        cacheWizardsList.add(descriptor);
                    }
                    ++n;
                }
                ++n4;
            }
        }
    }
}

