/*
 * Decompiled with CFR 0.152.
 */
package at.medevit.elexis.ehc.ui.inbox;

import at.medevit.elexis.ehc.ui.inbox.InboxListener;
import at.medevit.elexis.ehc.ui.model.EhcDocument;
import at.medevit.elexis.ehc.ui.preference.PreferencePage;
import ch.elexis.core.model.IMandator;
import ch.elexis.core.services.holder.ConfigServiceHolder;
import ch.elexis.core.ui.e4.util.CoreUiUtil;
import jakarta.inject.Inject;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.swt.widgets.Display;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InboxWatcher {
    private static Logger logger = LoggerFactory.getLogger(InboxWatcher.class);
    private ExecutorService executor = Executors.newFixedThreadPool(2);
    private boolean stopping;
    private WatchService watcher;
    private HashMap<String, WatchKey> watchKeys = new HashMap();
    private String activeInboxString;
    private static String LinuxIoNtifyHint = "The inbox will not work correctly.\n\nHINT: Under linux calling 'echo 256 > /proc/sys/fs/inotify/max_user_instances' might fix the problem";
    private List<InboxListener> listeners = new ArrayList<InboxListener>();

    public InboxWatcher() {
        CoreUiUtil.injectServicesWithContext((Object)this);
    }

    public void start() {
        try {
            this.stopping = false;
            this.watcher = FileSystems.getDefault().newWatchService();
            this.executor.execute(new DirectoryWatcher());
        }
        catch (IOException e) {
            logger.error(LinuxIoNtifyHint);
            logger.error("Error creating filesystem watcher", (Throwable)e);
        }
    }

    public void stop() {
        try {
            this.stopping = true;
            this.executor.shutdownNow();
            if (this.watcher != null) {
                this.watcher.close();
            }
        }
        catch (IOException e) {
            logger.error("Error closing filesystem watcher", (Throwable)e);
        }
    }

    public synchronized void addInboxListener(InboxListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public synchronized void removeInboxListener(InboxListener listener) {
        this.listeners.remove(listener);
    }

    private void fireInboxCreated(EhcDocument newDocument) {
        for (InboxListener inboxListener : this.listeners) {
            inboxListener.documentCreated(newDocument);
        }
    }

    @Optional
    @Inject
    public void activeMandator(IMandator mandator) {
        Display.getDefault().asyncExec(() -> {
            this.activeInboxString = ConfigServiceHolder.getUser((String)PreferencePage.EHC_INPUTDIR, (String)PreferencePage.getDefaultInputDir());
            this.executor.execute(new DirectoryInitializer());
            if (this.watchKeys.get(this.activeInboxString) == null) {
                try {
                    Path inboxPath = Paths.get(this.activeInboxString, new String[0]);
                    if (!inboxPath.toFile().exists()) {
                        inboxPath.toFile().mkdirs();
                    }
                    if (this.watcher == null) {
                        String errorTitle = "Unable to create file watcher";
                        Status status = new Status(4, this.getClass().getSimpleName(), 4, errorTitle, null);
                        ErrorDialog.openError(null, (String)"Unable to create file watcher", (String)LinuxIoNtifyHint, (IStatus)status);
                    } else {
                        WatchKey key = inboxPath.register(this.watcher, StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_DELETE);
                        this.watchKeys.put(this.activeInboxString, key);
                    }
                }
                catch (IOException e) {
                    logger.error("Error creating filesystem key", (Throwable)e);
                }
            }
        });
    }

    private class DirectoryDocumentStrategy {
        private DirectoryDocumentStrategy() {
        }

        public void execute(URL fileUrl) {
            if (!EhcDocument.documentExists(fileUrl)) {
                if (EhcDocument.isEhcXml(fileUrl)) {
                    InboxWatcher.this.fireInboxCreated(EhcDocument.createFromXml(fileUrl));
                } else if (EhcDocument.isEhcXdm(fileUrl)) {
                    EhcDocument.createFromXdm(fileUrl);
                }
            }
        }
    }

    private class DirectoryInitializer
    implements Runnable {
        private DirectoryDocumentStrategy documentStrategy;

        public DirectoryInitializer() {
            this.documentStrategy = new DirectoryDocumentStrategy();
        }

        @Override
        public void run() {
            File[] files;
            File inboxFolder = new File(InboxWatcher.this.activeInboxString);
            if (!inboxFolder.exists()) {
                PreferencePage.initDirectories();
            }
            if ((files = inboxFolder.listFiles()) != null) {
                File[] fileArray = files;
                int n = files.length;
                int n2 = 0;
                while (n2 < n) {
                    File file = fileArray[n2];
                    if (!file.isDirectory()) {
                        try {
                            URL fileUrl = new URL("file:///" + file.getAbsolutePath());
                            this.documentStrategy.execute(fileUrl);
                        }
                        catch (MalformedURLException e) {
                            logger.error("Error initializing inbox.", (Throwable)e);
                        }
                    }
                    ++n2;
                }
            }
        }
    }

    private class DirectoryWatcher
    implements Runnable {
        private DirectoryDocumentStrategy documentStrategy;

        public DirectoryWatcher() {
            this.documentStrategy = new DirectoryDocumentStrategy();
        }

        @Override
        public void run() {
            block4: {
                WatchKey key = null;
                try {
                    do {
                        key = InboxWatcher.this.watcher.take();
                        WatchEvent.Kind<?> kind = null;
                        for (WatchEvent<?> watchEvent : key.pollEvents()) {
                            kind = watchEvent.kind();
                            if (StandardWatchEventKinds.OVERFLOW == kind || StandardWatchEventKinds.ENTRY_CREATE != kind) continue;
                            Path newPath = (Path)watchEvent.context();
                            String newInboxPath = InboxWatcher.this.activeInboxString + File.separator + newPath.getFileName().toString();
                            URL fileUrl = new URL("file:///" + newInboxPath);
                            this.documentStrategy.execute(fileUrl);
                        }
                    } while (key.reset());
                }
                catch (InterruptedException | MalformedURLException e) {
                    if (InboxWatcher.this.stopping) break block4;
                    logger.error("Filesystem watching interrupted stopping", (Throwable)e);
                }
            }
        }
    }
}

