/*
 * Decompiled with CFR 0.152.
 */
package at.medevit.elexis.ehc.ui.dialog;

import at.medevit.elexis.ehc.ui.dialog.ExportWizardsComposite;
import at.medevit.elexis.ehc.ui.extension.IWizardDescriptor;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class ExportWizardSelectionPage
extends WizardPage
implements IWizardPage {
    private static List<IWizardDescriptor> selectedWizardDescriptors = new ArrayList<IWizardDescriptor>();
    private IWizardDescriptor selectedWizardDescriptor;

    protected ExportWizardSelectionPage() {
        super("Export");
        this.setTitle("Exporter Selection");
        this.setDescription("Select an exporter for your data.");
        this.setPageComplete(false);
    }

    public void createControl(Composite parent) {
        ExportWizardsComposite composite = new ExportWizardsComposite(parent, 0);
        composite.getViewer().addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                Object o;
                ISelection selection = event.getSelection();
                if (!selection.isEmpty() && selection instanceof IStructuredSelection && (o = ((IStructuredSelection)selection).getFirstElement()) instanceof IWizardDescriptor) {
                    ExportWizardSelectionPage.this.setSelectedDescriptor((IWizardDescriptor)o);
                    ExportWizardSelectionPage.this.setTitle(ExportWizardSelectionPage.this.selectedWizardDescriptor.getLabel());
                }
            }
        });
        this.setControl((Control)composite);
    }

    protected void setSelectedDescriptor(IWizardDescriptor descriptor) {
        this.selectedWizardDescriptor = descriptor;
        if (this.isCurrentPage()) {
            this.getContainer().updateButtons();
        }
    }

    private void addSelectedDescriptor(IWizardDescriptor descriptor) {
        if (descriptor == null) {
            return;
        }
        if (selectedWizardDescriptors.contains(descriptor)) {
            return;
        }
        selectedWizardDescriptors.add(descriptor);
    }

    public boolean canFlipToNextPage() {
        return this.selectedWizardDescriptor != null;
    }

    public IWizardPage getNextPage() {
        if (this.selectedWizardDescriptor == null) {
            return null;
        }
        Wizard wizard = null;
        try {
            wizard = this.selectedWizardDescriptor.createWizard();
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        if (wizard == null) {
            this.setSelectedDescriptor(null);
            return null;
        }
        if (!selectedWizardDescriptors.contains(this.selectedWizardDescriptor)) {
            wizard.addPages();
            this.addSelectedDescriptor(this.selectedWizardDescriptor);
        }
        return wizard.getStartingPage();
    }
}

