/*
 * Decompiled with CFR 0.152.
 */
package at.medevit.elexis.ehc.ui.vacdoc.wizard;

import at.medevit.elexis.ehc.ui.extension.IImportWizard;
import at.medevit.elexis.ehc.ui.vacdoc.service.VacdocServiceComponent;
import at.medevit.elexis.ehc.ui.vacdoc.wizard.ImportVaccinationsWizardPage1;
import java.io.InputStream;
import java.util.Optional;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Shell;
import org.hl7.fhir.r4.model.Bundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImportVaccinationsWizard
extends Wizard
implements IImportWizard {
    public static Logger logger = LoggerFactory.getLogger(ImportVaccinationsWizard.class);
    private ImportVaccinationsWizardPage1 vaccinationsMainPage;
    private Bundle ehcDocument;

    public ImportVaccinationsWizard() {
        this.setWindowTitle("Impfungen import");
    }

    public boolean performFinish() {
        return this.vaccinationsMainPage.finish();
    }

    public void addPages() {
        super.addPages();
        this.vaccinationsMainPage = new ImportVaccinationsWizardPage1("Impfungen ausw\u00e4hlen", this.ehcDocument);
        this.addPage((IWizardPage)this.vaccinationsMainPage);
    }

    public void setDocument(InputStream document) {
        try {
            document.reset();
            Optional ehcDocumentOpt = VacdocServiceComponent.getService().loadVacdocDocument(document);
            ehcDocumentOpt.ifPresent(d -> {
                Bundle bundle = this.ehcDocument = d;
            });
        }
        catch (Exception e) {
            logger.error("Could not open document", (Throwable)e);
            MessageDialog.openError((Shell)this.getShell(), (String)"Fehler", (String)"Konnte das Dokument nicht \u00f6ffnen.");
        }
    }

    protected boolean isResizable() {
        return true;
    }
}

