/*
 * Decompiled with CFR 0.152.
 */
package at.medevit.elexis.ehc.ui.vacdoc.wizard;

import at.medevit.elexis.ehc.core.EhcCoreMapper;
import at.medevit.elexis.ehc.ui.vacdoc.service.VacdocServiceComponent;
import at.medevit.elexis.ehc.ui.vacdoc.wizard.ImportVaccinationsWizard;
import at.medevit.elexis.impfplan.model.po.Vaccination;
import ch.elexis.core.findings.util.fhir.MedicamentCoding;
import ch.elexis.core.ui.UiDesk;
import ch.elexis.data.Patient;
import ch.elexis.data.Query;
import ch.rgw.tools.TimeTool;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.hl7.fhir.r4.model.Bundle;
import org.hl7.fhir.r4.model.Coding;
import org.hl7.fhir.r4.model.Immunization;
import org.hl7.fhir.r4.model.Medication;

public class ImportVaccinationsWizardPage1
extends WizardPage {
    private TableViewer contentViewer;
    private Bundle ehcDocument;
    private List<Vaccination> vaccinations;

    protected ImportVaccinationsWizardPage1(String pageName, Bundle ehcDocument) {
        super(pageName);
        this.setTitle(pageName);
        this.ehcDocument = ehcDocument;
        if (ehcDocument != null) {
            Patient elexisPatient = EhcCoreMapper.getElexisPatient((Bundle)ehcDocument, (boolean)false);
            this.vaccinations = this.getVaccinations(elexisPatient);
        }
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(1808));
        this.contentViewer = new TableViewer(composite, 2818);
        Control control = this.contentViewer.getControl();
        GridData gd = new GridData(4, 4, true, true, 1, 1);
        gd.heightHint = 300;
        control.setLayoutData((Object)gd);
        this.contentViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.contentViewer.setLabelProvider((IBaseLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof Immunization) {
                    Immunization immunization = (Immunization)element;
                    return "(" + String.valueOf(immunization.getOccurrenceDateTimeType()) + ") " + immunization.getVaccineCode().getCodingFirstRep().getDisplay() + " - " + String.valueOf(immunization.getPerformerFirstRep());
                }
                return super.getText(element);
            }

            public Color getBackground(Object element) {
                Immunization immunization;
                if (element instanceof Immunization && ImportVaccinationsWizardPage1.this.isExisting(immunization = (Immunization)element, ImportVaccinationsWizardPage1.this.vaccinations)) {
                    return UiDesk.getColorFromRGB((String)"D3D3D3");
                }
                return super.getBackground(element);
            }

            public Image getImage(Object element) {
                return super.getImage(element);
            }
        });
        this.contentViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ImportVaccinationsWizardPage1.this.getWizard().getContainer().updateButtons();
            }
        });
        this.setControl((Control)composite);
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible && this.ehcDocument != null) {
            List immunizations = VacdocServiceComponent.getService().getImmunizations(this.ehcDocument);
            this.contentViewer.setInput((Object)immunizations);
        }
    }

    private List<Vaccination> getVaccinations(Patient elexisPatient) {
        Query qbe = new Query(Vaccination.class);
        qbe.add("ID", "<>", "VERSION");
        qbe.add("Patient_ID", "=", elexisPatient.getId());
        qbe.orderBy(false, new String[]{"dateOfAdministration"});
        return qbe.execute();
    }

    private boolean isExisting(Immunization immunization, List<Vaccination> vaccinations) {
        for (Vaccination vaccination : vaccinations) {
            Optional medication;
            TimeTool vaccDate;
            Date occurenceDate = (Date)immunization.getOccurrenceDateTimeType().getValue();
            if (!occurenceDate.equals((vaccDate = vaccination.getDateOfAdministration()).getTime())) continue;
            String gtin = vaccination.get("ean");
            Optional<Coding> gtinCoding = immunization.getVaccineCode().getCoding().stream().filter(c -> MedicamentCoding.GTIN.isCodeSystemOf(c)).findFirst();
            if (!(gtinCoding.isPresent() ? gtinCoding.isPresent() && gtinCoding.get().getCode().equals(gtin) : (medication = VacdocServiceComponent.getService().getMedication(immunization)).isPresent() && (gtinCoding = ((Medication)medication.get()).getCode().getCoding().stream().filter(c -> MedicamentCoding.GTIN.isCodeSystemOf(c)).findFirst()).isPresent() && gtinCoding.get().getCode().equals(gtin))) continue;
            return immunization.getLotNumber().equalsIgnoreCase(vaccination.getLotNo());
        }
        return false;
    }

    public boolean isPageComplete() {
        IStructuredSelection contentSelection = (IStructuredSelection)this.contentViewer.getSelection();
        return !contentSelection.isEmpty();
    }

    private List<Immunization> getSelectedImmunizations() {
        IStructuredSelection contentSelection = (IStructuredSelection)this.contentViewer.getSelection();
        if (!contentSelection.isEmpty()) {
            List immunizations = contentSelection.toList();
            return immunizations.stream().filter(i -> !this.isExisting((Immunization)i, this.vaccinations)).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    public boolean finish() {
        try {
            Patient elexisPatient = EhcCoreMapper.getElexisPatient((Bundle)this.ehcDocument, (boolean)false);
            VacdocServiceComponent.getService().importImmunizations(elexisPatient, this.getSelectedImmunizations());
        }
        catch (Exception e) {
            ImportVaccinationsWizard.logger.error("Import failed.", (Throwable)e);
            MessageDialog.openError((Shell)this.getShell(), (String)"Error", (String)"Es ist ein Fehler beim Impfungen importieren aufgetreten.");
            return false;
        }
        return true;
    }
}

