/*
 * Decompiled with CFR 0.152.
 */
package at.medevit.elexis.bluemedication.ui.handler;

import at.medevit.elexis.bluemedication.core.BlueMedicationServiceHolder;
import at.medevit.elexis.bluemedication.core.UploadResult;
import ch.elexis.omnivore.data.Utils;
import ch.elexis.omnivore.model.IDocumentHandle;
import ch.rgw.tools.Result;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.List;
import java.util.function.Consumer;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.commands.NotEnabledException;
import org.eclipse.core.commands.NotHandledException;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.core.commands.common.NotDefinedException;
import org.eclipse.core.expressions.EvaluationContext;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.services.IEvaluationService;
import org.slf4j.LoggerFactory;

public class BlueMedicationUploadHandler
extends AbstractHandler
implements IHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        IDocumentHandle docHandle;
        Object object;
        StructuredSelection selection = (StructuredSelection)HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        final String resulttyp = event.getParameter("at.medevit.elexis.bluemedication.ui.resulttyp");
        if (!selection.isEmpty() && (object = selection.getFirstElement()) instanceof IDocumentHandle && ((docHandle = (IDocumentHandle)object).getMimeType().toLowerCase().endsWith("pdf") || docHandle.getTitle().toLowerCase().endsWith(".pdf"))) {
            Shell activeshell = HandlerUtil.getActiveShell((ExecutionEvent)event);
            ProgressMonitorDialog progressDialog = new ProgressMonitorDialog(activeshell);
            try {
                progressDialog.run(true, false, new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                        monitor.beginTask("BlueMedication Upload von " + docHandle.getLabel(), -1);
                        Result result = BlueMedicationServiceHolder.getService().uploadDocument(docHandle.getPatient(), Utils.createTemporaryFile((IDocumentHandle)docHandle, (String)docHandle.getTitle()), resulttyp);
                        if (result.isOK()) {
                            Display.getDefault().syncExec(() -> {
                                Program.launch((String)((UploadResult)result.get()).getUrl());
                                BlueMedicationServiceHolder.getService().addPendingUploadResult((Object)docHandle, (UploadResult)result.get());
                                BlueMedicationServiceHolder.getService().startPollForResult((Object)docHandle, (UploadResult)result.get(), (Consumer)new Consumer<Object>(){

                                    @Override
                                    public void accept(Object object) {
                                        Display.getDefault().asyncExec(() -> BlueMedicationUploadHandler.this.download(object));
                                    }
                                });
                            });
                        } else {
                            String resultCode;
                            String text;
                            List messages = result.getMessages();
                            if (messages != null && !messages.isEmpty() && StringUtils.isNotBlank((CharSequence)(text = ((Result.msg)messages.get(0)).getText())) && text.startsWith("Error result code [") && StringUtils.isNotBlank((CharSequence)(resultCode = text.substring(text.indexOf(91) + 1, text.indexOf(93))))) {
                                if ("A6".equals(resultCode)) {
                                    Display.getDefault().syncExec(() -> MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"BlueMedication", (String)"Der Medikationsabgleich kann in BlueMedication nicht durchgef\u00fchrt werden.\nBitte melden Sie den Fehler A6 an help.bluemedication@bluecare.ch"));
                                } else {
                                    Display.getDefault().syncExec(() -> MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"BlueMedication", (String)("Beim Aufruf von BlueMedication ist ein technischer Fehler aufgetreten\nBitte melden Sie den Fehler " + resultCode + " an help.bluemedication@bluecare.ch")));
                                }
                                return;
                            }
                            Display.getDefault().syncExec(() -> MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"BlueMedication", (String)"Beim Hochladen der Datei ist ein Fehler aufgetreten.\n\nBitte HIN client Konfiguration pr\u00fcfen."));
                        }
                    }
                });
            }
            catch (InterruptedException | InvocationTargetException e) {
                MessageDialog.openError((Shell)activeshell, (String)"BlueMedication", (String)"BlueMedication Upload konnte nicht gestartet werden.");
                LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Error on upload", (Throwable)e);
            }
        }
        return null;
    }

    private void download(Object object) {
        ICommandService commandService = (ICommandService)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getService(ICommandService.class);
        IEvaluationService evaluationService = (IEvaluationService)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getService(IEvaluationService.class);
        EvaluationContext context = new EvaluationContext(evaluationService.getCurrentState(), evaluationService.getCurrentState().getDefaultVariable());
        context.addVariable("selection", (Object)new StructuredSelection(object));
        Command downloadCommand = commandService.getCommand("at.medevit.elexis.emediplan.ui.blueMedicationDownload");
        HashMap params = new HashMap();
        ParameterizedCommand parametrizedCommmand = ParameterizedCommand.generateCommand((Command)downloadCommand, params);
        try {
            ((IHandlerService)PlatformUI.getWorkbench().getService(IHandlerService.class)).executeCommandInContext(parametrizedCommmand, null, (IEvaluationContext)context);
        }
        catch (ExecutionException | NotEnabledException | NotHandledException | NotDefinedException e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Error on download", e);
            MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"Fehler", (String)"Beim automatischen Download ist ein Fehler aufgetreten. Bitte starten sie den Abgleich neu.");
        }
    }
}

