/*
 * Decompiled with CFR 0.152.
 */
package at.medevit.elexis.bluemedication.core.internal;

import at.medevit.ch.artikelstamm.IArtikelstammItem;
import at.medevit.elexis.bluemedication.core.BlueMedicationService;
import at.medevit.elexis.bluemedication.core.UploadResult;
import at.medevit.elexis.emediplan.core.EMediplanService;
import at.medevit.elexis.hin.auth.core.IHinAuthService;
import ch.elexis.core.data.service.ContextServiceHolder;
import ch.elexis.core.model.IArticle;
import ch.elexis.core.model.IDocument;
import ch.elexis.core.model.IMandator;
import ch.elexis.core.model.IPatient;
import ch.elexis.core.model.IPrescription;
import ch.elexis.core.model.prescription.EntryType;
import ch.elexis.core.services.holder.ConfigServiceHolder;
import ch.elexis.core.utils.OsgiServiceUtil;
import ch.rgw.tools.Result;
import com.google.gson.Gson;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Type;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import okhttp3.OkHttpClient;
import okhttp3.Response;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicHeader;
import org.openapitools.client.ApiClient;
import org.openapitools.client.ApiException;
import org.openapitools.client.ApiResponse;
import org.openapitools.client.api.EMediplanGenerationApi;
import org.openapitools.client.api.ExtractionAndConsolidationApi;
import org.openapitools.client.api.MediCheckApi;
import org.openapitools.client.model.ErrorResult;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(property={"event.topics=info/elexis/emediplan/ui/create"})
public class BlueMedicationServiceImpl
implements BlueMedicationService,
EventHandler {
    private static Logger logger = LoggerFactory.getLogger(BlueMedicationServiceImpl.class);
    private boolean proxyActive;
    private String oldProxyHost;
    private String oldProxyPort;
    private Map<Object, UploadResult> pendingUploadResults;
    private ExecutorService executor;
    @Reference
    private EMediplanService eMediplanService;
    private Optional<IHinAuthService> hinAuthService;

    @Activate
    public void activate() {
        this.pendingUploadResults = new HashMap<Object, UploadResult>();
        this.executor = Executors.newCachedThreadPool();
    }

    private void initProxyOrOauth() {
        if (this.hinAuthService == null) {
            this.hinAuthService = OsgiServiceUtil.getService(IHinAuthService.class);
        }
    }

    @Override
    public Result<UploadResult> uploadDocument(IPatient patient, File document, String resulttyp) {
        this.initProxyOrOauth();
        this.workaroundGet();
        ExtractionAndConsolidationApi apiInstance = new ExtractionAndConsolidationApi();
        this.configureApiClient(apiInstance.getApiClient());
        File externalData = document;
        String patientFirstName = patient.getFirstName();
        String patientLastName = patient.getLastName();
        String patientSex = patient.getGender().name();
        LocalDate patientBirthdate = LocalDate.now();
        try {
            ApiResponse response;
            IMandator mandant;
            boolean uploadedMediplan = false;
            File internalData = null;
            if ("chmed".equals(resulttyp) && this.useRemoteImport() && this.hasPrescriptionsWithValidIdType(patient) && (mandant = (IMandator)ContextServiceHolder.get().getActiveMandator().orElse(null)) != null) {
                try {
                    ByteArrayOutputStream pdfOutput = new ByteArrayOutputStream();
                    this.eMediplanService.exportEMediplanPdf(mandant, patient, this.getPrescriptions(patient, "all"), true, (OutputStream)pdfOutput);
                    File pdfFile = File.createTempFile("eMediplan_" + System.currentTimeMillis(), ".pdf");
                    Throwable throwable = null;
                    Object var16_22 = null;
                    try (FileOutputStream fos = new FileOutputStream(pdfFile);){
                        fos.write(pdfOutput.toByteArray());
                        fos.flush();
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                    internalData = pdfFile;
                    uploadedMediplan = true;
                }
                catch (IOException e) {
                    logger.error("Error creating eMediplan", (Throwable)e);
                    return new Result(Result.SEVERITY.ERROR, 0, e.getMessage(), null, false);
                }
            }
            if ((response = apiInstance.dispatchPostWithHttpInfo(externalData, internalData, patientFirstName, patientLastName, patientSex, DateTimeFormatter.ofPattern("dd.MM.yyyy").format(patientBirthdate), "", "", "", "", "")).getStatusCode() >= 300) {
                return new Result(Result.SEVERITY.ERROR, 0, "Response status code was [" + response.getStatusCode() + "]", null, false);
            }
            if (response.getData() == null) {
                return new Result(Result.SEVERITY.ERROR, 0, "Response has no data", null, false);
            }
            org.openapitools.client.model.UploadResult data = (org.openapitools.client.model.UploadResult)response.getData();
            return new Result((Object)new UploadResult(this.appendPath(this.getBrowserBasePath(), data.getUrl() + "&mode=embed"), data.getId(), resulttyp, uploadedMediplan));
        }
        catch (ApiException e) {
            this.hinAuthHandleException(e);
            if (e.getCode() == 400 || e.getCode() == 422) {
                try {
                    Gson gson = new Gson();
                    ErrorResult[] mcArray = (ErrorResult[])gson.fromJson(e.getResponseBody(), ErrorResult[].class);
                    if (mcArray != null && mcArray.length > 0) {
                        return new Result(Result.SEVERITY.ERROR, 0, "Error result code [" + mcArray[0].getCode() + "]", null, false);
                    }
                }
                catch (Exception je) {
                    logger.warn("Could not parse code 400 exception content [" + e.getResponseBody() + "]");
                }
            }
            logger.error("Error uploading Document", (Throwable)e);
            return new Result(Result.SEVERITY.ERROR, 0, e.getMessage(), null, false);
        }
    }

    private void hinAuthHandleException(ApiException e) {
        Optional message;
        if (this.hinAuthService.isPresent() && (message = this.hinAuthService.get().handleException((Exception)((Object)e), Collections.singletonMap("token_group", this.getTokenGroup()))).isPresent()) {
            logger.warn("HIN Auth message", message.get());
        }
    }

    private void configureApiClient(ApiClient client) {
        Optional authToken;
        client.setBasePath(this.getAppBasePath());
        if (this.hinAuthService.isPresent() && (authToken = this.hinAuthService.get().getToken(Collections.singletonMap("token_group", this.getTokenGroup()))).isPresent()) {
            client.addDefaultHeader("Authorization", "Bearer " + (String)authToken.get());
        }
    }

    private String getTokenGroup() {
        if (ConfigServiceHolder.getGlobal((String)"at.medevit.elexis.emediplan/bluemedication/staging", (boolean)false)) {
            return "bluecare_bluemedication_staging";
        }
        return "bluecare_bluemedication";
    }

    @Override
    public Result<UploadResult> uploadCheck(IPatient patient) {
        this.initProxyOrOauth();
        this.workaroundGet();
        try {
            CheckApiClient client = new CheckApiClient();
            this.configureApiClient(client);
            MediCheckApi apiInstance = new MediCheckApi((ApiClient)client);
            IMandator mandant = ContextServiceHolder.get().getActiveMandator().orElse(null);
            if (mandant != null) {
                try {
                    File tmpFile = File.createTempFile("bluemedication" + System.currentTimeMillis(), ".tmp");
                    Throwable throwable = null;
                    Object var7_13 = null;
                    try (FileOutputStream fout = new FileOutputStream(tmpFile);){
                        this.eMediplanService.exportEMediplanChmed(mandant, patient, this.getPrescriptions(patient, "all"), true, (OutputStream)fout);
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                    apiInstance.checkPostWithHttpInfo(tmpFile);
                    if (client.getRedirectUrl() != null) {
                        return new Result((Object)new UploadResult(client.getRedirectUrl(), "", "check", true));
                    }
                    return new Result(Result.SEVERITY.ERROR, 0, "No redirect", null, false);
                }
                catch (IOException e) {
                    logger.error("Error creating eMediplan", (Throwable)e);
                    return new Result(Result.SEVERITY.ERROR, 0, e.getMessage(), null, false);
                }
            }
            return new Result(Result.SEVERITY.ERROR, 0, "No active mandator", null, false);
        }
        catch (ApiException e) {
            this.hinAuthHandleException(e);
            if (e.getCode() == 400 || e.getCode() == 422) {
                try {
                    Gson gson = new Gson();
                    ErrorResult[] mcArray = (ErrorResult[])gson.fromJson(e.getResponseBody(), ErrorResult[].class);
                    if (mcArray != null && mcArray.length > 0) {
                        return new Result(Result.SEVERITY.ERROR, 0, "Error result code [" + mcArray[0].getCode() + "]", null, false);
                    }
                }
                catch (Exception je) {
                    logger.warn("Could not parse code 400 exception content [" + e.getResponseBody() + "]");
                }
            }
            logger.error("Error uploading Document", (Throwable)e);
            return new Result(Result.SEVERITY.ERROR, 0, e.getMessage(), null, false);
        }
    }

    @Override
    public Result<String> emediplanNotification(IPatient patient) {
        this.initProxyOrOauth();
        this.workaroundGet();
        try {
            EMediplanGenerationApi apiInstance = new EMediplanGenerationApi();
            this.configureApiClient(apiInstance.getApiClient());
            LocalDateTime patBirthDay = patient.getDateOfBirth();
            LocalDate birthDate = patBirthDay != null ? LocalDate.of(patBirthDay.getYear(), patBirthDay.getMonthValue(), patBirthDay.getDayOfMonth()) : null;
            ApiResponse response = apiInstance.notificationEmediplanPostWithHttpInfo(patient.getFirstName(), patient.getLastName(), patient.getGender().name(), DateTimeFormatter.ofPattern("dd.MM.yyyy").format(birthDate));
            return Result.OK((String)response.toString());
        }
        catch (ApiException e) {
            this.hinAuthHandleException(e);
            if (e.getCode() == 400 || e.getCode() == 422) {
                try {
                    Gson gson = new Gson();
                    ErrorResult[] mcArray = (ErrorResult[])gson.fromJson(e.getResponseBody(), ErrorResult[].class);
                    if (mcArray != null && mcArray.length > 0) {
                        return new Result(Result.SEVERITY.ERROR, 0, "Error result code [" + mcArray[0].getCode() + "]", null, false);
                    }
                }
                catch (Exception je) {
                    logger.warn("Could not parse code 400 exception content [" + e.getResponseBody() + "]");
                }
            }
            logger.error("Error performing notification", (Throwable)e);
            return new Result(Result.SEVERITY.ERROR, 0, e.getMessage(), null, false);
        }
    }

    private void workaroundGet() {
        try {
            ExtractionAndConsolidationApi apiInstance = new ExtractionAndConsolidationApi();
            apiInstance.getApiClient().setBasePath(this.getAppBasePath());
            this.configureApiClient(apiInstance.getApiClient());
            logger.warn("Performing workaround GET request");
            apiInstance.downloadIdComparisonChmedGet("workaround", Boolean.valueOf(false));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private String appendPath(String pathStart, String pathEnd) {
        if (pathStart.endsWith("/") || pathEnd.startsWith("/")) {
            return pathStart + pathEnd;
        }
        if (pathStart.endsWith("/") && pathEnd.startsWith("/")) {
            return pathStart + pathEnd.substring(1);
        }
        return pathStart + "/" + pathEnd;
    }

    private String getBasePath() {
        if (this.hinAuthService.isPresent()) {
            if (ConfigServiceHolder.getGlobal((String)"at.medevit.elexis.emediplan/bluemedication/staging", (boolean)false)) {
                return "https://oauth2.staging.bluemedication.hin.ch";
            }
            return "https://oauth2.bluemedication.hin.ch";
        }
        if (ConfigServiceHolder.getGlobal((String)"at.medevit.elexis.emediplan/bluemedication/staging", (boolean)false)) {
            return "http://staging.bluemedication.hin.ch";
        }
        return "http://bluemedication.hin.ch";
    }

    private String getBrowserBasePath() {
        if (ConfigServiceHolder.getGlobal((String)"at.medevit.elexis.emediplan/bluemedication/staging", (boolean)false)) {
            return "http://staging.bluemedication.hin.ch";
        }
        return "http://bluemedication.hin.ch";
    }

    private String getAppBasePath() {
        return this.appendPath(this.getBasePath(), "/api/v1");
    }

    @Override
    public Result<String> downloadEMediplan(UploadResult uploadResult) {
        this.initProxyOrOauth();
        try {
            ExtractionAndConsolidationApi apiInstance = new ExtractionAndConsolidationApi();
            this.configureApiClient(apiInstance.getApiClient());
            if (uploadResult.isUploadedMediplan()) {
                ApiResponse response = apiInstance.downloadIdComparisonChmedGetWithHttpInfo(uploadResult.getId(), Boolean.valueOf(true));
                if (response.getStatusCode() >= 300) {
                    return Result.ERROR((String)("Response status code was [" + response.getStatusCode() + "]"));
                }
                if (response.getData() == null) {
                    return Result.ERROR((String)"Response has no data");
                }
                return Result.OK((String)((String)response.getData()));
            }
            ApiResponse response = apiInstance.downloadIdExtractionChmedGetWithHttpInfo(uploadResult.getId(), Boolean.valueOf(true));
            if (response.getStatusCode() >= 300) {
                return Result.ERROR((String)("Response status code was [" + response.getStatusCode() + "]"));
            }
            if (response.getData() == null) {
                return Result.ERROR((String)"Response has no data");
            }
            return Result.OK((String)((String)response.getData()));
        }
        catch (ApiException e) {
            this.hinAuthHandleException(e);
            logger.error("Error downloading Document", (Throwable)e);
            return Result.ERROR((String)e.getMessage());
        }
    }

    @Override
    public Result<String> downloadPdf(UploadResult uploadResult) {
        this.initProxyOrOauth();
        try {
            ExtractionAndConsolidationApi apiInstance = new ExtractionAndConsolidationApi();
            this.configureApiClient(apiInstance.getApiClient());
            ApiResponse response = apiInstance.downloadIdExtractionGetWithHttpInfo(uploadResult.getId(), Boolean.valueOf(true));
            if (response.getStatusCode() >= 300) {
                return Result.ERROR((String)("Response status code was [" + response.getStatusCode() + "]"));
            }
            if (response.getData() == null) {
                return Result.ERROR((String)"Response has no data");
            }
            return Result.OK((String)((File)response.getData()).getAbsolutePath());
        }
        catch (ApiException e) {
            this.hinAuthHandleException(e);
            logger.error("Error downloading Document Pdf", (Throwable)e);
            return Result.ERROR((String)e.getMessage());
        }
    }

    @Override
    public Result<String> downloadExtendedPdf(UploadResult uploadResult) {
        this.initProxyOrOauth();
        try {
            ExtractionAndConsolidationApi apiInstance = new ExtractionAndConsolidationApi();
            this.configureApiClient(apiInstance.getApiClient());
            ApiResponse response = apiInstance.downloadIdExtractionExtendedpdfGetWithHttpInfo(uploadResult.getId(), Boolean.valueOf(true));
            if (response.getStatusCode() >= 300) {
                return Result.ERROR((String)("Response status code was [" + response.getStatusCode() + "]"));
            }
            if (response.getData() == null) {
                return Result.ERROR((String)"Response has no data");
            }
            return Result.OK((String)((File)response.getData()).getAbsolutePath());
        }
        catch (ApiException e) {
            this.hinAuthHandleException(e);
            logger.error("Error downloading Document Pdf", (Throwable)e);
            return Result.ERROR((String)e.getMessage());
        }
    }

    @Override
    public void addPendingUploadResult(Object object, UploadResult uploadResult) {
        this.pendingUploadResults.put(object, uploadResult);
    }

    @Override
    public Optional<UploadResult> getPendingUploadResult(Object object) {
        return Optional.ofNullable(this.pendingUploadResults.get(object));
    }

    @Override
    public void removePendingUploadResult(Object object) {
        this.pendingUploadResults.remove(object);
    }

    private boolean useRemoteImport() {
        return ConfigServiceHolder.getGlobal((String)"at.medevit.elexis.emediplan/bluemedication/useimport", (boolean)false);
    }

    private boolean hasPrescriptionsWithValidIdType(IPatient patient) {
        List<IPrescription> allPrescriptions = this.getPrescriptions(patient, "all");
        List nonValidIdPrescriptions = allPrescriptions.stream().filter(p -> this.getIdType(p.getArticle()) == 1).collect(Collectors.toList());
        return nonValidIdPrescriptions.isEmpty();
    }

    private List<IPrescription> getPrescriptions(IPatient patient, String medicationType) {
        if ("all".equals(medicationType)) {
            return patient.getMedication(Arrays.asList(EntryType.FIXED_MEDICATION, EntryType.RESERVE_MEDICATION, EntryType.SYMPTOMATIC_MEDICATION));
        }
        if ("fix".equals(medicationType)) {
            return patient.getMedication(Arrays.asList(EntryType.FIXED_MEDICATION));
        }
        if ("reserve".equals(medicationType)) {
            return patient.getMedication(Arrays.asList(EntryType.RESERVE_MEDICATION));
        }
        if ("symptomatic".equals(medicationType)) {
            return patient.getMedication(Arrays.asList(EntryType.SYMPTOMATIC_MEDICATION));
        }
        return Collections.emptyList();
    }

    private int getIdType(IArticle article) {
        if (article != null) {
            String gtin = article.getGtin();
            if (gtin != null && !gtin.isEmpty() && gtin.startsWith("76")) {
                return 2;
            }
            String pharma = null;
            if (article instanceof IArtikelstammItem) {
                pharma = ((IArtikelstammItem)article).getPHAR();
            }
            if (StringUtils.isNotBlank(pharma)) {
                return 3;
            }
        }
        return 1;
    }

    @Override
    public void startPollForResult(Object object, UploadResult uploadResult, Consumer<Object> onSuccess) {
        this.executor.execute(() -> {
            Optional authToken;
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            logger.info("Start polling for [" + uploadResult.getId() + "]");
            ArrayList<BasicHeader> headers = new ArrayList<BasicHeader>();
            if (this.hinAuthService.isPresent() && (authToken = this.hinAuthService.get().getToken(Collections.singletonMap("token_group", "BlueMedication"))).isPresent()) {
                headers.add(new BasicHeader("Authorization", "Bearer " + (String)authToken.get()));
            }
            CloseableHttpClient httpclient = HttpClients.custom().setDefaultHeaders(headers).build();
            HttpGet httpget = new HttpGet(this.getAppBasePath() + "/status/" + uploadResult.getId());
            int maxRetry = 30;
            int statusCode = 204;
            String content = null;
            try {
                while (statusCode == 204 && maxRetry > 0) {
                    HttpResponse response = httpclient.execute((HttpUriRequest)httpget);
                    statusCode = response.getStatusLine().getStatusCode();
                    if (response.getEntity() != null) {
                        content = IOUtils.toString((InputStream)response.getEntity().getContent(), (String)"UTF-8");
                    }
                    --maxRetry;
                }
            }
            catch (IOException e) {
                logger.error("Error performing polling for [" + uploadResult.getId() + "]", (Throwable)e);
                return;
            }
            if (statusCode == 200) {
                if (content != null && content.contains("COMPLETED")) {
                    logger.info("Finished [" + uploadResult.getId() + "] completed");
                    onSuccess.accept(object);
                } else {
                    logger.info("Finished [" + uploadResult.getId() + "] not completed");
                    this.removePendingUploadResult(object);
                }
            } else {
                logger.warn("Got response code [" + statusCode + "] for [" + uploadResult.getId() + "] clearing pending upload");
                this.removePendingUploadResult(object);
            }
        });
    }

    public void handleEvent(Event event) {
        IPatient patient;
        Object property = event.getProperty("org.eclipse.e4.data");
        if (property instanceof IDocument && (patient = ((IDocument)property).getPatient()) != null) {
            this.emediplanNotification(patient);
        }
    }

    private class CheckApiClient
    extends ApiClient {
        private String redirectUrl;

        public CheckApiClient() {
            super(new OkHttpClient.Builder().followRedirects(false).followSslRedirects(false).build());
        }

        public String selectHeaderContentType(String[] contentTypes) {
            return "application/x-chmed16a";
        }

        public <T> T handleResponse(Response response, Type returnType) throws ApiException {
            if (response.code() == 302) {
                this.redirectUrl = response.header("Location", null);
                return null;
            }
            throw new ApiException(response.message(), response.code(), response.headers().toMultimap(), null);
        }

        public String getRedirectUrl() {
            return this.redirectUrl;
        }
    }
}

