/*
 * Decompiled with CFR 0.152.
 */
package at.medevit.elexis.agenda.ui.xml;

import at.medevit.elexis.agenda.ui.xml.Period;
import ch.elexis.core.model.IAppointment;
import ch.elexis.core.model.IPeriod;
import ch.elexis.core.services.holder.AppointmentServiceHolder;
import ch.elexis.core.types.AppointmentType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

@XmlRootElement
public class AreaPeriodsLetter {
    private List<Period> period;
    @XmlElement
    private String area;
    @XmlElement
    private String areaPeriod;

    public static AreaPeriodsLetter of(String area, List<IPeriod> areaPeriods) {
        AreaPeriodsLetter ret = new AreaPeriodsLetter();
        ret.area = area;
        ret.period = areaPeriods.stream().filter(ap -> !AreaPeriodsLetter.isDayLimit(ap)).map(ap -> Period.of(ap)).collect(Collectors.toList());
        Collections.sort(ret.period);
        if (!ret.period.isEmpty()) {
            LocalDate toLocalDate;
            LocalDate fromLocalDate = ret.period.get(0).getFromDateTime().toLocalDate();
            ret.areaPeriod = fromLocalDate.equals(toLocalDate = ret.period.get(ret.period.size() - 1).getFromDateTime().toLocalDate()) ? fromLocalDate.format(DateTimeFormatter.ofPattern("dd.MM.yyyy")) : fromLocalDate.format(DateTimeFormatter.ofPattern("dd.MM.yyyy")) + " - " + toLocalDate.format(DateTimeFormatter.ofPattern("dd.MM.yyyy"));
        }
        return ret;
    }

    public static boolean isDayLimit(IPeriod iPeriod) {
        if (iPeriod instanceof IAppointment) {
            String type = ((IAppointment)iPeriod).getType();
            String reservedTypeString = AppointmentServiceHolder.get().getType(AppointmentType.BOOKED);
            return type.equals(reservedTypeString);
        }
        return false;
    }

    public void setPeriod(List<Period> period) {
        this.period = period;
    }

    public List<Period> getPeriod() {
        return this.period;
    }

    public String getArea() {
        return this.area;
    }
}

