/*
 * Decompiled with CFR 0.152.
 */
package at.medevit.elexis.agenda.ui.function;

import at.medevit.elexis.agenda.ui.composite.ScriptingHelper;
import ch.elexis.core.model.IAppointment;
import ch.elexis.core.model.IAppointmentSeries;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.services.holder.AppointmentHistoryServiceHolder;
import ch.elexis.core.services.holder.AppointmentServiceHolder;
import ch.elexis.core.services.holder.CoreModelServiceHolder;
import ch.elexis.core.ui.e4.locks.AcquireLockBlockingUi;
import ch.elexis.core.ui.e4.locks.ILockHandler;
import ch.elexis.dialogs.AppointmentDialog;
import ch.elexis.dialogs.RecurringAppointmentDialog;
import com.equo.chromium.swt.Browser;
import com.equo.chromium.swt.BrowserFunction;

public class DoubleClickFunction
extends BrowserFunction {
    public DoubleClickFunction(Browser browser, String name) {
        super(browser, name);
    }

    public Object function(Object[] arguments) {
        if (arguments.length == 1) {
            final IAppointment termin = CoreModelServiceHolder.get().load((String)arguments[0], IAppointment.class).orElse(null);
            if (termin != null) {
                AcquireLockBlockingUi.aquireAndRun((Identifiable)termin, (ILockHandler)new ILockHandler(){

                    public void lockFailed() {
                    }

                    public void lockAcquired() {
                        if (termin.isRecurring()) {
                            RecurringAppointmentDialog dlg = new RecurringAppointmentDialog((IAppointmentSeries)AppointmentServiceHolder.get().getAppointmentSeries(termin).get());
                            if (dlg.open() == 0) {
                                AppointmentHistoryServiceHolder.get().logAppointmentEdit(termin);
                            }
                        } else {
                            AppointmentDialog dlg = new AppointmentDialog(termin);
                            dlg.setShowAllDay(true);
                            if (dlg.open() == 0) {
                                AppointmentHistoryServiceHolder.get().logAppointmentEdit(termin);
                            }
                        }
                    }
                });
            } else {
                new ScriptingHelper(this.getBrowser()).refetchEvents();
            }
        }
        return null;
    }
}

