/*
 * Decompiled with CFR 0.152.
 */
package at.medevit.elexis.agenda.ui.view;

import at.medevit.elexis.agenda.ui.composite.ParallelComposite;
import at.medevit.elexis.agenda.ui.composite.SideBarComposite;
import at.medevit.elexis.agenda.ui.composite.WeekComposite;
import at.medevit.elexis.agenda.ui.function.LoadEventsFunction;
import ch.elexis.core.model.IAppointment;
import ch.elexis.core.ui.e4.util.CoreUiUtil;
import jakarta.annotation.PostConstruct;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.ui.di.Focus;
import org.eclipse.e4.ui.di.UIEventTopic;
import org.eclipse.e4.ui.di.UISynchronize;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.services.EMenuService;
import org.eclipse.e4.ui.workbench.modeling.ESelectionService;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public class AgendaView {
    private Composite container;
    private Composite parallelParent;
    private ParallelComposite parallelComposite;
    private Composite weekParent;
    private WeekComposite weekComposite;
    private StackLayout stackLayout;
    private SideBarComposite parallelSideBar;
    private SideBarComposite weekSideBar;

    @Inject
    @Optional
    public void reload(@UIEventTopic(value="info/elexis/model/reload") Class<?> clazz) {
        if (IAppointment.class.equals(clazz)) {
            if (this.parallelComposite != null && !this.parallelComposite.isDisposed()) {
                this.parallelComposite.refetchEvents();
            }
            if (this.weekComposite != null && !this.weekComposite.isDisposed()) {
                this.weekComposite.refetchEvents();
            }
        }
    }

    @PostConstruct
    public void createPartControl(MPart part, ESelectionService selectionService, EMenuService menuService, Composite parent, UISynchronize uiSynchronize) {
        this.container = new Composite(parent, 0);
        this.stackLayout = new StackLayout();
        this.container.setLayout((Layout)this.stackLayout);
        this.weekParent = new Composite(this.container, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = 0;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.weekParent.setLayout((Layout)layout);
        this.weekSideBar = new SideBarComposite(this.weekParent, 0);
        this.weekSideBar.setLayoutData(new GridData(16384, 4, false, true));
        this.weekComposite = new WeekComposite(part, selectionService, menuService, this.weekParent, 0, true, uiSynchronize);
        this.weekComposite.setLayoutData(new GridData(4, 4, true, true));
        CoreUiUtil.injectServicesWithContext((Object)this.weekComposite);
        this.weekSideBar.setAgendaComposite(this.weekComposite);
        this.parallelParent = new Composite(this.container, 0);
        layout = new GridLayout(2, false);
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = 0;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.parallelParent.setLayout((Layout)layout);
        this.parallelSideBar = new SideBarComposite(this.parallelParent, true, 0);
        this.parallelSideBar.setLayoutData(new GridData(16384, 4, false, true));
        this.parallelComposite = new ParallelComposite(part, selectionService, menuService, this.parallelParent, 0, true, uiSynchronize);
        CoreUiUtil.injectServicesWithContext((Object)this.parallelComposite);
        this.parallelComposite.setLayoutData(new GridData(4, 4, true, true));
        this.parallelSideBar.setAgendaComposite(this.parallelComposite);
        this.setTopControl("parallel");
    }

    @Focus
    public void setFocus() {
        if (this.container != null && !this.container.isDisposed()) {
            this.container.setFocus();
        }
    }

    public void setTopControl(String name) {
        if ("parallel".equalsIgnoreCase(name)) {
            this.stackLayout.topControl = this.parallelParent;
        } else if ("week".equalsIgnoreCase(name)) {
            this.stackLayout.topControl = this.weekParent;
        }
        this.container.layout();
    }

    public SideBarComposite getParallelSideBarComposite() {
        return this.parallelSideBar;
    }

    public LoadEventsFunction getLoadEventsFunction() {
        if (this.stackLayout.topControl == this.parallelParent) {
            return this.parallelComposite.getLoadEventsFunction();
        }
        if (this.stackLayout.topControl == this.weekParent) {
            return this.weekComposite.getLoadEventsFunction();
        }
        return null;
    }

    @Optional
    @Inject
    public void setFixLayout(MPart part, @Named(value="perspectives/fix_layout") boolean currentState) {
        CoreUiUtil.updateFixLayout((MPart)part, (boolean)currentState);
    }
}

