/*
 * Decompiled with CFR 0.152.
 */
package at.medevit.elexis.agenda.ui.handler;

import at.medevit.elexis.agenda.ui.composite.SideBarComposite;
import at.medevit.elexis.agenda.ui.function.AbstractBrowserFunction;
import at.medevit.elexis.agenda.ui.handler.CopyHandler;
import ch.elexis.agenda.composite.AppointmentDetailComposite;
import ch.elexis.core.model.IAppointment;
import ch.elexis.core.model.IPeriod;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.services.IAppointmentService;
import ch.elexis.core.services.handler.AppointmentExtensionHandler;
import ch.elexis.core.services.holder.AppointmentHistoryServiceHolder;
import ch.elexis.core.services.holder.AppointmentServiceHolder;
import ch.elexis.core.services.holder.ContextServiceHolder;
import ch.elexis.core.services.holder.CoreModelServiceHolder;
import ch.elexis.dialogs.AppointmentLinkOptionsDialog;
import jakarta.inject.Inject;
import java.time.Duration;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.slf4j.LoggerFactory;

public class InsertHandler {
    @Inject
    private IEventBroker eventBroker;

    @Execute
    public Object execute(MPart part) {
        Optional<SideBarComposite> activeSideBar = AbstractBrowserFunction.getActiveSideBar(part);
        activeSideBar.ifPresent(sideBar -> {
            Optional<IAppointment> copiedAppointment = CopyHandler.getCopiedAppointment();
            if (copiedAppointment.isPresent()) {
                this.handleCopiedAppointment((SideBarComposite)((Object)sideBar), copiedAppointment.get());
            } else {
                sideBar.getMoveInformation().ifPresent(this::handleMoveInformation);
            }
        });
        return null;
    }

    private void handleCopiedAppointment(SideBarComposite sideBar, IAppointment copiedAppointment) {
        Optional<SideBarComposite.MoveInformation> moveInfoOpt = sideBar.getMoveInformation();
        if (moveInfoOpt.isPresent()) {
            SideBarComposite.MoveInformation moveInfo = moveInfoOpt.get();
            LocalDateTime targetTime = moveInfo.getDateTime();
            String targetResource = moveInfo.getResource();
            List linkedAppointments = AppointmentExtensionHandler.getLinkedAppointments((IAppointment)copiedAppointment);
            if (linkedAppointments.isEmpty() || !AppointmentExtensionHandler.isMainAppointment((IAppointment)copiedAppointment)) {
                this.cloneAndModifyAppointment(copiedAppointment, targetTime, targetResource, sideBar);
                sideBar.removeMovePeriod((IPeriod)copiedAppointment);
                CopyHandler.clearCopiedAppointment();
                return;
            }
            AppointmentLinkOptionsDialog.CopyActionType copyAction = AppointmentLinkOptionsDialog.showCopyDialog((Shell)Display.getDefault().getActiveShell(), (List)linkedAppointments);
            switch (copyAction) {
                case KEEP_MAIN_ONLY: {
                    IAppointment newMainAppointment = this.cloneAndModifyAppointment(copiedAppointment, targetTime, targetResource, sideBar);
                    AppointmentExtensionHandler.setMainAppointmentId((IAppointment)newMainAppointment, (String)newMainAppointment.getId());
                    CoreModelServiceHolder.get().save((Identifiable)newMainAppointment);
                    break;
                }
                case COPY_ALL: {
                    IAppointment newMainAppointmentWithLinks = this.cloneAndModifyAppointment(copiedAppointment, targetTime, targetResource, sideBar);
                    LocalDateTime oldMainTime = copiedAppointment.getStartTime();
                    long minutesDifference = Duration.between(oldMainTime, targetTime).toMinutes();
                    AppointmentExtensionHandler.setMainAppointmentId((IAppointment)newMainAppointmentWithLinks, (String)newMainAppointmentWithLinks.getId());
                    ArrayList<String> newLinkedAppointmentIds = new ArrayList<String>();
                    for (IAppointment linkedAppointment : linkedAppointments) {
                        LocalDateTime oldLinkedTime = linkedAppointment.getStartTime();
                        LocalDateTime newLinkedTime = oldLinkedTime.plusMinutes(minutesDifference);
                        IAppointment newLinkedAppointment = this.cloneAndModifyAppointment(linkedAppointment, newLinkedTime, linkedAppointment.getSchedule(), sideBar);
                        AppointmentExtensionHandler.setMainAppointmentId((IAppointment)newLinkedAppointment, (String)newMainAppointmentWithLinks.getId());
                        AppointmentExtensionHandler.addLinkedAppointmentId((IAppointment)newLinkedAppointment, (String)newLinkedAppointment.getId());
                        newLinkedAppointment.setLastEdit(AppointmentDetailComposite.createTimeStamp());
                        CoreModelServiceHolder.get().save((Identifiable)newLinkedAppointment);
                        newLinkedAppointmentIds.add(newLinkedAppointment.getId());
                    }
                    AppointmentExtensionHandler.addMultipleLinkedAppointments((IAppointment)newMainAppointmentWithLinks, newLinkedAppointmentIds);
                    newMainAppointmentWithLinks.setLastEdit(AppointmentDetailComposite.createTimeStamp());
                    CoreModelServiceHolder.get().save((Identifiable)newMainAppointmentWithLinks);
                    break;
                }
            }
            sideBar.removeMovePeriod((IPeriod)copiedAppointment);
            CopyHandler.clearCopiedAppointment();
        } else {
            LoggerFactory.getLogger(this.getClass()).info("Fehler: Keine MoveInformation vorhanden");
        }
    }

    private void handleMoveInformation(SideBarComposite.MoveInformation moveInformation) {
        List<IPeriod> moveablePeriods = moveInformation.getMoveablePeriods();
        if (moveablePeriods.isEmpty()) {
            LoggerFactory.getLogger(this.getClass()).info("Fehler: Keine verschiebbaren Perioden vorhanden");
            return;
        }
        IAppointment mainAppointment = this.extractMainAppointment(moveablePeriods.get(0));
        if (mainAppointment == null) {
            LoggerFactory.getLogger(this.getClass()).info("Fehler: Kein Haupt-Termin gefunden");
            return;
        }
        String oldArea = mainAppointment.getSchedule();
        List linkedAppointments = AppointmentExtensionHandler.getLinkedAppointments((IAppointment)mainAppointment);
        if (linkedAppointments.isEmpty() || !AppointmentExtensionHandler.isMainAppointment((IAppointment)mainAppointment)) {
            LocalDateTime oldTime = mainAppointment.getStartTime();
            moveInformation.movePeriod((IPeriod)mainAppointment);
            LocalDateTime newTime = moveInformation.getDateTime();
            String newArea = mainAppointment.getSchedule();
            AppointmentHistoryServiceHolder.get().logAppointmentMove(mainAppointment, oldTime, newTime, oldArea, newArea);
        } else {
            AppointmentLinkOptionsDialog.MoveActionType moveAction = AppointmentLinkOptionsDialog.showMoveDialog((Shell)Display.getDefault().getActiveShell(), (List)linkedAppointments);
            switch (moveAction) {
                case KEEP_MAIN_ONLY: {
                    LocalDateTime oldTime = mainAppointment.getStartTime();
                    moveInformation.movePeriod((IPeriod)mainAppointment);
                    LocalDateTime newTime = moveInformation.getDateTime();
                    String newArea = mainAppointment.getSchedule();
                    AppointmentHistoryServiceHolder.get().logAppointmentMove(mainAppointment, oldTime, newTime, oldArea, newArea);
                    break;
                }
                case MOVE_ALL: {
                    LocalDateTime oldMainTime = mainAppointment.getStartTime();
                    moveInformation.movePeriod((IPeriod)mainAppointment);
                    LocalDateTime newMainTime = moveInformation.getDateTime();
                    this.moveLinkedAppointments(linkedAppointments, oldMainTime, newMainTime);
                    String newMainArea = mainAppointment.getSchedule();
                    AppointmentHistoryServiceHolder.get().logAppointmentMove(mainAppointment, oldMainTime, newMainTime, oldArea, newMainArea);
                    break;
                }
            }
        }
    }

    private void moveLinkedAppointments(List<IAppointment> linkedAppointments, LocalDateTime oldMainTime, LocalDateTime newMainAppointmentTime) {
        long minutesDifference = Duration.between(oldMainTime, newMainAppointmentTime).toMinutes();
        for (IAppointment linkedAppointment : linkedAppointments) {
            LocalDateTime oldLinkedTime = linkedAppointment.getStartTime();
            LocalDateTime newLinkedTime = oldLinkedTime.plusMinutes(minutesDifference);
            this.moveLinkedAppointment(linkedAppointment, newLinkedTime);
            ContextServiceHolder.get().postEvent("info/elexis/model/update", (Object)linkedAppointment);
        }
        this.eventBroker.post("info/elexis/model/update", (Object)linkedAppointments.get(0));
    }

    private void moveLinkedAppointment(IAppointment appointment, LocalDateTime newStartTime) {
        LocalDateTime oldStartTime = appointment.getStartTime();
        String oldArea = appointment.getSchedule();
        appointment.setStartTime(newStartTime);
        appointment.setEndTime(newStartTime.plusMinutes(appointment.getDurationMinutes().intValue()));
        appointment.setLastEdit(AppointmentDetailComposite.createTimeStamp());
        CoreModelServiceHolder.get().save((Identifiable)appointment);
        String newArea = appointment.getSchedule();
        ContextServiceHolder.get().postEvent("info/elexis/model/update", (Object)appointment);
        this.eventBroker.post("info/elexis/model/reload", IAppointment.class);
        AppointmentHistoryServiceHolder.get().logAppointmentMove(appointment, oldStartTime, newStartTime, oldArea, newArea);
    }

    private IAppointment extractMainAppointment(IPeriod period) {
        if (period instanceof IAppointment) {
            return (IAppointment)period;
        }
        return null;
    }

    private IAppointment cloneAndModifyAppointment(IAppointment originalAppointment, LocalDateTime newStartTime, String newResource, SideBarComposite sideBar) {
        IAppointmentService appointmentService = AppointmentServiceHolder.get();
        IAppointment clonedAppointment = appointmentService.clone(originalAppointment);
        clonedAppointment.setCreatedBy(originalAppointment.getCreatedBy());
        clonedAppointment.setCreated(originalAppointment.getCreated());
        clonedAppointment.setLastEdit(AppointmentDetailComposite.createTimeStamp());
        clonedAppointment.setStartTime(newStartTime);
        clonedAppointment.setEndTime(newStartTime.plusMinutes(originalAppointment.getDurationMinutes().intValue()));
        clonedAppointment.setSchedule(newResource);
        clonedAppointment.setReason(originalAppointment.getReason());
        CoreModelServiceHolder.get().save((Identifiable)clonedAppointment);
        ContextServiceHolder.get().postEvent("info/elexis/model/update", (Object)clonedAppointment);
        this.eventBroker.post("info/elexis/model/reload", IAppointment.class);
        AppointmentHistoryServiceHolder.get().logAppointmentCopy(originalAppointment, originalAppointment.getId());
        return clonedAppointment;
    }
}

