/*
 * Decompiled with CFR 0.152.
 */
package at.medevit.elexis.agenda.ui.function;

import at.medevit.elexis.agenda.ui.composite.IAgendaComposite;
import at.medevit.elexis.agenda.ui.function.AbstractBrowserFunction;
import ch.elexis.core.services.holder.ConfigServiceHolder;
import com.equo.chromium.swt.Browser;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class LoadResourcesFunction
extends AbstractBrowserFunction {
    private IAgendaComposite agendaComposite;
    private Gson gson;

    public LoadResourcesFunction(Browser browser, String name, IAgendaComposite agendaComposite) {
        super(browser, name);
        this.agendaComposite = agendaComposite;
        this.gson = new GsonBuilder().create();
    }

    public Object function(Object[] arguments) {
        Set<String> selectedResources = this.agendaComposite.getSelectedResources();
        String colorPrefs = ConfigServiceHolder.get().get("agenda/bereich/farben", null);
        Map<String, String> resourceColors = this.parseColorPreferences(colorPrefs);
        LinkedHashSet<Resource> _selectedResources = new LinkedHashSet<Resource>();
        int order = 0;
        for (String selectedResource : selectedResources) {
            String color = resourceColors.get(selectedResource);
            _selectedResources.add(new Resource(selectedResource, selectedResource, order++, color));
        }
        return this.gson.toJson(_selectedResources);
    }

    private Map<String, String> parseColorPreferences(String colorPrefs) {
        HashMap<String, String> resourceColors = new HashMap<String, String>();
        if (colorPrefs != null) {
            String[] stringArray = colorPrefs.split(";");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String assignment = stringArray[n2];
                String[] parts = assignment.split(":");
                if (parts.length == 2) {
                    resourceColors.put(parts[0], parts[1]);
                }
                ++n2;
            }
        }
        return resourceColors;
    }

    private class Resource {
        private String id;
        private String title;
        private int order;
        private String color;

        public Resource(String id, String title, int order, String color) {
            this.id = id;
            this.title = title;
            this.order = order;
            this.color = color;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + ((Object)((Object)this.getEnclosingInstance())).hashCode();
            result = 31 * result + Objects.hash(this.id, this.title);
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Resource other = (Resource)obj;
            if (!((Object)((Object)this.getEnclosingInstance())).equals((Object)other.getEnclosingInstance())) {
                return false;
            }
            return Objects.equals(this.id, other.id) && Objects.equals(this.title, other.title);
        }

        private LoadResourcesFunction getEnclosingInstance() {
            return LoadResourcesFunction.this;
        }
    }
}

