/*
 * Decompiled with CFR 0.152.
 */
package at.medevit.elexis.agenda.ui.handler;

import ch.elexis.agenda.composite.AppointmentDetailComposite;
import ch.elexis.core.model.IAppointment;
import ch.elexis.core.model.IPeriod;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.services.holder.ContextServiceHolder;
import ch.elexis.core.services.holder.CoreModelServiceHolder;
import ch.elexis.core.ui.e4.locks.AcquireLockBlockingUi;
import ch.elexis.core.ui.e4.locks.ILockHandler;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.util.Optional;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.ui.workbench.modeling.ESelectionService;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.slf4j.LoggerFactory;

public class SetStatusHandler {
    @Inject
    private ESelectionService selectionService;

    @Execute
    public Object execute(@Named(value="at.medevit.elexis.agenda.ui.command.parameter.statusId") String statusId) {
        Optional<IPeriod> period = this.getSelectedPeriod();
        period.ifPresent(p -> AcquireLockBlockingUi.aquireAndRun((Identifiable)p, (ILockHandler)new ILockHandler((IPeriod)p, statusId){
            private final /* synthetic */ IPeriod val$p;
            private final /* synthetic */ String val$statusId;
            {
                this.val$p = iPeriod;
                this.val$statusId = string;
            }

            public void lockFailed() {
            }

            public void lockAcquired() {
                IAppointment appointment = (IAppointment)this.val$p;
                appointment.setState(this.val$statusId);
                appointment.setLastEdit(AppointmentDetailComposite.createTimeStamp());
                CoreModelServiceHolder.get().save((Identifiable)appointment);
                ContextServiceHolder.get().postEvent("info/elexis/model/reload", IAppointment.class);
            }
        }));
        return null;
    }

    private Optional<IPeriod> getSelectedPeriod() {
        try {
            Object element;
            ISelection activeSelection = (ISelection)this.selectionService.getSelection();
            LoggerFactory.getLogger(this.getClass()).info("Set status [" + String.valueOf(activeSelection) + "]");
            if (activeSelection instanceof StructuredSelection && !((StructuredSelection)activeSelection).isEmpty() && (element = ((StructuredSelection)activeSelection).getFirstElement()) instanceof IPeriod) {
                return Optional.of((IPeriod)element);
            }
        }
        catch (Exception e) {
            LoggerFactory.getLogger(this.getClass()).error("Error setting status", (Throwable)e);
        }
        return Optional.empty();
    }
}

