/*
 * Decompiled with CFR 0.152.
 */
package at.medevit.elexis.agenda.ui.model;

import at.medevit.elexis.agenda.ui.rcprap.StateHistoryFormatterUtil;
import ch.elexis.core.model.IAppointment;
import ch.elexis.core.model.IContact;
import ch.elexis.core.model.IPeriod;
import ch.elexis.core.model.agenda.RecurringAppointment;
import ch.elexis.core.services.holder.AppointmentServiceHolder;
import ch.elexis.core.services.holder.CoreModelServiceHolder;
import ch.elexis.core.types.AppointmentState;
import ch.elexis.core.types.AppointmentType;
import org.slf4j.LoggerFactory;

public class Event {
    private String id;
    private String title;
    private String icon;
    private String start;
    private String end;
    private String borderColor;
    private String backgroundColor;
    private String textColor;
    private String rendering;
    private String description;
    private String resource;
    private boolean allDay = false;

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getStart() {
        return this.start;
    }

    public void setStart(String start) {
        this.start = start;
    }

    public String getEnd() {
        return this.end;
    }

    public void setEnd(String end) {
        this.end = end;
    }

    public String getBorderColor() {
        return this.borderColor;
    }

    public void setBorderColor(String borderColor) {
        this.borderColor = borderColor;
    }

    public String getBackgroundColor() {
        return this.backgroundColor;
    }

    public void setBackgroundColor(String backgroundColor) {
        this.backgroundColor = backgroundColor;
    }

    public String getTextColor() {
        return this.textColor;
    }

    public void setTextColor(String textColor) {
        this.textColor = textColor;
    }

    public String getRendering() {
        return this.rendering;
    }

    public void setRendering(String rendering) {
        this.rendering = rendering;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getResource() {
        return this.resource;
    }

    public void setResource(String resource) {
        this.resource = resource;
    }

    public boolean isAllDay() {
        return this.allDay;
    }

    public void setAllDay(boolean allDay) {
        this.allDay = allDay;
    }

    public void setIcon(String icon) {
        this.icon = icon;
    }

    public String getIcon() {
        return this.icon;
    }

    public static Event of(IPeriod iPeriod, IContact userContact) {
        Event ret = new Event();
        ret.id = iPeriod.getId();
        ret.start = iPeriod.getStartTime().toString();
        String string = ret.end = iPeriod.getEndTime() != null ? iPeriod.getEndTime().toString() : null;
        if (iPeriod instanceof IAppointment) {
            IAppointment termin = (IAppointment)iPeriod;
            ret.resource = termin.getSchedule();
            IAppointment rootTermin = null;
            if (termin.isRecurring() && (rootTermin = new RecurringAppointment(termin, CoreModelServiceHolder.get()).getRootAppoinemtent()) != null) {
                ret.icon = "ui-icon-arrowrefresh-1-w";
                ret.title = rootTermin.getSubjectOrPatient();
            } else {
                ret.title = termin.getSubjectOrPatient();
            }
            if (ret.title.isEmpty()) {
                ret.title = " ";
            }
            String stateHistory = termin.getStateHistoryFormatted("dd.MM.yyyy HH:mm:ss").replaceAll("\n", "<br />");
            stateHistory = StateHistoryFormatterUtil.replaceIdsWithLabels(stateHistory);
            String formattedStateHistory = StateHistoryFormatterUtil.formatStateHistory(stateHistory);
            ret.description = termin.getReason().replaceAll("\n", "<br />") + "<br /><br />" + formattedStateHistory;
            ret.borderColor = AppointmentServiceHolder.get().getContactConfiguredStateColor(userContact, termin.getState());
            ret.backgroundColor = AppointmentServiceHolder.get().getContactConfiguredTypeColor(userContact, termin.getType());
            ret.textColor = Event.getTextColor(ret.backgroundColor.substring(1));
            if (ret.end == null) {
                ret.allDay = true;
            }
        }
        return ret;
    }

    public static boolean isDayLimit(IPeriod iPeriod) {
        if (iPeriod instanceof IAppointment) {
            String type = ((IAppointment)iPeriod).getType();
            String status = ((IAppointment)iPeriod).getState();
            String emptyStateString = AppointmentServiceHolder.get().getState(AppointmentState.EMPTY);
            String reservedTypeString = AppointmentServiceHolder.get().getType(AppointmentType.BOOKED);
            return type.equals(reservedTypeString) && status.equals(emptyStateString);
        }
        return false;
    }

    public static String getTextColor(String bgColor) {
        try {
            int brightness;
            if (bgColor.startsWith("#")) {
                bgColor = bgColor.substring(1);
            }
            return (brightness = Event.getPerceivedBrightness(Integer.parseInt(bgColor.substring(0, 2), 16), Integer.parseInt(bgColor.substring(2, 4), 16), Integer.parseInt(bgColor.substring(4, 6), 16))) > 130 ? "#000000" : "#ffffff";
        }
        catch (NumberFormatException e) {
            LoggerFactory.getLogger(Event.class).warn("Backgound color of event [" + bgColor + "] is no valid color number");
            return "#ffffff";
        }
    }

    private static int getPerceivedBrightness(int red, int green, int blue) {
        return (int)Math.sqrt((double)(red * red) * 0.299 + (double)(green * green) * 0.587 + (double)(blue * blue) * 0.114);
    }
}

