/*
 * Decompiled with CFR 0.152.
 */
package at.medevit.elexis.agenda.ui.composite;

import at.medevit.elexis.agenda.ui.composite.IAgendaComposite;
import at.medevit.elexis.agenda.ui.composite.Messages;
import at.medevit.elexis.agenda.ui.composite.ParallelComposite;
import at.medevit.elexis.agenda.ui.composite.WeekComposite;
import at.medevit.elexis.agenda.ui.function.LoadEventTimeSpan;
import ch.elexis.agenda.util.AppointmentUtil;
import ch.elexis.core.model.IAppointment;
import ch.elexis.core.model.IDayMessage;
import ch.elexis.core.model.IPeriod;
import ch.elexis.core.model.IUser;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.model.agenda.Area;
import ch.elexis.core.services.holder.AppointmentServiceHolder;
import ch.elexis.core.services.holder.ConfigServiceHolder;
import ch.elexis.core.services.holder.CoreModelServiceHolder;
import ch.elexis.core.ui.e4.locks.AcquireLockBlockingUi;
import ch.elexis.core.ui.e4.locks.ILockHandler;
import ch.elexis.core.ui.e4.util.CoreUiUtil;
import ch.elexis.core.ui.icons.Images;
import ch.elexis.core.ui.util.SWTHelper;
import ch.elexis.core.utils.CoreUtil;
import ch.elexis.dialogs.RecurringAppointmentDialog;
import jakarta.inject.Inject;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.di.UIEventTopic;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.resource.FontDescriptor;
import org.eclipse.jface.resource.FontRegistry;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DateTime;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;

public class SideBarComposite
extends Composite {
    private IAgendaComposite agendaComposite;
    private List<String> selectedResources = new ArrayList<String>();
    private ComboViewer spanSizeCombo;
    private ToolBarManager menuManager;
    private Button scrollToNowCheck;
    private Button showWeekends;
    private Label showWeekendsLabel;
    private TableViewer moveTable;
    private List<IPeriod> movePeriods;
    private List<IAppointment> copyAppontment;
    private MoveInformation currentMoveInformation;
    private Composite areaComposite;
    @Inject
    private IEventBroker eventBroker;
    private DateTime calendar;
    private DateTimeFormatter yyyyMMdd = DateTimeFormatter.ofPattern("yyyyMMdd");
    private Text dayMessage;

    @Inject
    void user(@org.eclipse.e4.core.di.annotations.Optional IUser user) {
        if (user != null) {
            Display.getDefault().asyncExec(() -> {
                if (this.areaComposite != null && !this.areaComposite.isDisposed()) {
                    this.updateAreaComposite();
                }
            });
        }
    }

    public SideBarComposite(Composite parent, int style) {
        this(parent, false, style);
    }

    public SideBarComposite(Composite parent, boolean includeMove, int style) {
        super(parent, style);
        CoreUiUtil.injectServicesWithContext((Object)((Object)this));
        this.setBackground(Display.getDefault().getSystemColor(1));
        this.setBackgroundMode(2);
        this.setLayout((Layout)new GridLayout(1, true));
        this.menuManager = new ToolBarManager(0x800100);
        this.menuManager.add((IAction)new Action(">", 1){

            public void run() {
                if (">".equals(super.getText())) {
                    SideBarComposite.this.showContent();
                    super.setText("<");
                } else {
                    SideBarComposite.this.hideContent();
                    super.setText(">");
                }
                super.run();
            }
        });
        this.menuManager.createControl((Composite)this).setLayoutData((Object)new GridData(131072, 128, false, false));
        this.calendar = new DateTime((Composite)this, 17408);
        this.calendar.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (e.stateMask > 0 || CoreUtil.isMac()) {
                    SideBarComposite.this.agendaComposite.setSelectedDate(LocalDate.of(SideBarComposite.this.calendar.getYear(), SideBarComposite.this.calendar.getMonth() + 1, SideBarComposite.this.calendar.getDay()));
                }
                SideBarComposite.this.updateDayMessage();
            }
        });
        Label label = new Label((Composite)this, 0);
        String cfgName = "agenda-boldFont";
        FontRegistry fr = JFaceResources.getFontRegistry();
        if (!fr.hasValueFor(cfgName)) {
            FontDescriptor boldDescriptor = FontDescriptor.createFrom((Font)label.getFont()).setStyle(1);
            fr.put(cfgName, boldDescriptor.getFontData());
        }
        Font boldFont = fr.get(cfgName);
        label.setFont(boldFont);
        label.setText(Messages.AgendaUI_SideBar_Bereiche_Title);
        ScrolledComposite areaScrolledComposite = new ScrolledComposite((Composite)this, 512);
        areaScrolledComposite.setLayout((Layout)new FillLayout());
        areaScrolledComposite.setExpandVertical(true);
        areaScrolledComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        areaScrolledComposite.addListener(11, event -> areaScrolledComposite.setMinSize(this.areaComposite.computeSize(-1, -1)));
        this.areaComposite = new Composite((Composite)areaScrolledComposite, 0);
        this.areaComposite.setLayout((Layout)new GridLayout());
        this.updateAreaComposite();
        areaScrolledComposite.setContent((Control)this.areaComposite);
        label = new Label((Composite)this, 0);
        label.setFont(boldFont);
        label.setText("Tagesnachricht");
        this.dayMessage = SWTHelper.createText((Composite)this, (int)4, (int)512);
        GridData gd = (GridData)this.dayMessage.getLayoutData();
        gd.widthHint = this.calendar.computeSize((int)-1, (int)-1).x;
        this.dayMessage.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String tx = SideBarComposite.this.dayMessage.getText();
                LocalDate date = LocalDate.of(SideBarComposite.this.calendar.getYear(), SideBarComposite.this.calendar.getMonth() + 1, SideBarComposite.this.calendar.getDay());
                Optional message = CoreModelServiceHolder.get().load(date.format(SideBarComposite.this.yyyyMMdd), IDayMessage.class);
                if (message.isPresent()) {
                    ((IDayMessage)message.get()).setMessage(tx);
                    CoreModelServiceHolder.get().save((Identifiable)message.get());
                } else if (StringUtils.isNotBlank((CharSequence)tx)) {
                    IDayMessage newMessage = (IDayMessage)CoreModelServiceHolder.get().create(IDayMessage.class);
                    newMessage.setDate(date);
                    newMessage.setMessage(tx);
                    CoreModelServiceHolder.get().save((Identifiable)newMessage);
                }
            }
        });
        label = new Label((Composite)this, 0);
        label.setFont(boldFont);
        label.setText(Messages.AgendaUI_SideBar_steps);
        this.spanSizeCombo = new ComboViewer((Composite)this, 2048);
        this.spanSizeCombo.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.spanSizeCombo.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                return ((IAgendaComposite.AgendaSpanSize)((Object)element)).getLabel();
            }
        });
        this.spanSizeCombo.setInput((Object)IAgendaComposite.AgendaSpanSize.values());
        this.spanSizeCombo.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ISelection selection = event.getSelection();
                if (selection instanceof StructuredSelection && !selection.isEmpty()) {
                    SideBarComposite.this.agendaComposite.setSelectedSpanSize((IAgendaComposite.AgendaSpanSize)((Object)((StructuredSelection)selection).getFirstElement()));
                    SideBarComposite.this.saveConfigurationString("selectedSpanSize", ((IAgendaComposite.AgendaSpanSize)((Object)((StructuredSelection)selection).getFirstElement())).name());
                }
            }
        });
        label = new Label((Composite)this, 0);
        label.setFont(boldFont);
        label.setText(Messages.AgendaUI_SideBar_auto_scroll_to_now);
        this.scrollToNowCheck = new Button((Composite)this, 32);
        this.scrollToNowCheck.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SideBarComposite.this.agendaComposite.setScrollToNow(SideBarComposite.this.scrollToNowCheck.getSelection());
                SideBarComposite.this.saveConfigurationString("scrollToNow", Boolean.toString(SideBarComposite.this.scrollToNowCheck.getSelection()));
                super.widgetSelected(e);
            }
        });
        this.showWeekendsLabel = new Label((Composite)this, 0);
        this.showWeekendsLabel.setFont(boldFont);
        this.showWeekendsLabel.setText("Wochenenden anzeigen");
        this.showWeekends = new Button((Composite)this, 32);
        this.showWeekends.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SideBarComposite.this.agendaComposite.setShowWeekends(SideBarComposite.this.showWeekends.getSelection());
                SideBarComposite.this.saveConfigurationString("showWeekends", Boolean.toString(SideBarComposite.this.showWeekends.getSelection()));
                super.widgetSelected(e);
            }
        });
        Label separator = new Label((Composite)this, 258);
        separator.setLayoutData((Object)new GridData(768));
        Button btn = new Button((Composite)this, 0);
        btn.setText(Messages.AgendaUI_SideBar_create_new_series);
        btn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (e.getSource() instanceof Button) {
                    RecurringAppointmentDialog dlg = new RecurringAppointmentDialog(AppointmentServiceHolder.get().createAppointmentSeries());
                    dlg.open();
                }
            }
        });
        if (includeMove) {
            label = new Label((Composite)this, 0);
            label.setFont(boldFont);
            label.setText(Messages.AgendaUI_SideBar_move_date);
            label.setLayoutData((Object)new GridData(4, 1024, true, true));
            this.moveTable = new TableViewer((Composite)this, 2);
            this.moveTable.getTable().setLayoutData((Object)new GridData(4, 1024, true, false));
            this.moveTable.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
            this.moveTable.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

                public String getText(Object element) {
                    if (element instanceof IPeriod) {
                        return ((IPeriod)element).getLabel();
                    }
                    return super.getText(element);
                }
            });
            MenuManager menuManager = new MenuManager();
            menuManager.add((IAction)new Action(){

                public String getText() {
                    return Messages.AgendaUI_SideBar_abort_move_date;
                }

                public ImageDescriptor getImageDescriptor() {
                    return Images.IMG_DELETE.getImageDescriptor();
                }

                public void run() {
                    IStructuredSelection selection = SideBarComposite.this.moveTable.getStructuredSelection();
                    if (selection != null && !selection.isEmpty()) {
                        for (Object selected : selection.toList()) {
                            if (!(selected instanceof IPeriod)) continue;
                            SideBarComposite.this.removeMovePeriod((IPeriod)selected);
                        }
                    }
                }
            });
            Menu contextMenu = menuManager.createContextMenu((Control)this.moveTable.getTable());
            this.moveTable.getTable().setMenu(contextMenu);
            gd = new GridData(16384, 1024, false, false);
            gd.widthHint = 150;
            this.moveTable.getTable().setLayoutData((Object)gd);
            this.movePeriods = new ArrayList<IPeriod>();
            this.copyAppontment = new ArrayList<IAppointment>();
        }
        this.hideContent();
    }

    private void updateAreaComposite() {
        Control[] controlArray = this.areaComposite.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control control = controlArray[n2];
            if (control instanceof Button && !control.isDisposed()) {
                control.setVisible(false);
                control.dispose();
            }
            ++n2;
        }
        List areas = AppointmentServiceHolder.get().getAoboAreas();
        for (Area area : areas) {
            Button btn = new Button(this.areaComposite, 32);
            btn.setText(area.getName());
            btn.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    if (e.getSource() instanceof Button) {
                        if (((Button)e.getSource()).getSelection()) {
                            SideBarComposite.this.selectedResources.add(((Button)e.getSource()).getText());
                        } else {
                            SideBarComposite.this.selectedResources.remove(((Button)e.getSource()).getText());
                        }
                        SideBarComposite.this.saveSelectedResources();
                    }
                }
            });
        }
        this.areaComposite.layout();
        this.areaComposite.pack();
        if (this.agendaComposite != null) {
            this.loadSelectedResources();
            this.agendaComposite.setSelectedResources(this.selectedResources);
        }
    }

    private void updateDayMessage() {
        LocalDate date = LocalDate.of(this.calendar.getYear(), this.calendar.getMonth() + 1, this.calendar.getDay());
        Optional message = CoreModelServiceHolder.get().load(date.format(this.yyyyMMdd), IDayMessage.class);
        if (message.isPresent()) {
            this.dayMessage.setText(((IDayMessage)message.get()).getMessage());
        } else {
            this.dayMessage.setText("");
        }
    }

    @Inject
    @org.eclipse.e4.core.di.annotations.Optional
    public void loadDate(@UIEventTopic(value="info/elexis/agenda/loadtimespan") LoadEventTimeSpan timespan) {
        if (timespan != null && this.calendar != null && !this.calendar.isDisposed() && !LocalDate.of(this.calendar.getYear(), this.calendar.getMonth() + 1, this.calendar.getDay()).equals(timespan.getFrom())) {
            if (this.agendaComposite instanceof WeekComposite && timespan.isWeek()) {
                this.calendar.setDate(timespan.getFrom().getYear(), timespan.getFrom().getMonthValue() - 1, timespan.getFrom().getDayOfMonth());
            } else if (this.agendaComposite instanceof ParallelComposite && timespan.isDay()) {
                this.calendar.setDate(timespan.getFrom().getYear(), timespan.getFrom().getMonthValue() - 1, timespan.getFrom().getDayOfMonth());
            }
            this.updateDayMessage();
        }
    }

    private void hideContent() {
        Control[] controls;
        Control[] controlArray = controls = this.getChildren();
        int n = controls.length;
        int n2 = 0;
        while (n2 < n) {
            Control control = controlArray[n2];
            if (!(control instanceof ToolBar)) {
                GridData gridData = (GridData)control.getLayoutData();
                if (gridData == null) {
                    gridData = new GridData();
                    control.setLayoutData((Object)gridData);
                }
                control.setVisible(false);
                gridData.exclude = true;
            }
            ++n2;
        }
        this.getParent().layout();
    }

    private void showContent() {
        Control[] controls;
        Control[] controlArray = controls = this.getChildren();
        int n = controls.length;
        int n2 = 0;
        while (n2 < n) {
            Control control = controlArray[n2];
            GridData gridData = (GridData)control.getLayoutData();
            if (gridData == null) {
                gridData = new GridData();
                control.setLayoutData((Object)gridData);
            }
            control.setVisible(true);
            gridData.exclude = false;
            ++n2;
        }
        if (!(this.agendaComposite instanceof WeekComposite)) {
            this.showWeekendsLabel.setVisible(false);
            ((GridData)this.showWeekendsLabel.getLayoutData()).exclude = true;
            this.showWeekends.setVisible(false);
            ((GridData)this.showWeekends.getLayoutData()).exclude = true;
        }
        this.getParent().layout();
        this.updateDayMessage();
    }

    public void setAgendaComposite(IAgendaComposite agendaComposite) {
        String value;
        this.agendaComposite = agendaComposite;
        this.loadSelectedResources();
        agendaComposite.setSelectedResources(this.selectedResources);
        String selectedSpanSize = this.loadConfigurationString("selectedSpanSize");
        if (!selectedSpanSize.isEmpty()) {
            this.spanSizeCombo.setSelection((ISelection)new StructuredSelection((Object)IAgendaComposite.AgendaSpanSize.valueOf(selectedSpanSize)));
        }
        if ((value = this.loadConfigurationString("scrollToNow")) != null && value.equalsIgnoreCase("true")) {
            this.scrollToNowCheck.setSelection(true);
            agendaComposite.setScrollToNow(true);
        }
        if (agendaComposite instanceof WeekComposite && (value = this.loadConfigurationString("showWeekends")) != null && value.equalsIgnoreCase("true")) {
            this.showWeekends.setSelection(true);
            agendaComposite.setShowWeekends(true);
        }
    }

    private void saveSelectedResources() {
        this.agendaComposite.setSelectedResources(this.selectedResources);
        StringBuilder sb = new StringBuilder();
        for (String resource : this.selectedResources) {
            if (sb.length() > 0) {
                sb.append("|");
            }
            sb.append(resource);
        }
        this.saveConfigurationString("selectedResources", sb.toString());
    }

    private void loadSelectedResources() {
        String loadedResources = this.loadConfigurationString("selectedResources");
        String[] parts = loadedResources.split("\\|");
        if (parts.length > 0 && !parts[0].isEmpty()) {
            this.selectedResources.clear();
            this.selectedResources.addAll(Arrays.asList(parts));
            ArrayList<String> selections = new ArrayList<String>();
            Control[] controlArray = this.areaComposite.getChildren();
            int n = controlArray.length;
            int n2 = 0;
            while (n2 < n) {
                Control child = controlArray[n2];
                if (child instanceof Button) {
                    if (this.selectedResources.contains(((Button)child).getText())) {
                        ((Button)child).setSelection(true);
                        selections.add(((Button)child).getText());
                    } else {
                        ((Button)child).setSelection(false);
                    }
                }
                ++n2;
            }
            this.selectedResources = selections;
        }
    }

    private void saveConfigurationString(String configKey, String value) {
        ConfigServiceHolder.get().setActiveUserContact("at.medevit.elexis.agenda.ui/" + this.agendaComposite.getConfigId() + "/" + configKey, value);
    }

    private String loadConfigurationString(String configKey) {
        return ConfigServiceHolder.get().getActiveUserContact("at.medevit.elexis.agenda.ui/" + this.agendaComposite.getConfigId() + "/" + configKey, "");
    }

    public void addMovePeriod(IPeriod period) {
        if (this.moveTable != null && !this.moveTable.getTable().isDisposed()) {
            if (!this.movePeriods.contains(period)) {
                this.movePeriods.add(period);
            }
            this.moveTable.setInput(this.movePeriods);
        }
    }

    public void addcopyAppointment(IAppointment appointment) {
        if (this.moveTable != null && !this.moveTable.getTable().isDisposed()) {
            this.copyAppontment.clear();
            if (!this.copyAppontment.contains(appointment)) {
                this.copyAppontment.add(appointment);
            }
            this.moveTable.setInput(this.copyAppontment);
        }
    }

    public void removeMovePeriod(IPeriod period) {
        if (this.moveTable != null && !this.moveTable.getTable().isDisposed()) {
            this.movePeriods.remove(period);
            this.moveTable.setInput(this.movePeriods);
            this.copyAppontment.remove(period);
        }
    }

    public Optional<MoveInformation> getMoveInformation() {
        if (this.currentMoveInformation != null) {
            this.currentMoveInformation.setMoveablePeriods(this.movePeriods);
        }
        return Optional.ofNullable(this.currentMoveInformation);
    }

    public List<IAppointment> getCopyInformation() {
        if (this.copyAppontment != null && !this.copyAppontment.isEmpty()) {
            return this.copyAppontment;
        }
        return null;
    }

    public void setMoveInformation(LocalDateTime date, String resource) {
        this.currentMoveInformation = new MoveInformation(this, date, resource);
    }

    public static class MoveInformation {
        private SideBarComposite sideBar;
        private LocalDateTime dateTime;
        private String resource;
        private List<IPeriod> moveablePeriods;

        public MoveInformation(SideBarComposite sideBar, LocalDateTime dateTime, String resource) {
            this.sideBar = sideBar;
            this.dateTime = dateTime;
            this.resource = resource;
        }

        public void setMoveablePeriods(List<IPeriod> periods) {
            this.moveablePeriods = new ArrayList<IPeriod>(periods);
        }

        public List<IPeriod> getMoveablePeriods() {
            return this.moveablePeriods;
        }

        public LocalDateTime getDateTime() {
            return this.dateTime;
        }

        public String getResource() {
            return this.resource;
        }

        public void movePeriod(final IPeriod iPeriod) {
            if (iPeriod instanceof IAppointment && AppointmentUtil.isLocked((IAppointment)((IAppointment)iPeriod))) {
                if (this.sideBar != null && !this.sideBar.isDisposed()) {
                    this.sideBar.removeMovePeriod(iPeriod);
                }
                return;
            }
            AcquireLockBlockingUi.aquireAndRun((Identifiable)iPeriod, (ILockHandler)new ILockHandler(){

                public void lockAcquired() {
                    iPeriod.setStartTime(dateTime);
                    if (iPeriod instanceof IAppointment) {
                        ((IAppointment)iPeriod).setSchedule(resource);
                    }
                    CoreModelServiceHolder.get().save((Identifiable)iPeriod);
                    Display.getDefault().timerExec(250, new Runnable(){

                        @Override
                        public void run() {
                            if (sideBar != null && !sideBar.isDisposed()) {
                                sideBar.removeMovePeriod(iPeriod);
                                sideBar.eventBroker.post("info/elexis/model/reload", IAppointment.class);
                            }
                        }
                    });
                }

                public void lockFailed() {
                }
            });
        }
    }
}

