/*
 * Decompiled with CFR 0.152.
 */
package at.medevit.elexis.agenda.ui.handler;

import at.medevit.elexis.agenda.ui.function.LoadEventsFunction;
import at.medevit.elexis.agenda.ui.utils.PdfUtils;
import at.medevit.elexis.agenda.ui.view.AgendaView;
import at.medevit.elexis.agenda.ui.xml.AreaPeriodsLetter;
import ch.elexis.core.model.IAppointment;
import ch.elexis.core.model.IPeriod;
import ch.elexis.core.services.holder.ConfigServiceHolder;
import jakarta.inject.Named;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.slf4j.LoggerFactory;

public class PrintSelectedAgendaHandler {
    @Execute
    public Object execute(MPart part, @Named(value="activeShell") Shell shell) {
        if (part.getObject() instanceof AgendaView) {
            AgendaView agendaView = (AgendaView)part.getObject();
            LoadEventsFunction loadEventsFunction = agendaView.getLoadEventsFunction();
            List periods = loadEventsFunction.getCurrentPeriods();
            Map<String, List<IPeriod>> areaPeriodMap = this.getAreaPeriodMap(periods);
            for (String area : areaPeriodMap.keySet()) {
                File file;
                block19: {
                    AreaPeriodsLetter letter = AreaPeriodsLetter.of((String)area, areaPeriodMap.get(area));
                    ArrayList<Map<String, String>> appointments = new ArrayList<Map<String, String>>();
                    HashMap<String, String> colors = new HashMap<String, String>();
                    for (IPeriod period : areaPeriodMap.get(area)) {
                        if (!(period instanceof IAppointment)) continue;
                        IAppointment appointment = (IAppointment)period;
                        String type = appointment.getType();
                        String typeColor = this.getColorForType(type);
                        if ("gesperrt".equals(type)) continue;
                        HashMap<String, String> appointmentData = new HashMap<String, String>();
                        appointmentData.put("Datum", appointment.getStartTime().toLocalDate().toString());
                        appointmentData.put("Area", letter.getArea());
                        appointmentData.put("ID", appointment.getId());
                        appointmentData.put("Von", appointment.getStartTime().toLocalTime().toString());
                        if (appointment.getEndTime() != null) {
                            appointmentData.put("Bis", appointment.getEndTime().toLocalTime().toString());
                        } else {
                            appointmentData.put("Bis", null);
                        }
                        appointmentData.put("Personalien", appointment.getSubjectOrPatient());
                        appointmentData.put("Grund", appointment.getReason());
                        appointments.add(appointmentData);
                        colors.put(appointment.getId(), typeColor != null ? typeColor : "FFFFFFFF");
                    }
                    if (appointments.isEmpty()) continue;
                    FileOutputStream fout = null;
                    file = null;
                    try {
                        try {
                            file = File.createTempFile(letter.getArea().replaceAll("\\s+", "_") + "_", ".pdf");
                            fout = new FileOutputStream(file);
                            PdfUtils.saveFile(fout, appointments, colors);
                        }
                        catch (IOException e) {
                            Display.getDefault().syncExec(() -> MessageDialog.openError((Shell)shell, (String)"Fehler", (String)("Fehler beim PDF anlegen.\n" + e.getMessage())));
                            LoggerFactory.getLogger(this.getClass()).error("Error creating PDF", (Throwable)e);
                            if (fout != null) {
                                try {
                                    fout.close();
                                }
                                catch (IOException iOException) {}
                            }
                            break block19;
                        }
                    }
                    catch (Throwable throwable) {
                        if (fout != null) {
                            try {
                                fout.close();
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                        }
                        throw throwable;
                    }
                    if (fout != null) {
                        try {
                            fout.close();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                }
                if (file == null) continue;
                Program.launch((String)file.getAbsolutePath());
            }
        }
        return null;
    }

    private String getColorForType(String type) {
        String colorDesc = ConfigServiceHolder.getUser((String)("agenda/farben/typ/" + type), (String)"FFFFFFFF");
        return colorDesc;
    }

    private Map<String, List<IPeriod>> getAreaPeriodMap(List<IPeriod> periods) {
        if (periods != null && !periods.isEmpty()) {
            if (periods.get(0) instanceof IAppointment) {
                HashMap<String, List<IPeriod>> ret = new HashMap<String, List<IPeriod>>();
                for (IPeriod iPeriod : periods) {
                    String area = ((IAppointment)iPeriod).getSchedule();
                    ArrayList<IPeriod> list = (ArrayList<IPeriod>)ret.get(area);
                    if (list == null) {
                        list = new ArrayList<IPeriod>();
                    }
                    list.add(iPeriod);
                    ret.put(area, list);
                }
                return ret;
            }
            throw new IllegalStateException("Can not determine area of period " + String.valueOf(periods.get(0)));
        }
        return Collections.emptyMap();
    }
}

