/*
 * Decompiled with CFR 0.152.
 */
package at.medevit.elexis.agenda.ui.utils;

import be.quodlibet.boxable.BaseTable;
import be.quodlibet.boxable.Cell;
import be.quodlibet.boxable.HorizontalAlignment;
import be.quodlibet.boxable.Row;
import be.quodlibet.boxable.line.LineStyle;
import java.awt.Color;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.pdmodel.font.PDType0Font;
import org.apache.pdfbox.pdmodel.font.PDType1Font;
import org.slf4j.LoggerFactory;

public class PdfUtils {
    public static void saveFile(FileOutputStream fout, List<Map<String, String>> appointments, Map<String, String> colors) throws IOException {
        appointments.sort(Comparator.comparing(a -> (String)a.get("Von")));
        Throwable throwable = null;
        Object var4_5 = null;
        try (PDDocument document = new PDDocument();){
            PDPage page = new PDPage(new PDRectangle(PDRectangle.A4.getHeight(), PDRectangle.A4.getWidth()));
            document.addPage(page);
            PDPageContentStream contentStream = new PDPageContentStream(document, page);
            float yPosDescriptionEnd = PdfUtils.writeHeader(contentStream, page, appointments);
            contentStream.close();
            PdfUtils.createDataTable(document, appointments, colors, yPosDescriptionEnd);
            PdfUtils.addPageNumbers(document);
            document.save((OutputStream)fout);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private static void createDataTable(PDDocument doc, List<Map<String, String>> appointments, Map<String, String> colors, float startY) throws IOException {
        PDPage page = doc.getPage(0);
        float margin = 50.0f;
        float tableWidth = page.getMediaBox().getWidth() - 2.0f * margin;
        float yPosition = startY;
        Object font = PdfUtils.checkUnicodeSupport((PDFont)PDType1Font.HELVETICA, appointments.toString()) ? PDType1Font.HELVETICA : PdfUtils.getUnicodeFont(doc);
        List allDayAppointments = appointments.stream().filter(m -> m.get("Bis") == null).collect(Collectors.toList());
        BaseTable allDayTable = new BaseTable(yPosition, startY, margin, tableWidth, margin, doc, page, true, true);
        PdfUtils.addAllDayTableHeader(allDayTable);
        for (Map appointment : allDayAppointments) {
            float rowHeight = PdfUtils.addAllDayAppointmentRow(appointment, allDayTable, (PDFont)font, tableWidth, colors);
            yPosition -= rowHeight;
        }
        allDayTable.draw();
        List dayAppointments = appointments.stream().filter(m -> m.get("Bis") != null).collect(Collectors.toList());
        BaseTable table = new BaseTable(yPosition -= 30.0f, yPosition, margin, tableWidth, margin, doc, page, true, true);
        PdfUtils.addTableHeader(table);
        for (Map appointment : dayAppointments) {
            float rowHeight = PdfUtils.addAppointmentRow(appointment, table, (PDFont)font, tableWidth, colors);
            yPosition -= rowHeight;
        }
        table.draw();
        int pageCount = doc.getNumberOfPages();
        int i = 0;
        while (i < pageCount) {
            PDPage tablePage = doc.getPage(i);
            PDPageContentStream tableContentStream = new PDPageContentStream(doc, tablePage, PDPageContentStream.AppendMode.APPEND, true);
            PdfUtils.writeHeader(tableContentStream, tablePage, appointments);
            tableContentStream.close();
            ++i;
        }
    }

    private static float addAllDayAppointmentRow(Map<String, String> appointment, BaseTable table, PDFont font, float tableWidth, Map<String, String> colors) {
        float rowHeight = 15.0f;
        Row dataRow = table.createRow(rowHeight);
        String[] stringArray = new String[]{"Ganzer Tag", "Personalien", "Grund"};
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String key = stringArray[n2];
            String text = appointment.get(key);
            text = text != null ? text.replaceAll("[\\r\\n]", " ") : "";
            Cell cell = dataRow.createCell(PdfUtils.columnWidth(key), text != null ? text : "");
            cell.setFont(font);
            cell.setFontSize(10.0f);
            String id = appointment.get("ID");
            if (id != null && colors.containsKey(id)) {
                cell.setFillColor(PdfUtils.getColorWithAlpha(colors.get(id)));
            } else {
                cell.setFillColor(Color.WHITE);
            }
            cell.setAlign(HorizontalAlignment.LEFT);
            cell.setBorderStyle(new LineStyle(Color.WHITE, 0.0f));
            cell.setTopPadding(2.0f);
            cell.setBottomPadding(2.0f);
            rowHeight = cell.getHeight();
            ++n2;
        }
        return rowHeight;
    }

    private static float addAppointmentRow(Map<String, String> appointment, BaseTable table, PDFont font, float tableWidth, Map<String, String> colors) {
        float rowHeight = 15.0f;
        Row dataRow = table.createRow(rowHeight);
        String[] stringArray = new String[]{"Von", "Bis", "Personalien", "Grund"};
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String key = stringArray[n2];
            String text = appointment.get(key);
            if (text != null) {
                text = text.replaceAll("[\\r\\n]", " ");
            }
            Cell cell = dataRow.createCell(PdfUtils.columnWidth(key), text != null ? text : "");
            cell.setFont(font);
            cell.setFontSize(10.0f);
            String id = appointment.get("ID");
            if (id != null && colors.containsKey(id)) {
                cell.setFillColor(PdfUtils.getColorWithAlpha(colors.get(id)));
            } else {
                cell.setFillColor(Color.WHITE);
            }
            cell.setAlign(HorizontalAlignment.LEFT);
            cell.setBorderStyle(new LineStyle(Color.WHITE, 0.0f));
            cell.setTopPadding(2.0f);
            cell.setBottomPadding(2.0f);
            rowHeight = cell.getHeight();
            ++n2;
        }
        return rowHeight;
    }

    private static float columnWidth(String columnName) {
        switch (columnName) {
            case "Bis": 
            case "Von": {
                return 5.0f;
            }
            case "Personalien": {
                return 30.0f;
            }
            case "Grund": {
                return 60.0f;
            }
            case "Ganzer Tag": {
                return 10.0f;
            }
        }
        return 10.0f;
    }

    private static void addAllDayTableHeader(BaseTable table) throws IOException {
        Row headerRow = table.createRow(15.0f);
        String[] stringArray = new String[]{"Ganzer Tag", "Personalien", "Grund"};
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String header = stringArray[n2];
            Cell cell = headerRow.createCell(PdfUtils.columnWidth(header), header);
            cell.setFont((PDFont)PDType1Font.HELVETICA_BOLD);
            cell.setFontSize(10.0f);
            cell.setAlign(HorizontalAlignment.LEFT);
            cell.setBorderStyle(new LineStyle(Color.WHITE, 0.0f));
            cell.setTopPadding(2.0f);
            cell.setBottomPadding(2.0f);
            ++n2;
        }
        table.addHeaderRow(headerRow);
    }

    private static void addTableHeader(BaseTable table) throws IOException {
        Row headerRow = table.createRow(15.0f);
        String[] stringArray = new String[]{"Von", "Bis", "Personalien", "Grund"};
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String header = stringArray[n2];
            Cell cell = headerRow.createCell(PdfUtils.columnWidth(header), header);
            cell.setFont((PDFont)PDType1Font.HELVETICA_BOLD);
            cell.setFontSize(10.0f);
            cell.setAlign(HorizontalAlignment.LEFT);
            cell.setBorderStyle(new LineStyle(Color.WHITE, 0.0f));
            cell.setTopPadding(2.0f);
            cell.setBottomPadding(2.0f);
            ++n2;
        }
        table.addHeaderRow(headerRow);
    }

    private static Color getColorWithAlpha(String colorStr) {
        int r = Integer.parseInt(colorStr.substring(0, 2), 16);
        int g = Integer.parseInt(colorStr.substring(2, 4), 16);
        int b = Integer.parseInt(colorStr.substring(4, 6), 16);
        double alpha = 0.6;
        r = (int)((double)r + (double)(255 - r) * alpha);
        g = (int)((double)g + (double)(255 - g) * alpha);
        b = (int)((double)b + (double)(255 - b) * alpha);
        return new Color(r, g, b);
    }

    private static float writeHeader(PDPageContentStream contentStream, PDPage page, List<Map<String, String>> appointments) throws IOException {
        SimpleDateFormat dateFormat = new SimpleDateFormat("dd.MM.yyyy");
        SimpleDateFormat inputDateFormat = new SimpleDateFormat("yyyy-MM-dd");
        contentStream.beginText();
        contentStream.setFont((PDFont)PDType1Font.HELVETICA, 8.0f);
        String area = appointments.isEmpty() ? "Unbekannt" : appointments.get(0).get("Area");
        float yPos = page.getMediaBox().getHeight() - 50.0f;
        contentStream.newLineAtOffset(page.getMediaBox().getWidth() - 255.0f, yPos);
        String datumStr = appointments.get(0).get("Datum");
        Date datum = null;
        try {
            datum = inputDateFormat.parse(datumStr);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        contentStream.showText("Agenda Bereich " + area + ", " + (datum != null ? dateFormat.format(datum) : "Unbekannt") + " erstellt am " + dateFormat.format(Calendar.getInstance().getTime()));
        contentStream.endText();
        contentStream.setStrokingColor(Color.BLACK);
        contentStream.setLineWidth(0.5f);
        contentStream.moveTo(50.0f, yPos - 3.0f);
        contentStream.lineTo(page.getMediaBox().getWidth() - 50.0f, yPos - 3.0f);
        contentStream.stroke();
        return yPos - 10.0f;
    }

    private static void addPageNumbers(PDDocument document) throws IOException {
        int totalPages = document.getNumberOfPages();
        int i = 0;
        while (i < totalPages) {
            PDPage page = document.getPage(i);
            PDPageContentStream footerContentStream = new PDPageContentStream(document, page, PDPageContentStream.AppendMode.APPEND, true);
            float lineYPos = 40.0f;
            footerContentStream.setStrokingColor(Color.BLACK);
            footerContentStream.setLineWidth(0.5f);
            footerContentStream.moveTo(50.0f, lineYPos);
            footerContentStream.lineTo(page.getMediaBox().getWidth() - 50.0f, lineYPos);
            footerContentStream.stroke();
            footerContentStream.beginText();
            footerContentStream.setFont((PDFont)PDType1Font.HELVETICA, 8.0f);
            footerContentStream.newLineAtOffset(page.getMediaBox().getWidth() - 100.0f, 30.0f);
            footerContentStream.showText("Seite " + (i + 1) + " von " + totalPages);
            footerContentStream.endText();
            footerContentStream.close();
            ++i;
        }
    }

    private static boolean checkUnicodeSupport(PDFont font, String text) throws IOException {
        try {
            font.encode(text);
            return true;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    private static PDFont getUnicodeFont(PDDocument document) {
        InputStream fontStream = PDFont.class.getResourceAsStream("/org/apache/pdfbox/resources/ttf/LiberationSans-Regular.ttf");
        if (fontStream == null) {
            LoggerFactory.getLogger(PdfUtils.class).warn("path to resource is null");
        }
        try {
            return PDType0Font.load((PDDocument)document, (InputStream)fontStream);
        }
        catch (IOException e) {
            LoggerFactory.getLogger(PdfUtils.class).error("could not load font into document", (Throwable)e);
            return null;
        }
    }
}

