/*
 * Decompiled with CFR 0.152.
 */
package at.medevit.elexis.aerztekasse.ui.preferences;

import ch.elexis.core.l10n.Messages;
import ch.elexis.core.model.IContact;
import ch.elexis.core.model.IMandator;
import ch.elexis.core.services.holder.CoreModelServiceHolder;
import ch.elexis.core.ui.preferences.ConfigServicePreferenceStore;
import ch.elexis.core.ui.preferences.inputs.ComboFieldEditor;
import ch.elexis.core.ui.preferences.inputs.PasswordFieldEditor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jface.preference.DirectoryFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.StringFieldEditor;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class AerztekassePreferences
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    public static final String CFG_OUTPUTDIR = "aerztekasse/outputdir";
    public static final String ID = "at.medevit.elexis.aerztekasse.ui.preferences";
    private String[] deploymentLevels;

    public AerztekassePreferences() {
        super(1);
    }

    public void init(IWorkbench workbench) {
        boolean snapshotMode;
        this.setPreferenceStore((IPreferenceStore)new ConfigServicePreferenceStore(ConfigServicePreferenceStore.Scope.GLOBAL));
        boolean bl = snapshotMode = System.getProperty("aerztekasseSnapshotMode") != null;
        if (snapshotMode) {
            this.deploymentLevels = new String[]{"PREPROD", "PROD"};
        }
    }

    protected void createFieldEditors() {
        this.addField((FieldEditor)new DirectoryFieldEditor("net/medshare/connector/finance/aerztekasse/archivedir", Messages.Core_ArchiveDir, this.getFieldEditorParent()));
        this.addField((FieldEditor)new DirectoryFieldEditor("net/medshare/connector/finance/aerztekasse/errordir", Messages.Core_Error_Directory, this.getFieldEditorParent()));
        this.addField((FieldEditor)new StringFieldEditor("net/medshare/connector/finance/aerztekasse/username", Messages.Core_Username, this.getFieldEditorParent()));
        this.addField((FieldEditor)new PasswordFieldEditor("net/medshare/connector/finance/aerztekasse/password", Messages.Core_Password, this.getFieldEditorParent()));
        Label separator = new Label(this.getFieldEditorParent(), 258);
        separator.setLayoutData((Object)new GridData(4, 0x1000000, true, false, ((GridLayout)this.getFieldEditorParent().getLayout()).numColumns + 1, 1));
        Set<IContact> billerSet = this.getBillerSet();
        ArrayList<IContact> sortedBillerList = new ArrayList<IContact>(billerSet);
        Collections.sort(sortedBillerList, new Comparator<IContact>(){

            @Override
            public int compare(IContact o1, IContact o2) {
                IContact r1 = o1;
                IContact r2 = o2;
                return AerztekassePreferences.this.getLabel(r1).compareToIgnoreCase(AerztekassePreferences.this.getLabel(r2));
            }
        });
        for (IContact biller : sortedBillerList) {
            this.addField((FieldEditor)new StringFieldEditor("net/medshare/connector/finance/aerztekasse/account/" + biller.getId(), Messages.Prefs_Contractor + " " + this.getLabel(biller), this.getFieldEditorParent()));
        }
        if (this.deploymentLevels != null) {
            separator = new Label(this.getFieldEditorParent(), 258);
            separator.setLayoutData((Object)new GridData(4, 0x1000000, true, false, ((GridLayout)this.getFieldEditorParent().getLayout()).numColumns + 1, 1));
            ComboFieldEditor cmbDeployLevel = new ComboFieldEditor("net/medshare/connector/finance/aerztekasse/deploymentlevel", Messages.Prefs_DeplymentLevel, this.deploymentLevels, this.getFieldEditorParent());
            this.addField((FieldEditor)cmbDeployLevel);
        }
    }

    private String getLabel(IContact contact) {
        StringBuilder sb = new StringBuilder();
        sb.append(contact.getDescription1()).append(" ").append(StringUtils.defaultString((String)contact.getDescription2()));
        if (!StringUtils.isBlank((CharSequence)contact.getDescription3())) {
            sb.append("(").append(contact.getDescription3()).append(")");
        }
        return sb.toString();
    }

    private Set<IContact> getBillerSet() {
        HashSet<IContact> ret = new HashSet<IContact>();
        CoreModelServiceHolder.get().getQuery(IMandator.class).execute().stream().filter(m -> m.isActive()).map(m -> m.getBiller()).forEach(c -> {
            boolean bl = ret.add((IContact)c);
        });
        return ret;
    }
}

